/*
 * Decompiled with CFR 0.152.
 */
package com.ishland.c2me.threading.chunkio.common;

import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.class_1923;
import net.minecraft.class_1944;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2791;
import net.minecraft.class_2804;
import net.minecraft.class_3218;
import net.minecraft.class_3562;
import net.minecraft.class_3568;
import net.minecraft.class_4076;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AsyncSerializationManager {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"C2ME Async Serialization Manager");
    private static final ThreadLocal<ArrayDeque<Scope>> scopeHolder = ThreadLocal.withInitial(ArrayDeque::new);

    public static void push(Scope scope) {
        scopeHolder.get().push(scope);
    }

    public static Scope getScope(class_1923 pos) {
        Scope scope = scopeHolder.get().peek();
        if (pos == null) {
            return scope;
        }
        if (scope != null) {
            if (scope.pos.equals((Object)pos)) {
                return scope;
            }
            LOGGER.error("Scope position mismatch! Expected: {} but got {}. This will impact stability. Incompatible mods?", new Object[]{scope.pos, pos, new Throwable()});
        }
        return null;
    }

    public static void pop(Scope scope) {
        if (scope != scopeHolder.get().peek()) {
            throw new IllegalArgumentException("Scope mismatch");
        }
        scopeHolder.get().pop();
    }

    public static class Scope {
        public final class_1923 pos;
        public final Map<class_1944, class_3562> lighting;
        public final Set<class_2338> blockEntityPositions;
        public final Map<class_2338, class_2586> blockEntities;
        public final Map<class_2338, class_2487> pendingBlockEntityNbtsPacked;
        private final AtomicBoolean isOpen = new AtomicBoolean(false);

        public Scope(class_2791 chunk, class_3218 world) {
            this.pos = chunk.method_12004();
            this.lighting = Arrays.stream(class_1944.values()).map(type -> new CachedLightingView(world.method_22336(), chunk.method_12004(), (class_1944)type)).collect(Collectors.toMap(CachedLightingView::getLightType, Function.identity()));
            this.blockEntityPositions = chunk.method_12021();
            this.blockEntities = this.blockEntityPositions.stream().map(arg_0 -> ((class_2791)chunk).method_8321(arg_0)).filter(Objects::nonNull).filter(blockEntity -> !blockEntity.method_11015()).collect(Collectors.toMap(class_2586::method_11016, Function.identity()));
            Object2ObjectOpenHashMap pendingBlockEntitiesNbtPacked = new Object2ObjectOpenHashMap();
            for (class_2338 blockPos : this.blockEntityPositions) {
                class_2487 blockEntityNbt = chunk.method_12024(blockPos);
                if (blockEntityNbt == null) continue;
                class_2487 copy = blockEntityNbt.method_10553();
                copy.method_10556("keepPacked", true);
                pendingBlockEntitiesNbtPacked.put(blockPos, copy);
            }
            this.pendingBlockEntityNbtsPacked = pendingBlockEntitiesNbtPacked;
            HashSet<class_2338> blockPos = new HashSet<class_2338>(this.blockEntities.keySet());
            blockPos.addAll(this.pendingBlockEntityNbtsPacked.keySet());
            if (this.blockEntityPositions.size() != blockPos.size()) {
                LOGGER.warn("Block entities size mismatch! expected {} but got {}", (Object)this.blockEntityPositions.size(), (Object)blockPos.size());
            }
        }

        public void open() {
            if (!this.isOpen.compareAndSet(false, true)) {
                throw new IllegalStateException("Cannot use scope twice");
            }
        }

        private static final class CachedLightingView
        implements class_3562 {
            private static final class_2804 EMPTY = new class_2804();
            private final class_1944 lightType;
            private final Map<class_4076, class_2804> cachedData = new Object2ObjectOpenHashMap();

            CachedLightingView(class_3568 provider, class_1923 pos, class_1944 type) {
                this.lightType = type;
                for (int i = provider.method_31929(); i < provider.method_31930(); ++i) {
                    class_4076 sectionPos = class_4076.method_18681((class_1923)pos, (int)i);
                    class_2804 lighting = provider.method_15562(type).method_15544(sectionPos);
                    this.cachedData.put(sectionPos, lighting != null ? lighting.method_12144() : null);
                }
            }

            public class_1944 getLightType() {
                return this.lightType;
            }

            public void method_15513(class_2338 blockPos) {
                throw new UnsupportedOperationException();
            }

            public boolean method_15518() {
                throw new UnsupportedOperationException();
            }

            public int method_15516() {
                throw new UnsupportedOperationException();
            }

            public void method_15551(class_4076 pos, boolean notReady) {
                throw new UnsupportedOperationException();
            }

            public void method_15512(class_1923 chunkPos, boolean bl) {
                throw new UnsupportedOperationException();
            }

            public void method_51471(class_1923 chunkPos) {
                throw new UnsupportedOperationException();
            }

            @NotNull
            public class_2804 method_15544(class_4076 pos) {
                return this.cachedData.getOrDefault(pos, EMPTY);
            }

            public int method_15543(class_2338 pos) {
                throw new UnsupportedOperationException();
            }
        }
    }
}

