/*
 * Decompiled with CFR 0.152.
 */
package dev.tr7zw.exordium.util;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import dev.tr7zw.exordium.ExordiumModBase;
import dev.tr7zw.exordium.util.Model;
import java.lang.ref.Cleaner;
import java.util.List;
import java.util.Objects;
import net.minecraft.class_1767;
import net.minecraft.class_243;
import net.minecraft.class_2625;
import net.minecraft.class_276;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_5253;
import net.minecraft.class_5348;
import net.minecraft.class_5481;
import net.minecraft.class_6367;
import net.minecraft.class_757;
import net.minecraft.class_8242;
import net.minecraft.class_8251;
import org.joml.Matrix3f;
import org.joml.Matrix4f;
import org.joml.Vector3f;

public class SignBufferRenderer {
    private static final Cleaner cleaner = Cleaner.create();
    private static final class_310 minecraft = class_310.method_1551();
    private static Model model = null;
    private class_276 frontTexture;
    private class_276 backtTexture;

    public SignBufferRenderer(class_2625 arg, int light) {
        Objects.requireNonNull(ExordiumModBase.signSettings);
        Objects.requireNonNull(ExordiumModBase.signSettings);
        this.frontTexture = new class_6367(366, 366, false, false);
        this.frontTexture.method_1236(0.0f, 0.0f, 0.0f, 0.0f);
        this.frontTexture.method_1230(false);
        cleaner.register(this, new State(this.frontTexture));
        Objects.requireNonNull(ExordiumModBase.signSettings);
        Objects.requireNonNull(ExordiumModBase.signSettings);
        this.backtTexture = new class_6367(366, 366, false, false);
        this.backtTexture.method_1236(0.0f, 0.0f, 0.0f, 0.0f);
        this.backtTexture.method_1230(false);
        cleaner.register(this, new State(this.backtTexture));
        if (model == null) {
            SignBufferRenderer.initializeModel();
        }
        class_310.method_1551().method_1522().method_1235(true);
    }

    public void refreshImage(class_2625 arg, int light, boolean front) {
        ExordiumModBase.instance.getDelayedRenderCallManager().addRenderCall(() -> {
            if (front) {
                this.frontTexture.method_1235(false);
                this.frontTexture.method_1230(false);
                this.renderSignToBuffer(arg.method_49853(), this.frontTexture, light);
            } else {
                this.backtTexture.method_1235(false);
                this.backtTexture.method_1230(false);
                this.renderSignToBuffer(arg.method_49854(), this.backtTexture, light);
            }
        });
    }

    private static void initializeModel() {
        Objects.requireNonNull(ExordiumModBase.signSettings);
        float height = 183;
        Objects.requireNonNull(ExordiumModBase.signSettings);
        float width = 183;
        Vector3f[] modelData = new Vector3f[]{new Vector3f(0.0f, height, 0.01f), new Vector3f(width, height, 0.01f), new Vector3f(width, 0.0f, 0.01f), new Vector3f(0.0f, 0.0f, 0.01f)};
        Model.Vector2f[] uvData = new Model.Vector2f[]{new Model.Vector2f(0.0f, 0.0f), new Model.Vector2f(1.0f, 0.0f), new Model.Vector2f(1.0f, 1.0f), new Model.Vector2f(0.0f, 1.0f)};
        model = new Model(modelData, uvData);
    }

    class_243 getTextOffset(float f) {
        return new class_243(0.0, (double)(0.5f * f), (double)(0.07f * f));
    }

    public void render(class_4587 poseStack, int light, boolean hangingSign, boolean front) {
        poseStack.method_46416(ExordiumModBase.signSettings.offsetX, ExordiumModBase.signSettings.offsetY + (hangingSign ? ExordiumModBase.signSettings.hangingOffsetY : 0.0f), hangingSign ? ExordiumModBase.signSettings.hangingOffsetZ : 0.0f);
        RenderSystem.depthMask((boolean)true);
        RenderSystem.enableDepthTest();
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((GlStateManager.class_4535)GlStateManager.class_4535.ONE, (GlStateManager.class_4534)GlStateManager.class_4534.ONE_MINUS_SRC_ALPHA);
        RenderSystem.setShader(class_757::method_34542);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (int)(front ? this.frontTexture.method_30277() : this.backtTexture.method_30277()));
        Matrix4f pose = poseStack.method_23760().method_23761();
        model.draw(pose);
    }

    private void renderSignToBuffer(class_8242 text, class_276 texture, int light) {
        int o;
        boolean bl;
        int n;
        class_4597.class_4598 bufferSource = class_4597.method_22991((class_287)class_289.method_1348().method_1349());
        texture.method_1235(false);
        Matrix4f tmp = RenderSystem.getProjectionMatrix();
        Matrix3f tmpI = RenderSystem.getInverseViewRotationMatrix();
        RenderSystem.setInverseViewRotationMatrix((Matrix3f)new Matrix3f());
        RenderSystem.setProjectionMatrix((Matrix4f)new Matrix4f(), (class_8251)RenderSystem.getVertexSorting());
        float scale = 1.0f / ExordiumModBase.signSettings.scaleSize;
        Matrix4f matrix4f = new Matrix4f().m00(scale).m11(-scale).m22(scale).m33(1.0f);
        int l = SignBufferRenderer.getDarkColor(text);
        class_5481[] formattedCharSequences = text.method_49868(class_310.method_1551().method_33883(), arg2 -> {
            List list = SignBufferRenderer.minecraft.field_1772.method_1728((class_5348)arg2, 90);
            return list.isEmpty() ? class_5481.field_26385 : (class_5481)list.get(0);
        });
        if (text.method_49856()) {
            n = text.method_49872().method_16357();
            bl = true;
            o = 0xF000F0;
        } else {
            n = l;
            bl = false;
            o = light;
        }
        for (int p = 0; p < 4; ++p) {
            class_5481 formattedCharSequence = formattedCharSequences[p];
            float q = -SignBufferRenderer.minecraft.field_1772.method_30880(formattedCharSequence) / 2;
            if (bl) {
                SignBufferRenderer.minecraft.field_1772.method_37296(formattedCharSequence, -28.0f + q, (float)(p * 10 - 20), n, l, matrix4f, (class_4597)bufferSource, o);
                continue;
            }
            SignBufferRenderer.minecraft.field_1772.method_22942(formattedCharSequence, -28.0f + q, (float)(p * 10 - 20), n, false, matrix4f, (class_4597)bufferSource, class_327.class_6415.field_33993, 0, o);
        }
        bufferSource.method_22993();
        class_310.method_1551().method_1522().method_1235(true);
        RenderSystem.setProjectionMatrix((Matrix4f)tmp, (class_8251)RenderSystem.getVertexSorting());
        RenderSystem.setInverseViewRotationMatrix((Matrix3f)tmpI);
    }

    private static int getDarkColor(class_8242 text) {
        int i = text.method_49872().method_16357();
        if (i == class_1767.field_7963.method_16357() && text.method_49856()) {
            return -988212;
        }
        int j = (int)((double)class_5253.class_5254.method_27765((int)i) * 0.4);
        int k = (int)((double)class_5253.class_5254.method_27766((int)i) * 0.4);
        int l = (int)((double)class_5253.class_5254.method_27767((int)i) * 0.4);
        return class_5253.class_5254.method_27764((int)0, (int)j, (int)k, (int)l);
    }

    static class State
    implements Runnable {
        private class_276 cleanableRenderTarget;

        State(class_276 guiTarget) {
            this.cleanableRenderTarget = guiTarget;
        }

        @Override
        public void run() {
            RenderSystem.recordRenderCall(() -> this.cleanableRenderTarget.method_1238());
        }
    }
}

