/*
 * Decompiled with CFR 0.152.
 */
package dev.tr7zw.exordium.util;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import dev.tr7zw.exordium.ExordiumModBase;
import dev.tr7zw.exordium.util.Model;
import net.minecraft.class_276;
import net.minecraft.class_310;
import net.minecraft.class_6367;
import net.minecraft.class_757;
import org.joml.Vector3f;

public class BufferRenderer {
    private static final class_310 minecraft = class_310.method_1551();
    private static Model model = null;
    private class_276 guiTarget = new class_6367(100, 100, true, false);
    private long nextFrame = System.currentTimeMillis();
    private int guiScale = 0;
    private boolean isRendering = false;
    private boolean forceBlending = false;

    public BufferRenderer() {
        this(false);
    }

    public BufferRenderer(boolean forceBlending) {
        this.forceBlending = forceBlending;
    }

    private static void refreshModel(int screenWidth, int screenHeight) {
        if (model != null) {
            model.close();
        }
        Vector3f[] modelData = new Vector3f[]{new Vector3f(0.0f, (float)screenHeight, -90.0f), new Vector3f((float)screenWidth, (float)screenHeight, -90.0f), new Vector3f((float)screenWidth, 0.0f, -90.0f), new Vector3f(0.0f, 0.0f, -90.0f)};
        Model.Vector2f[] uvData = new Model.Vector2f[]{new Model.Vector2f(0.0f, 0.0f), new Model.Vector2f(1.0f, 0.0f), new Model.Vector2f(1.0f, 1.0f), new Model.Vector2f(0.0f, 1.0f)};
        model = new Model(modelData, uvData);
    }

    public boolean render() {
        int screenWidth = minecraft.method_22683().method_4486();
        int screenHeight = minecraft.method_22683().method_4502();
        boolean forceRender = false;
        if (this.guiTarget.field_1482 != minecraft.method_22683().method_4489() || this.guiTarget.field_1481 != minecraft.method_22683().method_4506() || (Integer)BufferRenderer.minecraft.field_1690.method_42474().method_41753() != this.guiScale) {
            this.guiTarget.method_1234(minecraft.method_22683().method_4489(), minecraft.method_22683().method_4506(), true);
            BufferRenderer.refreshModel(screenWidth, screenHeight);
            this.guiScale = (Integer)BufferRenderer.minecraft.field_1690.method_42474().method_41753();
            forceRender = true;
        }
        if (model == null) {
            BufferRenderer.refreshModel(screenWidth, screenHeight);
        }
        if (!forceRender && System.currentTimeMillis() < this.nextFrame) {
            this.renderTextureOverlay(this.guiTarget.method_30277(), screenWidth, screenHeight);
            return true;
        }
        this.guiTarget.method_1236(0.0f, 0.0f, 0.0f, 0.0f);
        this.guiTarget.method_1230(false);
        this.guiTarget.method_1235(false);
        ExordiumModBase.correctBlendMode();
        this.isRendering = true;
        ExordiumModBase.instance.setTemporaryScreenOverwrite(this.guiTarget);
        if (this.forceBlending) {
            ExordiumModBase.setForceBlend(true);
        }
        return false;
    }

    public void renderEnd(int cacheTime) {
        this.guiTarget.method_1240();
        ExordiumModBase.instance.setTemporaryScreenOverwrite(null);
        class_310.method_1551().method_1522().method_1235(true);
        this.nextFrame = System.currentTimeMillis() + (long)cacheTime;
        this.isRendering = false;
        if (this.forceBlending) {
            ExordiumModBase.setForceBlend(false);
        }
        int screenWidth = minecraft.method_22683().method_4486();
        int screenHeight = minecraft.method_22683().method_4502();
        this.renderTextureOverlay(this.guiTarget.method_30277(), screenWidth, screenHeight);
    }

    private void renderTextureOverlay(int textureid, int screenWidth, int screenHeight) {
        RenderSystem.disableDepthTest();
        RenderSystem.depthMask((boolean)false);
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((GlStateManager.class_4535)GlStateManager.class_4535.ONE, (GlStateManager.class_4534)GlStateManager.class_4534.ONE_MINUS_SRC_ALPHA);
        RenderSystem.setShader(class_757::method_34542);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (int)textureid);
        model.draw(RenderSystem.getModelViewMatrix());
        RenderSystem.depthMask((boolean)true);
        RenderSystem.enableDepthTest();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    public boolean isRendering() {
        return this.isRendering;
    }
}

