/*
 * Decompiled with CFR 0.152.
 */
package dev.tr7zw.exordium;

import dev.tr7zw.exordium.ExordiumModBase;
import dev.tr7zw.exordium.access.ChatAccess;
import dev.tr7zw.exordium.access.GuiAccess;
import dev.tr7zw.exordium.access.TablistAccess;
import dev.tr7zw.exordium.access.VanillaBufferAccess;
import dev.tr7zw.exordium.util.BufferedComponent;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.class_269;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_329;
import net.minecraft.class_332;
import net.minecraft.class_8646;

public class BufferManager {
    private Map<class_2960, Function<class_329, BufferedComponent>> vanillaBuffers = new HashMap<class_2960, Function<class_329, BufferedComponent>>();
    private Map<class_2960, Consumer<HandlerData>> customHandlers = new HashMap<class_2960, Consumer<HandlerData>>();
    private Map<class_2960, Runnable> customEndHandlers = new HashMap<class_2960, Runnable>();

    public void initialize() {
        class_310 minecraft = class_310.method_1551();
        this.vanillaBuffers.put(new class_2960("debug_text"), gui -> ((VanillaBufferAccess.DebugOverlayAccess)gui).getDebugOverlayBuffer());
        this.vanillaBuffers.put(new class_2960("crosshair"), gui -> ((VanillaBufferAccess.CrosshairOverlayAccess)gui).getCrosshairOverlayBuffer());
        this.vanillaBuffers.put(new class_2960("experience_bar"), gui -> ((VanillaBufferAccess.ExperienceBarOverlayAccess)gui).getExperienceBarOverlayBuffer());
        this.vanillaBuffers.put(new class_2960("scoreboard"), gui -> ((VanillaBufferAccess.ScoreBoardOverlayAccess)gui).getScoreBoardOverlayBuffer());
        this.vanillaBuffers.put(new class_2960("hotbar"), gui -> ((VanillaBufferAccess.HotbarOverlayAccess)gui).getHotbarOverlayBuffer());
        this.registerCustomHandler(new class_2960("vignette"), data -> {
            VanillaBufferAccess.VignetteOverlayAccess vignette = (VanillaBufferAccess.VignetteOverlayAccess)minecraft.field_1705;
            if (ExordiumModBase.instance.config.vignetteSettings.enabled) {
                if (!vignette.getVignetteOverlayBuffer().render()) {
                    vignette.renderCustomVignette(data.gui());
                }
                data.cancel().set(true);
            }
            vignette.getVignetteOverlayBuffer().renderEnd();
        });
        this.registerCustomHandler(new class_2960("chat_panel"), data -> {
            GuiAccess guiAccess = (GuiAccess)minecraft.field_1705;
            ChatAccess chatAccess = (ChatAccess)guiAccess.getChatComponent();
            chatAccess.updateState(guiAccess.getTickCount());
            BufferedComponent bufferedComponent = chatAccess.getChatOverlayBuffer();
            if (bufferedComponent.render()) {
                data.cancel().set(true);
            }
        });
        this.registerCustomEndHandler(new class_2960("chat_panel"), () -> {
            GuiAccess guiAccess = (GuiAccess)minecraft.field_1705;
            ChatAccess chatAccess = (ChatAccess)guiAccess.getChatComponent();
            BufferedComponent bufferedComponent = chatAccess.getChatOverlayBuffer();
            bufferedComponent.renderEnd();
        });
        this.registerCustomHandler(new class_2960("player_list"), data -> {
            GuiAccess guiAccess = (GuiAccess)minecraft.field_1705;
            TablistAccess tablistAccess = (TablistAccess)guiAccess.getPlayerTabOverlay();
            class_269 scoreboard = minecraft.field_1687.method_8428();
            tablistAccess.updateState(scoreboard, scoreboard.method_1189(class_8646.field_45156));
            BufferedComponent bufferedComponent = tablistAccess.getPlayerListOverlayBuffer();
            if (bufferedComponent.render()) {
                data.cancel().set(true);
            }
        });
        this.registerCustomEndHandler(new class_2960("player_list"), () -> {
            GuiAccess guiAccess = (GuiAccess)minecraft.field_1705;
            TablistAccess tabAccess = (TablistAccess)guiAccess.getPlayerTabOverlay();
            BufferedComponent bufferedComponent = tabAccess.getPlayerListOverlayBuffer();
            bufferedComponent.renderEnd();
        });
    }

    public BufferedComponent getBufferedComponent(class_2960 resourceLocation, class_329 gui) {
        Function<class_329, BufferedComponent> vanFun = this.vanillaBuffers.get(resourceLocation);
        if (vanFun != null) {
            return vanFun.apply(gui);
        }
        return null;
    }

    public Consumer<HandlerData> getCustomHandler(class_2960 resourceLocation) {
        return this.customHandlers.get(resourceLocation);
    }

    public Runnable getCustomEndHandler(class_2960 resourceLocation) {
        return this.customEndHandlers.get(resourceLocation);
    }

    public void registerCustomHandler(class_2960 resourceLocation, Consumer<HandlerData> handler) {
        this.customHandlers.put(resourceLocation, handler);
    }

    public void registerCustomEndHandler(class_2960 resourceLocation, Runnable handler) {
        this.customEndHandlers.put(resourceLocation, handler);
    }

    public record HandlerData(class_332 gui, AtomicBoolean cancel) {
    }
}

