/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.plugin.extra.provider;

import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import mcp.mobius.waila.api.IDataReader;
import mcp.mobius.waila.api.IPluginConfig;
import mcp.mobius.waila.api.IRegistrar;
import mcp.mobius.waila.api.ITooltip;
import mcp.mobius.waila.api.component.ItemListComponent;
import mcp.mobius.waila.api.data.ItemData;
import mcp.mobius.waila.api.data.ProgressData;
import mcp.mobius.waila.plugin.extra.provider.DataProvider;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2960;
import org.jetbrains.annotations.Nullable;

public class ItemProvider
extends DataProvider<ItemData> {
    public static final ItemProvider INSTANCE = new ItemProvider();
    private static final class_2487 EMPTY = new class_2487();
    @Nullable
    private ItemData lastData = null;
    @Nullable
    private ItemListComponent lastItemsComponent = null;

    protected ItemProvider() {
        super(ItemData.ID, ItemData.class, ItemData::new);
    }

    @Override
    protected void registerAdditions(IRegistrar registrar, int priority) {
        registrar.addSyncedConfig(ItemData.CONFIG_SYNC_NBT, true, false);
        registrar.addConfig(ItemData.CONFIG_MAX_HEIGHT, 3);
    }

    @Override
    protected void appendBody(ITooltip tooltip, IDataReader reader, IPluginConfig config, class_2960 objectId) {
        ProgressData progress = reader.get(ProgressData.class);
        if (progress == null || progress.ratio() == 0.0f) {
            super.appendBody(tooltip, reader, config, objectId);
        }
    }

    @Override
    protected void appendBody(ITooltip tooltip, ItemData data, IPluginConfig config, class_2960 objectId) {
        if (data == this.lastData) {
            if (this.lastItemsComponent != null) {
                tooltip.setLine(ItemData.ID, this.lastItemsComponent);
            }
            return;
        }
        this.lastData = data;
        this.lastItemsComponent = null;
        HashMap<Object, class_1799> merged = new HashMap<Object, class_1799>();
        HashMap<class_1792, Set> unique = new HashMap<class_1792, Set>();
        for (class_1799 stack : data.items()) {
            if (stack.method_7960()) continue;
            class_1792 item = stack.method_7909();
            int count = stack.method_7947();
            if (!data.syncNbt()) {
                if (unique.put(item, Set.of()) != null) {
                    ((class_1799)merged.get(item)).method_7933(count);
                    continue;
                }
                merged.put(item, stack.method_7972());
                continue;
            }
            class_2487 nbt = stack.method_7969();
            if (nbt == null) {
                nbt = EMPTY;
            }
            if (unique.computeIfAbsent(item, i -> new HashSet()).add(nbt)) {
                merged.put(new ItemWithNbt(item, nbt), stack.method_7972());
                continue;
            }
            ((class_1799)merged.get(new ItemWithNbt(item, nbt))).method_7933(count);
        }
        if (merged.isEmpty()) {
            return;
        }
        this.lastItemsComponent = new ItemListComponent(merged.values().stream().sorted(Comparator.comparingInt(class_1799::method_7947).reversed()).toList(), config.getInt(ItemData.CONFIG_MAX_HEIGHT));
        tooltip.setLine(ItemData.ID, this.lastItemsComponent);
    }

    private record ItemWithNbt(class_1792 item, class_2487 tag) {
    }
}

