/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.gui.widget;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import mcp.mobius.waila.gui.screen.ConfigScreen;
import mcp.mobius.waila.gui.widget.CategoryEntry;
import mcp.mobius.waila.gui.widget.value.ConfigValue;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_342;
import net.minecraft.class_364;
import net.minecraft.class_368;
import net.minecraft.class_370;
import net.minecraft.class_4265;
import net.minecraft.class_6379;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ConfigListWidget
extends class_4265<Entry> {
    private final ConfigScreen owner;
    private final Runnable diskWriter;
    private int topOffset;
    private int bottomOffset;
    @Nullable
    private class_342 searchBox;
    private List<Entry> unfilteredChildren;

    public ConfigListWidget(ConfigScreen owner, class_310 client, int width, int height, int top, int bottom, int itemHeight, Runnable diskWriter) {
        super(client, width, height, top, bottom, itemHeight - 4);
        this.owner = owner;
        this.diskWriter = diskWriter;
        this.resize(top, bottom);
        this.method_31322(false);
    }

    public ConfigListWidget(ConfigScreen owner, class_310 client, int width, int height, int top, int bottom, int itemHeight) {
        this(owner, client, width, height, top, bottom, itemHeight, null);
    }

    public int method_25322() {
        return Math.min(this.field_22742 - 20, 450);
    }

    protected int method_25329() {
        return this.field_22740.method_22683().method_4486() - 5;
    }

    public void tick() {
        this.method_25396().forEach(Entry::tick);
    }

    public boolean save(boolean ignoreErrors) {
        List<ConfigValue> values = this.method_25396().stream().filter(e -> e instanceof ConfigValue).map(e -> (ConfigValue)((Object)e)).toList();
        if (values.stream().allMatch(ConfigValue::isValueValid)) {
            values.forEach(ConfigValue::save);
            if (this.diskWriter != null) {
                this.diskWriter.run();
            }
            return true;
        }
        if (!ignoreErrors) {
            this.field_22740.method_1566().method_1999((class_368)new class_370(class_370.class_371.field_2218, (class_2561)class_2561.method_43471((String)"config.waila.invalid_input.title"), (class_2561)class_2561.method_43471((String)"config.waila.invalid_input.desc")));
        }
        return ignoreErrors;
    }

    public class_342 getSearchBox() {
        if (this.searchBox != null) {
            return this.searchBox;
        }
        this.unfilteredChildren = new ArrayList<Entry>(this.method_25396());
        String category = "";
        for (Entry child : this.unfilteredChildren) {
            if (child instanceof CategoryEntry) {
                category = child.category;
            }
            child.category = category;
        }
        this.searchBox = new class_342(this.field_22740.field_1772, 0, 0, 160, 18, (class_2561)class_2561.method_43473());
        this.searchBox.method_47404((class_2561)class_2561.method_43471((String)"config.waila.search_prompt"));
        this.searchBox.method_1863(filter -> {
            this.method_25396().clear();
            if (filter.isBlank()) {
                this.method_25396().addAll(this.unfilteredChildren);
            } else {
                this.method_25396().addAll(this.unfilteredChildren.stream().filter(it -> it.match((String)filter)).toList());
            }
            this.init();
        });
        return this.searchBox;
    }

    public void init() {
        for (Entry child : this.method_25396()) {
            child.method_25395(null);
        }
        this.resize(this.topOffset, this.owner.field_22790 + this.bottomOffset);
        this.method_25307(this.method_25341());
    }

    public void add(Entry entry) {
        this.add(this.method_25396().size(), entry);
    }

    public void add(int index, Entry entry) {
        this.method_25396().add(index, entry);
    }

    public ConfigListWidget with(Entry entry) {
        return this.with(this.method_25396().size(), entry);
    }

    public ConfigListWidget with(int index, Entry entry) {
        this.add(index, entry);
        return this;
    }

    public void resize(int top, int bottom) {
        this.topOffset = top;
        this.bottomOffset = bottom - this.owner.field_22790;
        this.method_25323(this.owner.field_22789, this.owner.field_22790, this.topOffset, this.owner.field_22790 + this.bottomOffset);
        if (this.searchBox != null) {
            this.searchBox.method_48229(this.method_25342() + this.method_25322() - 160, (top - 18) / 2);
        }
    }

    public static abstract class Entry
    extends class_4265.class_4266<Entry> {
        protected final class_310 client = class_310.method_1551();
        @Nullable
        protected List<? extends class_364> children;
        @Nullable
        protected List<? extends class_6379> narratables;
        public String category = "";

        public void tick() {
        }

        protected void gatherChildren(ImmutableList.Builder<class_364> children) {
        }

        protected void gatherNarratables(ImmutableList.Builder<class_6379> narratables) {
        }

        protected boolean match(String filter) {
            return StringUtils.containsIgnoreCase((CharSequence)this.category, (CharSequence)filter);
        }

        @NotNull
        public List<? extends class_364> method_25396() {
            if (this.children == null) {
                ImmutableList.Builder builder = ImmutableList.builder();
                this.gatherChildren((ImmutableList.Builder<class_364>)builder);
                this.children = builder.build();
            }
            return this.children;
        }

        @NotNull
        public List<? extends class_6379> method_37025() {
            if (this.narratables == null) {
                ImmutableList.Builder builder = ImmutableList.builder();
                this.gatherNarratables((ImmutableList.Builder<class_6379>)builder);
                this.narratables = builder.build();
            }
            return this.narratables;
        }

        public void method_25343(@NotNull class_332 ctx, int index, int rowTop, int rowLeft, int width, int height, int mouseX, int mouseY, boolean hovered, float deltaTime) {
            if (rowTop <= mouseY && mouseY < rowTop + height + 4) {
                ctx.method_25294(0, rowTop - 2, this.client.method_22683().method_4486(), rowTop + height + 2, 0x22FFFFFF);
            }
        }
    }
}

