/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.api.data;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.List;
import mcp.mobius.waila.api.IData;
import mcp.mobius.waila.api.__internal__.ApiSide;
import mcp.mobius.waila.api.__internal__.IExtraService;
import mcp.mobius.waila.api.data.BuiltinDataUtil;
import net.minecraft.class_1058;
import net.minecraft.class_2248;
import net.minecraft.class_2359;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3532;
import net.minecraft.class_3609;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_7923;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

public final class FluidData
implements IData {
    public static final class_2960 ID = BuiltinDataUtil.rl("fluid");
    public static final class_2960 CONFIG_DISPLAY_UNIT = BuiltinDataUtil.rl("fluid.display_unit");
    private final List<Entry<?>> entries;
    private final Unit unit;

    @ApiSide.ClientOnly
    public static <T extends class_3611> void describeFluid(T fluid, FluidDescriptor<T> descriptor) {
        if (fluid instanceof class_3609) {
            class_3609 flowing = (class_3609)fluid;
            Preconditions.checkArgument((flowing == flowing.method_15751() ? 1 : 0) != 0, (Object)"Not a source fluid");
        }
        IExtraService.INSTANCE.setFluidDescFor(fluid, descriptor);
    }

    @ApiSide.ClientOnly
    public static <T extends class_3611> void describeFluid(Class<T> clazz, FluidDescriptor<T> descriptor) {
        IExtraService.INSTANCE.setFluidDescFor(clazz, descriptor);
    }

    public static void describeCauldron(class_2248 block, CauldronDescriptor descriptor) {
        IExtraService.INSTANCE.setCauldronDescFor(block, descriptor);
    }

    public static void describeCauldron(Class<? extends class_2248> clazz, CauldronDescriptor descriptor) {
        IExtraService.INSTANCE.setCauldronDescFor(clazz, descriptor);
    }

    public static FluidData of(Unit unit) {
        return new FluidData(new ArrayList(), unit);
    }

    public static FluidData of(Unit unit, int slotCountHint) {
        return new FluidData(new ArrayList(slotCountHint), unit);
    }

    public FluidData add(class_3611 fluid, @Nullable class_2487 nbt, double stored, double capacity) {
        class_3611 class_36112;
        capacity = Math.max(capacity, 0.0);
        stored = class_3532.method_15350((double)stored, (double)0.0, (double)capacity);
        if (capacity == 0.0) {
            capacity = Double.POSITIVE_INFINITY;
        }
        if (fluid instanceof class_3609) {
            class_3609 flowing = (class_3609)fluid;
            class_36112 = flowing.method_15751();
        } else {
            class_36112 = fluid;
        }
        class_3611 source = class_36112;
        this.entries.add(new Entry<class_3611>(source, nbt, stored, capacity));
        return this;
    }

    @ApiStatus.Internal
    private FluidData(List<Entry<?>> entries, Unit unit) {
        this.entries = entries;
        this.unit = unit;
    }

    @ApiStatus.Internal
    public FluidData(class_2540 buf) {
        this.unit = (Unit)buf.method_10818(Unit.class);
        int size = buf.method_10816();
        this.entries = new ArrayList(size);
        for (int i = 0; i < size; ++i) {
            if (buf.readBoolean()) continue;
            int id = buf.method_10816();
            class_3611 fluid = (class_3611)class_7923.field_41173.method_10200(id);
            class_2487 nbt = buf.method_10798();
            double stored = buf.readDouble();
            double capacity = buf.readDouble();
            this.add(fluid, nbt, stored, capacity);
        }
    }

    @Override
    @ApiStatus.Internal
    public void write(class_2540 buf) {
        buf.method_10817((Enum)this.unit);
        buf.method_10804(this.entries.size());
        for (Entry<?> entry : this.entries) {
            if (entry.isEmpty()) {
                buf.method_52964(true);
                continue;
            }
            buf.method_52964(false);
            buf.method_42065((class_2359)class_7923.field_41173, entry.fluid);
            buf.method_10794((class_2520)entry.nbt);
            buf.method_52940(entry.stored);
            buf.method_52940(entry.capacity);
        }
    }

    @ApiStatus.Internal
    public Unit unit() {
        return this.unit;
    }

    @ApiStatus.Internal
    public List<Entry<?>> entries() {
        return this.entries;
    }

    @Deprecated(forRemoval=true)
    @ApiStatus.ScheduledForRemoval(inVersion="1.21")
    public static FluidData of() {
        return FluidData.of(Unit.MILLIBUCKETS);
    }

    @Deprecated(forRemoval=true)
    @ApiStatus.ScheduledForRemoval(inVersion="1.21")
    public static FluidData of(int slotCountHint) {
        return FluidData.of(Unit.MILLIBUCKETS, slotCountHint);
    }

    @ApiSide.ClientOnly
    @ApiStatus.OverrideOnly
    public static interface FluidDescriptor<T extends class_3611> {
        public void describeFluid(FluidDescriptionContext<T> var1, FluidDescription var2);
    }

    @ApiStatus.OverrideOnly
    public static interface CauldronDescriptor {
        @Nullable
        public FluidData getCauldronFluidData(class_2680 var1);
    }

    public static enum Unit {
        MILLIBUCKETS("mB"),
        DROPLETS("d");

        public final String symbol;

        public static double convert(Unit from, Unit to, double amount) {
            if (from == to) {
                return amount;
            }
            return switch (to) {
                default -> throw new IncompatibleClassChangeError();
                case MILLIBUCKETS -> amount / 81.0;
                case DROPLETS -> amount * 81.0;
            };
        }

        private Unit(String symbol) {
            this.symbol = symbol;
        }
    }

    @ApiStatus.Internal
    public static class Entry<T extends class_3611>
    implements FluidDescriptionContext<T> {
        private final T fluid;
        @Nullable
        private final class_2487 nbt;
        private final double stored;
        private final double capacity;

        private Entry(T fluid, @Nullable class_2487 nbt, double stored, double capacity) {
            this.fluid = fluid;
            this.nbt = nbt;
            this.stored = stored;
            this.capacity = capacity;
        }

        public boolean isEmpty() {
            return this.fluid == class_3612.field_15906 || this.stored <= 0.0;
        }

        @Override
        public T fluid() {
            return this.fluid;
        }

        @Override
        @Nullable
        public class_2487 nbt() {
            return this.nbt;
        }

        public double stored() {
            return this.stored;
        }

        public double capacity() {
            return this.capacity;
        }
    }

    @ApiSide.ClientOnly
    @ApiStatus.NonExtendable
    public static interface FluidDescriptionContext<T extends class_3611> {
        public T fluid();

        @Nullable
        public class_2487 nbt();
    }

    @ApiSide.ClientOnly
    @ApiStatus.NonExtendable
    public static interface FluidDescription {
        public FluidDescription name(class_2561 var1);

        public FluidDescription sprite(class_1058 var1);

        public FluidDescription tint(int var1);
    }
}

