/*
 * Decompiled with CFR 0.152.
 */
package me.cortex.nvidium.managers;

import it.unimi.dsi.fastutil.longs.Long2IntOpenHashMap;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.BitSet;
import me.cortex.nvidium.gl.RenderDevice;
import me.cortex.nvidium.gl.buffers.IDeviceMappedBuffer;
import me.cortex.nvidium.sodiumCompat.IViewportTest;
import me.cortex.nvidium.util.IdProvider;
import me.cortex.nvidium.util.UploadingBufferStream;
import me.jellysquid.mods.sodium.client.render.viewport.Viewport;
import net.minecraft.class_4076;
import org.lwjgl.system.MemoryUtil;

public class RegionManager {
    private static final boolean SAFETY_CHECKS = true;
    public static final int META_SIZE = 16;
    private static final int TOTAL_SECTION_META_SIZE = 8192;
    private final IDeviceMappedBuffer regionBuffer;
    private final IDeviceMappedBuffer sectionBuffer;
    private final RenderDevice device;
    private final UploadingBufferStream uploadStream;
    private final Long2IntOpenHashMap regionMap = new Long2IntOpenHashMap();
    private final IdProvider idProvider = new IdProvider();
    private final Region[] regions;
    private final ArrayDeque<Region> dirtyRegions = new ArrayDeque();

    public RegionManager(RenderDevice device, int maxRegions, int maxSections, UploadingBufferStream uploadStream) {
        this.regionMap.defaultReturnValue(-1);
        this.device = device;
        this.regionBuffer = device.createDeviceOnlyMappedBuffer((long)maxRegions * 16L);
        this.sectionBuffer = device.createDeviceOnlyMappedBuffer((long)maxSections * 32L);
        this.uploadStream = uploadStream;
        this.regions = new Region[maxRegions];
    }

    public void delete() {
        this.regionBuffer.delete();
        this.sectionBuffer.delete();
    }

    public void commitChanges() {
        if (this.dirtyRegions.isEmpty()) {
            return;
        }
        while (!this.dirtyRegions.isEmpty()) {
            long regionUpload;
            Region region = this.dirtyRegions.pop();
            region.isDirty = false;
            if (region.isRemoved) {
                if (this.regions[region.id] != null) continue;
                regionUpload = this.uploadStream.getUpload(this.regionBuffer, (long)region.id * 16L, 16);
                MemoryUtil.memSet((long)regionUpload, (int)-1, (long)16L);
                continue;
            }
            regionUpload = this.uploadStream.getUpload(this.regionBuffer, (long)region.id * 16L, 16);
            this.setRegionMetadata(regionUpload, region);
            long sectionUpload = this.uploadStream.getUpload(this.sectionBuffer, (long)region.id * 8192L, 8192);
            MemoryUtil.memCopy((long)region.sectionData, (long)sectionUpload, (long)8192L);
        }
    }

    private void setRegionMetadata(long upload, Region region) {
        int minX = Integer.MAX_VALUE;
        int maxX = Integer.MIN_VALUE;
        int minY = Integer.MAX_VALUE;
        int maxY = Integer.MIN_VALUE;
        int minZ = Integer.MAX_VALUE;
        int maxZ = Integer.MIN_VALUE;
        int lastIdx = 0;
        for (int i = 0; i < 256; ++i) {
            if (region.freeIndices.get(i)) continue;
            int x = region.id2pos[i] & 7;
            int y = region.id2pos[i] >>> 6;
            int z = region.id2pos[i] >>> 3 & 7;
            minX = Math.min(minX, x);
            minY = Math.min(minY, y);
            minZ = Math.min(minZ, z);
            maxX = Math.max(maxX, x);
            maxY = Math.max(maxY, y);
            maxZ = Math.max(maxZ, z);
            lastIdx = i;
        }
        long size = (long)(maxY - minY) << 62 | (long)(maxX - minX) << 59 | (long)(maxZ - minZ) << 56;
        long count = (long)lastIdx << 48;
        long x = (((long)region.rx << 3) + (long)minX & 0xFFFFFFL) << 24;
        long y = (((long)region.ry << 2) + (long)minY & 0xFFFFFFL) << 0;
        long z = (((long)region.rz << 3) + (long)minZ & 0xFFFFFFL) << 40;
        MemoryUtil.memPutLong((long)upload, (long)(size | count | x | y));
        MemoryUtil.memPutLong((long)(upload + 8L), (long)z);
    }

    public long setSectionData(int sectionId) {
        Region region = this.regions[sectionId >>> 8];
        sectionId &= 0xFF;
        if (region == null) {
            throw new IllegalStateException("Region is null");
        }
        if (!this.regionMap.containsKey(region.key) || this.regionMap.get(region.key) != region.id) {
            throw new IllegalStateException("Region verification failed");
        }
        if (region.id2pos[sectionId] == -1 || region.freeIndices.get(sectionId)) {
            throw new IllegalStateException("Section hasnt been allocated");
        }
        this.markDirty(region);
        return region.sectionData + (long)(sectionId * 32);
    }

    public void removeSection(int sectionId) {
        Region region = this.regions[sectionId >>> 8];
        sectionId &= 0xFF;
        if (region == null) {
            throw new IllegalStateException("Region is null");
        }
        if (!this.regionMap.containsKey(region.key) || this.regionMap.get(region.key) != region.id) {
            throw new IllegalStateException("Region verification failed");
        }
        if (region.freeIndices.get(sectionId) || region.id2pos[sectionId] == -1) {
            throw new IllegalStateException("Section already freed");
        }
        --region.count;
        region.freeIndices.set(sectionId);
        region.id2pos[sectionId] = -1;
        if (region.count == 0) {
            region.isRemoved = true;
            this.regions[region.id] = null;
            this.idProvider.release(region.id);
            this.regionMap.remove(region.key);
        }
        MemoryUtil.memSet((long)(region.sectionData + (long)(sectionId * 32)), (int)0, (long)32L);
        this.markDirty(region);
    }

    public int allocateSection(int sectionX, int sectionY, int sectionZ) {
        long regionKey = class_4076.method_18685((int)(sectionX >> 3), (int)(sectionY >> 2), (int)(sectionZ >> 3));
        int regionId = this.regionMap.computeIfAbsent(regionKey, k -> this.idProvider.provide());
        if (this.regions[regionId] == null) {
            this.regions[regionId] = new Region(regionId, sectionX >> 3, sectionY >> 2, sectionZ >> 3);
        }
        Region region = this.regions[regionId];
        if (!this.regionMap.containsKey(region.key) || this.regionMap.get(region.key) != region.id) {
            throw new IllegalStateException("Region verification failed");
        }
        int sectionKey = (sectionY & 3) << 6 | sectionX & 7 | (sectionZ & 7) << 3;
        int sectionId = region.freeIndices.nextSetBit(0);
        if (sectionId == -1) {
            throw new IllegalStateException("No free indices, this should not be possible");
        }
        region.freeIndices.clear(sectionId);
        region.id2pos[sectionId] = sectionKey;
        ++region.count;
        this.markDirty(region);
        return sectionId | regionId << 8;
    }

    private void markDirty(Region region) {
        if (region.isDirty) {
            return;
        }
        region.isDirty = true;
        this.dirtyRegions.add(region);
    }

    public int regionCount() {
        return this.regionMap.size();
    }

    public int maxRegions() {
        return this.regions.length;
    }

    public int maxRegionIndex() {
        return this.idProvider.maxIndex();
    }

    public boolean regionExists(int regionId) {
        return this.regions[regionId] != null;
    }

    public boolean isRegionVisible(Viewport frustum, int regionId) {
        Region region = this.regions[regionId];
        if (region == null) {
            return false;
        }
        return ((IViewportTest)frustum).isBoxVisible(region.rx << 7, region.ry << 6, region.rz << 7, 128.0f, 64.0f, 128.0f);
    }

    public int distance(int regionId, int camChunkX, int camChunkY, int camChunkZ) {
        Region region = this.regions[regionId];
        return Math.abs((region.rx << 3) + 4 - camChunkX) + Math.abs((region.ry << 2) + 2 - camChunkY) + Math.abs((region.rz << 3) + 4 - camChunkZ);
    }

    public boolean withinSquare(int dist, int regionId, int camChunkX, int camChunkY, int camChunkZ) {
        Region region = this.regions[regionId];
        return Math.abs((region.rx << 3) + 4 - camChunkX) <= dist && Math.abs((region.ry << 2) + 2 - camChunkY) <= dist && Math.abs((region.rz << 3) + 4 - camChunkZ) <= dist;
    }

    public long getRegionBufferAddress() {
        return this.regionBuffer.getDeviceAddress();
    }

    public long getSectionBufferAddress() {
        return this.sectionBuffer.getDeviceAddress();
    }

    public long regionIdToKey(int regionId) {
        if (this.regions[regionId] == null) {
            throw new IllegalStateException();
        }
        return this.regions[regionId].key;
    }

    public void destroy() {
        this.sectionBuffer.delete();
        this.regionBuffer.delete();
    }

    private static class Region {
        private final int rx;
        private final int ry;
        private final int rz;
        private final long key;
        private final int id;
        private final BitSet freeIndices = new BitSet(256);
        private int count;
        private final int[] id2pos = new int[256];
        private boolean isDirty;
        private boolean isRemoved;
        private final long sectionData = MemoryUtil.nmemAlloc((long)8192L);

        private Region(int id, int rx, int ry, int rz) {
            Arrays.fill(this.id2pos, -1);
            MemoryUtil.memSet((long)this.sectionData, (int)0, (long)8192L);
            this.key = class_4076.method_18685((int)rx, (int)ry, (int)rz);
            this.id = id;
            this.freeIndices.set(0, 256);
            this.rx = rx;
            this.ry = ry;
            this.rz = rz;
        }

        public void delete() {
            MemoryUtil.nmemFree((long)this.sectionData);
        }
    }
}

