/*
 * Decompiled with CFR 0.152.
 */
package me.cortex.nvidium.managers;

import com.mojang.blaze3d.systems.RenderSystem;
import it.unimi.dsi.fastutil.longs.Long2ReferenceMap;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import me.cortex.nvidium.sodiumCompat.IRenderSectionExtension;
import me.jellysquid.mods.sodium.client.SodiumClientMod;
import me.jellysquid.mods.sodium.client.render.chunk.ChunkUpdateType;
import me.jellysquid.mods.sodium.client.render.chunk.RenderSection;
import me.jellysquid.mods.sodium.client.render.chunk.occlusion.OcclusionCuller;
import me.jellysquid.mods.sodium.client.render.viewport.Viewport;
import net.minecraft.class_1058;
import net.minecraft.class_1937;
import net.minecraft.class_2382;
import net.minecraft.class_3532;
import org.jetbrains.annotations.Nullable;

public class AsyncOcclusionTracker {
    private final OcclusionCuller occlusionCuller;
    private final Thread cullThread;
    private volatile boolean running = true;
    private volatile int frame = 0;
    private volatile Viewport viewport = null;
    private final Semaphore framesAhead = new Semaphore(0);
    private final AtomicReference<List<RenderSection>> atomicBfsResult = new AtomicReference();
    private final AtomicReference<List<RenderSection>> blockEntitySectionsRef = new AtomicReference(new ArrayList());
    private final AtomicReference<class_1058[]> visibleAnimatedSpritesRef = new AtomicReference();
    private final Map<ChunkUpdateType, ArrayDeque<RenderSection>> outputRebuildQueue;
    private final float renderDistance;

    public AsyncOcclusionTracker(int renderDistance, Long2ReferenceMap<RenderSection> sections, class_1937 world, Map<ChunkUpdateType, ArrayDeque<RenderSection>> outputRebuildQueue) {
        this.occlusionCuller = new OcclusionCuller(sections, world);
        this.cullThread = new Thread(this::run);
        this.cullThread.setName("Cull thread");
        this.cullThread.setPriority(10);
        this.cullThread.start();
        this.renderDistance = (float)renderDistance * 16.0f;
        this.outputRebuildQueue = outputRebuildQueue;
    }

    private void run() {
        while (this.running) {
            List previous;
            this.framesAhead.acquireUninterruptibly();
            if (!this.running) break;
            boolean animateVisibleSpritesOnly = SodiumClientMod.options().performance.animateOnlyVisibleTextures;
            ArrayList chunkUpdates = new ArrayList();
            ArrayList blockEntitySections = new ArrayList();
            HashSet animatedSpriteSet = animateVisibleSpritesOnly ? new HashSet() : null;
            Consumer<RenderSection> visitor = section -> {
                class_1058[] animatedSprites;
                if ((section.getFlags() & 2) != 0 && section.getPosition().method_19771((class_2382)this.viewport.getChunkCoord(), 33.0)) {
                    blockEntitySections.add(section);
                }
                if (animateVisibleSpritesOnly && (section.getFlags() & 4) != 0 && section.getPosition().method_19771((class_2382)this.viewport.getChunkCoord(), 33.0) && (animatedSprites = section.getAnimatedSprites()) != null) {
                    animatedSpriteSet.addAll(List.of(animatedSprites));
                }
                if (section.getPendingUpdate() != null && section.getBuildCancellationToken() == null && !((IRenderSectionExtension)section).isSubmittedRebuild() && !((IRenderSectionExtension)section).isSeen()) {
                    ((IRenderSectionExtension)section).isSeen(true);
                    chunkUpdates.add(section);
                }
            };
            ++this.frame;
            float searchDistance = this.getSearchDistance();
            boolean useOcclusionCulling = true;
            try {
                this.occlusionCuller.findVisible(visitor, this.viewport, searchDistance, useOcclusionCulling, this.frame);
            }
            catch (Throwable e) {
                System.err.println("Error doing traversal");
                e.printStackTrace();
            }
            if (!chunkUpdates.isEmpty() && (previous = (List)this.atomicBfsResult.getAndSet(chunkUpdates)) != null) {
                for (RenderSection section2 : previous) {
                    if (section2.isDisposed()) continue;
                    ((IRenderSectionExtension)section2).isSeen(false);
                }
            }
            this.blockEntitySectionsRef.set(blockEntitySections);
            this.visibleAnimatedSpritesRef.set(animatedSpriteSet == null ? null : animatedSpriteSet.toArray(new class_1058[0]));
        }
    }

    public final void update(Viewport viewport) {
        List bfsResult;
        this.viewport = viewport;
        if (this.framesAhead.availablePermits() < 5) {
            this.framesAhead.release();
        }
        if ((bfsResult = (List)this.atomicBfsResult.getAndSet(null)) != null) {
            for (RenderSection section : bfsResult) {
                ArrayDeque<RenderSection> queue;
                if (section.isDisposed()) continue;
                ChunkUpdateType type = section.getPendingUpdate();
                if (type != null && section.getBuildCancellationToken() == null && (queue = this.outputRebuildQueue.get(type)).size() < type.getMaximumQueueSize()) {
                    ((IRenderSectionExtension)section).isSubmittedRebuild(true);
                    queue.add(section);
                }
                ((IRenderSectionExtension)section).isSeen(false);
            }
        }
    }

    public void delete() {
        this.running = false;
        this.framesAhead.release(1000);
        try {
            this.cullThread.join();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    private float getSearchDistance() {
        return this.renderDistance;
    }

    private float getSearchDistance2() {
        float distance = SodiumClientMod.options().performance.useFogOcclusion ? this.getEffectiveRenderDistance() : this.getRenderDistance();
        return distance;
    }

    private float getEffectiveRenderDistance() {
        float[] color = RenderSystem.getShaderFogColor();
        float distance = RenderSystem.getShaderFogEnd();
        float renderDistance = this.getRenderDistance();
        return !class_3532.method_15347((float)color[3], (float)1.0f) ? renderDistance : Math.min(renderDistance, distance + 0.5f);
    }

    private float getRenderDistance() {
        return this.renderDistance;
    }

    public int getFrame() {
        return this.frame;
    }

    public List<RenderSection> getLatestSectionsWithEntities() {
        return this.blockEntitySectionsRef.get();
    }

    @Nullable
    public class_1058[] getVisibleAnimatedSprites() {
        return this.visibleAnimatedSpritesRef.get();
    }
}

