/*
 * Decompiled with CFR 0.152.
 */
package me.cortex.nvidium.gl.buffers;

import it.unimi.dsi.fastutil.ints.Int2IntOpenHashMap;
import me.cortex.nvidium.Nvidium;
import me.cortex.nvidium.gl.GlObject;
import me.cortex.nvidium.gl.buffers.IDeviceMappedBuffer;
import org.lwjgl.opengl.ARBDirectStateAccess;
import org.lwjgl.opengl.ARBSparseBuffer;
import org.lwjgl.opengl.GL15C;
import org.lwjgl.opengl.GL21;
import org.lwjgl.opengl.NVShaderBufferLoad;

public class PersistentSparseAddressableBuffer
extends GlObject
implements IDeviceMappedBuffer {
    public final long addr;
    public final long size;
    public static final long PAGE_SIZE = 65536L;
    private final Int2IntOpenHashMap allocationCount = new Int2IntOpenHashMap();

    public static long alignUp(long number, long alignment) {
        long delta = number % alignment;
        return delta == 0L ? number : number + (alignment - delta);
    }

    public PersistentSparseAddressableBuffer(long size) {
        super(ARBDirectStateAccess.glCreateBuffers());
        if (!Nvidium.SUPPORTS_PERSISTENT_SPARSE_ADDRESSABLE_BUFFER) {
            throw new IllegalStateException();
        }
        this.size = PersistentSparseAddressableBuffer.alignUp(size, 65536L);
        ARBDirectStateAccess.glNamedBufferStorage((int)this.id, (long)size, (int)1024);
        long[] holder = new long[1];
        NVShaderBufferLoad.glMakeNamedBufferResidentNV((int)this.id, (int)35002);
        NVShaderBufferLoad.glGetNamedBufferParameterui64vNV((int)this.id, (int)36637, (long[])holder);
        this.addr = holder[0];
        if (this.addr == 0L) {
            throw new IllegalStateException();
        }
    }

    private static void doCommit(int buffer, long offset, long size, boolean commit) {
        GL21.glBindBuffer((int)34962, (int)buffer);
        ARBSparseBuffer.glBufferPageCommitmentARB((int)34962, (long)offset, (long)size, (boolean)commit);
    }

    private void allocatePages(int page, int pageCount) {
        PersistentSparseAddressableBuffer.doCommit(this.id, 65536L * (long)page, 65536L * (long)pageCount, true);
        for (int i = 0; i < pageCount; ++i) {
            this.allocationCount.addTo(i + page, 1);
        }
    }

    private void deallocatePages(int page, int pageCount) {
        for (int i = 0; i < pageCount; ++i) {
            int newCount = this.allocationCount.get(i + page) - 1;
            if (newCount != 0) {
                this.allocationCount.put(i + page, newCount);
                continue;
            }
            this.allocationCount.remove(i + page);
            PersistentSparseAddressableBuffer.doCommit(this.id, 65536L * (long)(page + i), 65536L, false);
        }
    }

    public int getPagesCommitted() {
        return this.allocationCount.size();
    }

    public void ensureAllocated(long addr, long size) {
        int pstart = (int)(addr / 65536L);
        int pend = (int)((addr + size + 65536L - 1L) / 65536L);
        this.allocatePages(pstart, pend - pstart + 1);
    }

    public void deallocate(long addr, long size) {
        int pstart = (int)(addr / 65536L);
        int pend = (int)((addr + size + 65536L - 1L) / 65536L);
        this.deallocatePages(pstart, pend - pstart + 1);
    }

    @Override
    public long getDeviceAddress() {
        return this.addr;
    }

    @Override
    public void delete() {
        NVShaderBufferLoad.glMakeNamedBufferNonResidentNV((int)this.id);
        GL15C.glDeleteBuffers((int)this.id);
    }
}

