/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.impl.client.view;

import com.google.common.base.Stopwatch;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import it.unimi.dsi.fastutil.longs.Long2LongMap;
import it.unimi.dsi.fastutil.longs.Long2LongMaps;
import it.unimi.dsi.fastutil.longs.Long2LongOpenHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import me.shedaniel.rei.api.client.REIRuntime;
import me.shedaniel.rei.api.client.config.ConfigObject;
import me.shedaniel.rei.api.client.registry.category.CategoryRegistry;
import me.shedaniel.rei.api.client.registry.display.DisplayCategory;
import me.shedaniel.rei.api.client.registry.display.DisplayRegistry;
import me.shedaniel.rei.api.client.registry.display.DynamicDisplayGenerator;
import me.shedaniel.rei.api.client.registry.transfer.TransferHandler;
import me.shedaniel.rei.api.client.registry.transfer.TransferHandlerRegistry;
import me.shedaniel.rei.api.client.view.ViewSearchBuilder;
import me.shedaniel.rei.api.client.view.Views;
import me.shedaniel.rei.api.common.category.CategoryIdentifier;
import me.shedaniel.rei.api.common.display.Display;
import me.shedaniel.rei.api.common.display.DisplayMerger;
import me.shedaniel.rei.api.common.entry.EntryIngredient;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.api.common.entry.comparison.ComparisonContext;
import me.shedaniel.rei.api.common.entry.type.EntryDefinition;
import me.shedaniel.rei.api.common.entry.type.VanillaEntryTypes;
import me.shedaniel.rei.api.common.plugins.PluginManager;
import me.shedaniel.rei.api.common.transfer.info.MenuInfo;
import me.shedaniel.rei.api.common.transfer.info.MenuInfoRegistry;
import me.shedaniel.rei.api.common.transfer.info.MenuSerializationContext;
import me.shedaniel.rei.api.common.transfer.info.stack.SlotAccessor;
import me.shedaniel.rei.api.common.util.CollectionUtils;
import me.shedaniel.rei.api.common.util.EntryIngredients;
import me.shedaniel.rei.api.common.util.EntryStacks;
import me.shedaniel.rei.impl.client.gui.craftable.CraftableFilter;
import me.shedaniel.rei.impl.client.gui.widget.AutoCraftingEvaluator;
import me.shedaniel.rei.impl.client.registry.display.DisplayRegistryImpl;
import me.shedaniel.rei.impl.client.registry.display.DisplaysHolder;
import me.shedaniel.rei.impl.client.util.CrashReportUtils;
import me.shedaniel.rei.impl.common.InternalLogger;
import me.shedaniel.rei.impl.display.DisplaySpec;
import me.shedaniel.rei.plugin.autocrafting.DefaultCategoryHandler;
import net.minecraft.class_128;
import net.minecraft.class_148;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_465;
import net.minecraft.class_746;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public class ViewsImpl
implements Views {
    private static final ThreadLocal<ViewSearchBuilder> BUILDER = new ThreadLocal();

    @Override
    @Nullable
    public ViewSearchBuilder getContext() {
        return BUILDER.get();
    }

    public static Map<DisplayCategory<?>, List<DisplaySpec>> buildMapFor(ViewSearchBuilder builder) {
        BUILDER.set(builder);
        try {
            Map<DisplayCategory<?>, List<DisplaySpec>> map = ViewsImpl._buildMapFor(builder);
            return map;
        }
        finally {
            BUILDER.remove();
        }
    }

    private static Map<DisplayCategory<?>, List<DisplaySpec>> _buildMapFor(ViewSearchBuilder builder) {
        LinkedHashSet<Display> set;
        if (PluginManager.areAnyReloading()) {
            InternalLogger.getInstance().info("Cancelled Views buildMap since plugins have not finished reloading.");
            return Maps.newLinkedHashMap();
        }
        Stopwatch stopwatch = Stopwatch.createStarted();
        boolean processingVisibilityHandlers = builder.isProcessingVisibilityHandlers();
        Set<CategoryIdentifier<?>> categories = builder.getCategories();
        Set<CategoryIdentifier<?>> filteringCategories = builder.getFilteringCategories();
        List<EntryStack<?>> recipesForStacks = builder.getRecipesFor();
        List<EntryStack<?>> usagesForStacks = builder.getUsagesFor();
        Function<EntryStack, Collection> wildcardFunction = stack -> {
            EntryStack wildcard = stack.wildcard();
            if (EntryStacks.equalsFuzzy(wildcard, stack)) {
                return Collections.emptyList();
            }
            return Collections.singletonList(wildcard);
        };
        List<EntryStack<?>> recipesForStacksWildcard = CollectionUtils.flatMap(recipesForStacks, wildcardFunction);
        List<EntryStack<?>> usagesForStacksWildcard = CollectionUtils.flatMap(usagesForStacks, wildcardFunction);
        DisplayRegistry displayRegistry = DisplayRegistry.getInstance();
        DisplaysHolder displaysHolder = ((DisplayRegistryImpl)displayRegistry).displaysHolder();
        LinkedHashMap result = Maps.newLinkedHashMap();
        for (Object categoryConfiguration : CategoryRegistry.getInstance()) {
            DisplayCategory displayCategory = categoryConfiguration.getCategory();
            if (processingVisibilityHandlers && CategoryRegistry.getInstance().isCategoryInvisible(displayCategory)) continue;
            CategoryIdentifier<?> categoryIdentifier = categoryConfiguration.getCategoryIdentifier();
            if (!filteringCategories.isEmpty() && !filteringCategories.contains(categoryIdentifier)) continue;
            List<?> list = displayRegistry.get(categoryIdentifier);
            set = Sets.newLinkedHashSet();
            if (categories.contains(categoryIdentifier)) {
                for (Display display2 : list) {
                    if (processingVisibilityHandlers && !displayRegistry.isDisplayVisible(display2)) continue;
                    set.add(display2);
                }
                if (set.isEmpty()) continue;
                CollectionUtils.getOrPutEmptyList(result, displayCategory).addAll(set);
                continue;
            }
            for (Display display2 : list) {
                if (processingVisibilityHandlers && !displayRegistry.isDisplayVisible(display2)) continue;
                if (!recipesForStacks.isEmpty() && ViewsImpl.isRecipesFor(displaysHolder, recipesForStacks, display2)) {
                    set.add(display2);
                    continue;
                }
                if (usagesForStacks.isEmpty() || !ViewsImpl.isUsagesFor(displaysHolder, usagesForStacks, display2)) continue;
                set.add(display2);
            }
            if (!(!set.isEmpty() || recipesForStacksWildcard.isEmpty() && usagesForStacksWildcard.isEmpty())) {
                for (Display display2 : list) {
                    if (processingVisibilityHandlers && !displayRegistry.isDisplayVisible(display2)) continue;
                    if (!recipesForStacksWildcard.isEmpty() && ViewsImpl.isRecipesFor(displaysHolder, recipesForStacksWildcard, display2)) {
                        set.add(display2);
                        continue;
                    }
                    if (usagesForStacksWildcard.isEmpty() || !ViewsImpl.isUsagesFor(displaysHolder, usagesForStacksWildcard, display2)) continue;
                    set.add(display2);
                }
            }
            for (EntryStack usagesFor : Iterables.concat(usagesForStacks, usagesForStacksWildcard)) {
                if (!ViewsImpl.isStackWorkStationOfCategory(categoryConfiguration, usagesFor)) continue;
                if (processingVisibilityHandlers) {
                    set.addAll(CollectionUtils.filterToSet(list, displayRegistry::isDisplayVisible));
                    break;
                }
                set.addAll(list);
                break;
            }
            if (set.isEmpty()) continue;
            CollectionUtils.getOrPutEmptyList(result, displayCategory).addAll(set);
        }
        int generatorsCount = 0;
        for (Map.Entry entry : displayRegistry.getCategoryDisplayGenerators().entrySet()) {
            CategoryIdentifier categoryIdentifier = (CategoryIdentifier)entry.getKey();
            DisplayCategory displayCategory = CategoryRegistry.getInstance().get(categoryIdentifier).getCategory();
            if (processingVisibilityHandlers && CategoryRegistry.getInstance().isCategoryInvisible(displayCategory) || !filteringCategories.isEmpty() && !filteringCategories.contains(categoryIdentifier)) continue;
            set = new LinkedHashSet<Display>();
            generatorsCount += ((List)entry.getValue()).size();
            for (DynamicDisplayGenerator generator : (List)entry.getValue()) {
                ViewsImpl.generateLiveDisplays(displayRegistry, ViewsImpl.wrapForError(generator), builder, set::add);
            }
            if (set.isEmpty()) continue;
            CollectionUtils.getOrPutEmptyList(result, displayCategory).addAll(set);
        }
        Consumer<Display> displayConsumer = display -> {
            CategoryIdentifier<?> categoryIdentifier = display.getCategoryIdentifier();
            if (!filteringCategories.isEmpty() && !filteringCategories.contains(categoryIdentifier)) {
                return;
            }
            CollectionUtils.getOrPutEmptyList(result, CategoryRegistry.getInstance().get(categoryIdentifier).getCategory()).add(display);
        };
        for (DynamicDisplayGenerator<?> dynamicDisplayGenerator : displayRegistry.getGlobalDisplayGenerators()) {
            ++generatorsCount;
            ViewsImpl.generateLiveDisplays(displayRegistry, ViewsImpl.wrapForError(dynamicDisplayGenerator), builder, displayConsumer);
        }
        LinkedHashMap linkedHashMap = new LinkedHashMap(result);
        if (builder.isMergingDisplays() && ConfigObject.getInstance().doMergeDisplayUnderOne()) {
            for (Map.Entry entry : result.entrySet()) {
                DisplayMerger merger = ((DisplayCategory)entry.getKey()).getDisplayMerger();
                if (merger == null) continue;
                class Wrapped
                implements DisplaySpec {
                    private final Display display;
                    private List<class_2960> ids = null;
                    private final int hash;
                    final /* synthetic */ DisplayMerger val$merger;

                    public Wrapped(Display display2) {
                        this.val$merger = display2;
                        this.display = display;
                        this.hash = this.val$merger.hashOf(display);
                    }

                    public boolean equals(Object o) {
                        if (this == o) {
                            return true;
                        }
                        if (!(o instanceof Wrapped)) {
                            return false;
                        }
                        Wrapped wrapped = (Wrapped)o;
                        return this.hash == wrapped.hash && this.val$merger.canMerge(this.display, wrapped.display);
                    }

                    public int hashCode() {
                        return this.hash;
                    }

                    @Override
                    public Display provideInternalDisplay() {
                        return this.display;
                    }

                    @Override
                    public Collection<class_2960> provideInternalDisplayIds() {
                        if (this.ids == null) {
                            this.ids = new ArrayList<class_2960>();
                            Optional<class_2960> location = this.display.getDisplayLocation();
                            if (location.isPresent()) {
                                this.ids.add(location.get());
                            }
                        }
                        return this.ids;
                    }

                    public void add(Display display) {
                        Optional<class_2960> location = display.getDisplayLocation();
                        if (location.isPresent()) {
                            this.provideInternalDisplayIds().add(location.get());
                        }
                    }
                }
                LinkedHashMap<Wrapped, Wrapped> wrappedSet = new LinkedHashMap<Wrapped, Wrapped>();
                ArrayList<Wrapped> wrappeds = new ArrayList<Wrapped>();
                for (Display display3 : ViewsImpl.sortAutoCrafting((List)entry.getValue())) {
                    Wrapped wrapped = new Wrapped(display3, merger);
                    if (wrappedSet.containsKey(wrapped)) {
                        ((Wrapped)wrappedSet.get(wrapped)).add(display3);
                        continue;
                    }
                    wrappedSet.put(wrapped, wrapped);
                    wrappeds.add(wrapped);
                }
                linkedHashMap.put((DisplayCategory)entry.getKey(), wrappeds);
            }
        }
        String string = String.format("Built Recipe View in %s for %d categories, %d recipes for, %d usages for and %d live recipe generators.", stopwatch.stop(), categories.size(), recipesForStacks.size(), usagesForStacks.size(), generatorsCount);
        if (ConfigObject.getInstance().doDebugSearchTimeRequired()) {
            InternalLogger.getInstance().info(string);
        } else {
            InternalLogger.getInstance().trace(string);
        }
        return linkedHashMap;
    }

    public static boolean isRecipesFor(@Nullable DisplaysHolder displaysHolder, List<EntryStack<?>> stacks, Display display) {
        Iterator<EntryStack<?>> iterator;
        if (displaysHolder != null && displaysHolder.isCached(display) && (iterator = stacks.iterator()).hasNext()) {
            EntryStack<?> recipesFor = iterator.next();
            return displaysHolder.getDisplaysByOutput(recipesFor).contains(display);
        }
        return ViewsImpl.checkUsages(stacks, display, display.getOutputEntries());
    }

    public static boolean isUsagesFor(@Nullable DisplaysHolder displaysHolder, List<EntryStack<?>> stacks, Display display) {
        Iterator<EntryStack<?>> iterator;
        if (displaysHolder != null && displaysHolder.isCached(display) && (iterator = stacks.iterator()).hasNext()) {
            EntryStack<?> recipesFor = iterator.next();
            return displaysHolder.getDisplaysByInput(recipesFor).contains(display);
        }
        return ViewsImpl.checkUsages(stacks, display, display.getInputEntries());
    }

    private static boolean checkUsages(List<EntryStack<?>> stacks, Display display, List<EntryIngredient> entries) {
        for (EntryIngredient results : entries) {
            for (EntryStack otherEntry : results) {
                for (EntryStack<?> recipesFor : stacks) {
                    if (!EntryStacks.equalsFuzzy(otherEntry, recipesFor)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private static Iterable<Display> sortAutoCrafting(List<Display> displays) {
        LinkedHashSet<Display> successfulDisplays = new LinkedHashSet<Display>();
        LinkedHashSet<Display> applicableDisplays = new LinkedHashSet<Display>();
        for (Display display2 : displays) {
            AutoCraftingEvaluator.AutoCraftingResult result = AutoCraftingEvaluator.evaluateAutoCrafting(false, false, display2, null);
            if (result.successful) {
                successfulDisplays.add(display2);
                continue;
            }
            if (!result.hasApplicable) continue;
            applicableDisplays.add(display2);
        }
        return Iterables.concat(successfulDisplays, applicableDisplays, (Iterable)Iterables.filter(displays, display -> !successfulDisplays.contains(display) && !applicableDisplays.contains(display)));
    }

    private static <T extends Display> void generateLiveDisplays(DisplayRegistry displayRegistry, DynamicDisplayGenerator<T> generator, ViewSearchBuilder builder, Consumer<T> displayConsumer) {
        boolean processingVisibilityHandlers = builder.isProcessingVisibilityHandlers();
        for (EntryStack<?> stack : builder.getRecipesFor()) {
            Optional<List<T>> recipeForDisplays = generator.getRecipeFor(stack);
            if (!recipeForDisplays.isPresent()) continue;
            for (Display display : recipeForDisplays.get()) {
                if (processingVisibilityHandlers && !displayRegistry.isDisplayVisible(display)) continue;
                displayConsumer.accept(display);
            }
        }
        for (EntryStack<?> stack : builder.getUsagesFor()) {
            Optional<List<T>> usageForDisplays = generator.getUsageFor(stack);
            if (!usageForDisplays.isPresent()) continue;
            for (Display display : usageForDisplays.get()) {
                if (processingVisibilityHandlers && !displayRegistry.isDisplayVisible(display)) continue;
                displayConsumer.accept(display);
            }
        }
        Optional<List<T>> displaysGenerated = generator.generate(builder);
        if (displaysGenerated.isPresent()) {
            for (Display display : displaysGenerated.get()) {
                if (processingVisibilityHandlers && !displayRegistry.isDisplayVisible(display)) continue;
                displayConsumer.accept(display);
            }
        }
    }

    private static <T extends Display> DynamicDisplayGenerator<T> wrapForError(final DynamicDisplayGenerator<T> generator) {
        return new DynamicDisplayGenerator<T>(){

            @Override
            public Optional<List<T>> getRecipeFor(EntryStack<?> entry) {
                try {
                    return generator.getRecipeFor(entry);
                }
                catch (Throwable throwable) {
                    class_128 report = CrashReportUtils.essential(throwable, "Error while generating recipes for an entry stack");
                    CrashReportUtils.renderer(report, entry);
                    InternalLogger.getInstance().throwException((Throwable)new class_148(report));
                    return Optional.empty();
                }
            }

            @Override
            public Optional<List<T>> getUsageFor(EntryStack<?> entry) {
                try {
                    return generator.getUsageFor(entry);
                }
                catch (Throwable throwable) {
                    class_128 report = CrashReportUtils.essential(throwable, "Error while generating usages for an entry stack");
                    CrashReportUtils.renderer(report, entry);
                    InternalLogger.getInstance().throwException((Throwable)new class_148(report));
                    return Optional.empty();
                }
            }

            @Override
            public Optional<List<T>> generate(ViewSearchBuilder builder) {
                try {
                    return generator.generate(builder);
                }
                catch (Throwable throwable) {
                    class_128 report = CrashReportUtils.essential(throwable, "Error while generating recipes for a search");
                    InternalLogger.getInstance().throwException((Throwable)new class_148(report));
                    return Optional.empty();
                }
            }
        };
    }

    @Override
    public Collection<EntryStack<?>> findCraftableEntriesByMaterials() {
        if (PluginManager.areAnyReloading()) {
            return Collections.emptySet();
        }
        class_1703 menu = class_310.method_1551().field_1724.field_7512;
        HashSet craftables = new HashSet();
        class_465<?> containerScreen = REIRuntime.getInstance().getPreviousContainerScreen();
        for (Map.Entry<CategoryIdentifier<?>, List<Display>> entry : DisplayRegistry.getInstance().getAll().entrySet()) {
            MenuSerializationContext<class_1703, class_746, Display> context = ViewsImpl.createLegacyContext(menu, entry.getKey().cast());
            List<Display> displays = entry.getValue();
            for (Display display : displays) {
                try {
                    TransferHandler.Context transferContext = TransferHandler.Context.create(false, false, containerScreen, display);
                    boolean successful = ViewsImpl.matchesLegacyRequirements(menu, context, display);
                    if (!successful) {
                        for (TransferHandler handler : TransferHandlerRegistry.getInstance()) {
                            if (handler instanceof DefaultCategoryHandler || !handler.checkApplicable(transferContext).isSuccessful() || !handler.handle(transferContext).isSuccessful()) continue;
                            successful = true;
                            break;
                        }
                    }
                    if (!successful) continue;
                    display.getOutputEntries().stream().flatMap(Collection::stream).collect(Collectors.toCollection(() -> craftables));
                }
                catch (Throwable t) {
                    InternalLogger.getInstance().warn("Error while checking if display is craftable", t);
                }
            }
        }
        return craftables;
    }

    private static MenuSerializationContext<class_1703, class_746, Display> createLegacyContext(final class_1703 menu, final CategoryIdentifier<Display> categoryIdentifier) {
        class InfoSerializationContext
        implements MenuSerializationContext<class_1703, class_746, Display> {
            InfoSerializationContext() {
            }

            @Override
            public class_1703 getMenu() {
                return menu;
            }

            @Override
            public class_746 getPlayerEntity() {
                return class_310.method_1551().field_1724;
            }

            @Override
            public CategoryIdentifier<Display> getCategoryIdentifier() {
                return categoryIdentifier;
            }
        }
        return new InfoSerializationContext();
    }

    private static boolean matchesLegacyRequirements(class_1703 menu, MenuSerializationContext<class_1703, class_746, Display> context, Display display) {
        MenuInfo<class_1703, Display> info;
        MenuInfo<class_1703, Display> menuInfo = info = menu != null ? MenuInfoRegistry.getInstance().getClient(display, context, menu) : null;
        if (menu != null && info == null) {
            return false;
        }
        Set<SlotAccessor> inputSlots = info != null ? Iterables.concat(info.getInputSlots(context.withDisplay(display)), info.getInventorySlots(context.withDisplay(display))) : Collections.emptySet();
        int slotsCraftable = 0;
        boolean containsNonEmpty = false;
        List<EntryIngredient> requiredInput = display.getRequiredEntries();
        Long2LongOpenHashMap invCount = new Long2LongOpenHashMap((Long2LongMap)(info == null ? CraftableFilter.INSTANCE.getInvStacks() : Long2LongMaps.EMPTY_MAP));
        for (SlotAccessor inputSlot : inputSlots) {
            EntryDefinition<class_1799> definition;
            class_1799 stack = inputSlot.getItemStack();
            try {
                definition = VanillaEntryTypes.ITEM.getDefinition();
            }
            catch (NullPointerException e) {
                break;
            }
            if (stack.method_7960()) continue;
            long hash = definition.hash(null, stack, ComparisonContext.FUZZY);
            long newCount = invCount.get(hash) + (long)Math.max(0, stack.method_7947());
            invCount.put(hash, newCount);
        }
        block3: for (EntryIngredient slot : requiredInput) {
            if (slot.isEmpty()) {
                ++slotsCraftable;
                continue;
            }
            for (EntryStack slotPossible : slot) {
                if (slotPossible.getType() != VanillaEntryTypes.ITEM) continue;
                class_1799 stack = (class_1799)slotPossible.castValue();
                long hashFuzzy = EntryStacks.hashFuzzy(slotPossible);
                long availableAmount = invCount.get(hashFuzzy);
                if (availableAmount < (long)stack.method_7947()) continue;
                invCount.put(hashFuzzy, availableAmount - (long)stack.method_7947());
                containsNonEmpty = true;
                ++slotsCraftable;
                continue block3;
            }
        }
        return slotsCraftable == display.getRequiredEntries().size() && containsNonEmpty;
    }

    private static <T> boolean isStackWorkStationOfCategory(CategoryRegistry.CategoryConfiguration<?> category, EntryStack<T> stack) {
        for (EntryIngredient ingredient : category.getWorkstations()) {
            if (!EntryIngredients.testFuzzy(ingredient, stack)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void startReload() {
    }
}

