/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.impl.client.gui.widget.region;

import me.shedaniel.clothconfig2.api.animator.NumberAnimator;
import me.shedaniel.clothconfig2.api.animator.ValueAnimator;
import me.shedaniel.math.FloatingPoint;
import me.shedaniel.rei.api.client.config.ConfigObject;
import me.shedaniel.rei.api.client.entry.region.RegionEntry;
import me.shedaniel.rei.impl.client.gui.widget.entrylist.EntryListWidget;
import me.shedaniel.rei.impl.client.gui.widget.region.EntryStacksRegionWidget;
import me.shedaniel.rei.impl.client.gui.widget.region.RegionEntryWidget;

public class RealRegionEntry<T extends RegionEntry<T>> {
    public EntryStacksRegionWidget<T> region;
    private T entry;
    private final RegionEntryWidget<T> widget;
    private boolean hidden;
    public ValueAnimator<FloatingPoint> pos = ValueAnimator.ofFloatingPoint();
    public NumberAnimator<Double> size = ValueAnimator.ofDouble();

    public RealRegionEntry(EntryStacksRegionWidget<T> region, T entry, int entrySize) {
        this.region = region;
        this.entry = entry;
        this.widget = (RegionEntryWidget)new RegionEntryWidget(this, 0, 0, entrySize).noBackground();
    }

    public void remove() {
        if (!this.hidden) {
            this.hidden = true;
            if (!ConfigObject.getInstance().isFavoritesAnimated()) {
                this.size.setAs(0);
            } else {
                this.size.setTo(0, 400L);
            }
        }
    }

    public void update(double delta) {
        this.pos.update(delta);
        this.size.update(delta);
        this.getWidget().getBounds().width = this.getWidget().getBounds().height = (int)Math.round(this.size.doubleValue() / 100.0);
        double offsetSize = ((double)EntryListWidget.entrySize() - this.size.doubleValue() / 100.0) / 2.0;
        this.getWidget().getBounds().x = (int)Math.round(((FloatingPoint)this.pos.value()).x + offsetSize);
        this.getWidget().getBounds().y = (int)Math.round(((FloatingPoint)this.pos.value()).y + offsetSize) - (int)this.region.getScrollAmount();
    }

    public RegionEntryWidget<T> getWidget() {
        return this.widget;
    }

    public boolean isHidden() {
        return this.hidden;
    }

    public int hashIgnoreAmount() {
        return this.entry.hashCode();
    }

    public T getEntry() {
        return this.entry;
    }

    public void moveTo(boolean animated, int xPos, int yPos) {
        this.pos.setTo((Object)new FloatingPoint((double)xPos, (double)yPos), animated && ConfigObject.getInstance().isFavoritesAnimated() ? 200L : -1L);
    }
}

