/*
 * Decompiled with CFR 0.152.
 */
package nl.enjarai.showmeyourskin.gui.widget;

import com.google.common.collect.Lists;
import com.mojang.authlib.GameProfile;
import java.util.List;
import java.util.UUID;
import java.util.function.Consumer;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_362;
import net.minecraft.class_364;
import net.minecraft.class_4068;
import net.minecraft.class_6379;
import net.minecraft.class_6382;
import net.minecraft.class_640;
import nl.enjarai.showmeyourskin.client.cursed.DummyClientPlayerEntity;
import nl.enjarai.showmeyourskin.gui.widget.ConfigEntryWidget;
import nl.enjarai.showmeyourskin.gui.widget.PlayerSelectorEntry;
import org.jetbrains.annotations.Nullable;

public class PlayerSelectorWidget
extends class_362
implements class_4068,
class_364,
class_6379 {
    protected final class_310 client;
    protected int screenWidth;
    protected int screenHeight;
    protected int x;
    protected int y;
    protected int width;
    protected int height;
    protected Consumer<ConfigEntryWidget> onSelect;
    private final List<ConfigEntryWidget> entries = Lists.newArrayList();
    private final List<ConfigEntryWidget> allEntries = Lists.newArrayList();
    private int scroll = 0;
    private ConfigEntryWidget selected;
    private ConfigEntryWidget defaultSelected;

    public PlayerSelectorWidget(class_310 client, int screenWidth, int screenHeight, int x, int y, int width, Consumer<ConfigEntryWidget> onSelect) {
        this.screenWidth = screenWidth;
        this.screenHeight = screenHeight;
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = 30;
        this.client = client;
        this.onSelect = onSelect;
    }

    public void linkDefault(ConfigEntryWidget defaultSelected) {
        this.defaultSelected = defaultSelected;
    }

    public void updatePosition(int screenWidth, int screenHeight, int x, int y) {
        this.screenWidth = screenWidth;
        this.screenHeight = screenHeight;
        this.x = x;
        this.y = y;
    }

    public void updateEntries() {
        this.entries.clear();
        this.allEntries.clear();
        if (this.client.field_1724 == null) {
            DummyClientPlayerEntity dummyPlayer = DummyClientPlayerEntity.getInstance();
            GameProfile profile = dummyPlayer.method_7334();
            this.entries.add(new PlayerSelectorEntry(this.client, this, profile.getId(), (class_2561)class_2561.method_43469((String)"gui.showmeyourskin.armorScreen.playerName", (Object[])new Object[]{profile.getName()}), dummyPlayer::method_52814));
        } else {
            for (UUID uuid : this.client.field_1724.field_3944.method_31363()) {
                class_640 playerListEntry = this.client.field_1724.field_3944.method_2871(uuid);
                if (playerListEntry == null) continue;
                UUID playerUuid = playerListEntry.method_2966().getId();
                String playerName = playerListEntry.method_2966().getName();
                this.entries.add(new PlayerSelectorEntry(this.client, this, playerUuid, (class_2561)class_2561.method_43469((String)"gui.showmeyourskin.armorScreen.playerName", (Object[])new Object[]{playerName}), () -> ((class_640)playerListEntry).method_52810()));
            }
        }
        this.entries.sort((player1, player2) -> player1.getName().getString().compareToIgnoreCase(player2.getName().getString()));
        this.allEntries.addAll(this.entries);
        if (this.defaultSelected != null && !this.allEntries.contains((Object)this.defaultSelected)) {
            this.allEntries.add(this.defaultSelected);
        }
        this.setSelected(null);
    }

    public void setSelected(@Nullable ConfigEntryWidget player) {
        for (ConfigEntryWidget entry : this.entries) {
            entry.setSelected(false);
        }
        this.defaultSelected.setSelected(false);
        ConfigEntryWidget selected = player == null ? this.defaultSelected : player;
        selected.setSelected(true);
        this.selected = selected;
        this.onSelect.accept(selected);
    }

    public ConfigEntryWidget getSelected() {
        return this.selected;
    }

    @Nullable
    public ConfigEntryWidget getHovered(int mouseX, int mouseY) {
        for (ConfigEntryWidget entry : this.allEntries) {
            int x = this.getEntryX(entry);
            int y = this.getEntryY(entry);
            if (mouseX < x || mouseX >= x + entry.getWidth() || mouseY < y || mouseY >= y + entry.getHeight()) continue;
            return entry;
        }
        return null;
    }

    private int getEntryX(ConfigEntryWidget child) {
        return this.x + this.getEntries().indexOf((Object)child) * 30 - this.scroll;
    }

    private int getEntryY(ConfigEntryWidget child) {
        return this.y;
    }

    private int getMaxScroll() {
        return Math.max(0, this.getEntries().size() * 30 - this.width);
    }

    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        context.method_44379(this.x, 0, this.x + this.width, this.screenHeight);
        List<ConfigEntryWidget> players = this.getEntries();
        for (int i = 0; i < players.size(); ++i) {
            ConfigEntryWidget entry = players.get(i);
            int x = this.getEntryX(entry);
            int y = this.getEntryY(entry);
            entry.directRender(context, i, x, y, mouseX, mouseY, mouseX >= x && mouseX < x + entry.getWidth() && mouseY >= y && mouseY < y + entry.getHeight(), delta);
        }
        context.method_44380();
    }

    public List<ConfigEntryWidget> getEntries() {
        return this.entries;
    }

    public List<? extends class_364> method_25396() {
        return this.getEntries();
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (mouseX >= (double)this.x && mouseX <= (double)(this.x + this.width) && mouseY >= (double)this.y && mouseY <= (double)(this.y + this.height)) {
            for (ConfigEntryWidget child : this.getEntries()) {
                int childX = this.getEntryX(child);
                int childY = this.getEntryY(child);
                if (!(mouseX >= (double)childX) || !(mouseX < (double)(childX + child.getWidth())) || !(mouseY >= (double)childY) || !(mouseY < (double)(childY + child.getHeight()))) continue;
                return child.method_25402(mouseX, mouseY, button);
            }
        }
        return false;
    }

    public boolean method_25401(double mouseX, double mouseY, double horizontalAmount, double verticalAmount) {
        this.scroll = (int)((double)this.scroll - (verticalAmount + horizontalAmount) * 30.0);
        if (this.scroll < 0) {
            this.scroll = 0;
        } else if (this.scroll > this.getMaxScroll()) {
            this.scroll = this.getMaxScroll();
        }
        return true;
    }

    public void method_37020(class_6382 builder) {
    }

    public class_6379.class_6380 method_37018() {
        return class_6379.class_6380.field_33784;
    }

    public boolean method_25405(double mouseX, double mouseY) {
        return mouseX >= (double)this.x && mouseX < (double)(this.x + this.width) && mouseY >= (double)this.y && mouseY < (double)(this.y + this.height);
    }
}

