/*
 * Decompiled with CFR 0.152.
 */
package com.ishland.c2me.base.common.scheduler;

import com.google.common.base.Preconditions;
import com.ishland.c2me.base.common.GlobalExecutors;
import com.ishland.c2me.base.common.scheduler.NeighborLockingManager;
import com.ishland.c2me.base.common.scheduler.ScheduledTask;
import com.ishland.c2me.base.common.scheduler.SchedulingManager;
import java.util.concurrent.CompletableFuture;
import java.util.function.BooleanSupplier;
import java.util.function.Supplier;

public class NeighborLockingTask<T>
implements ScheduledTask {
    private final SchedulingManager schedulingManager;
    private final long center;
    private final long[] names;
    private final BooleanSupplier isCancelled;
    private final Supplier<CompletableFuture<T>> action;
    private final String desc;
    private final boolean async;
    private final CompletableFuture<T> future = new CompletableFuture();
    private boolean acquired = false;

    public NeighborLockingTask(SchedulingManager schedulingManager, long center, long[] names, BooleanSupplier isCancelled, Supplier<CompletableFuture<T>> action, String desc, boolean async) {
        this.schedulingManager = schedulingManager;
        this.center = center;
        this.names = names;
        this.isCancelled = isCancelled;
        this.action = action;
        this.desc = desc;
        this.async = async;
        this.schedulingManager.enqueue(this);
    }

    @Override
    public boolean tryPrepare() {
        NeighborLockingManager lockingManager = this.schedulingManager.getNeighborLockingManager();
        for (long l : this.names) {
            if (!lockingManager.isLocked(l)) continue;
            lockingManager.addReleaseListener(l, () -> this.schedulingManager.enqueue(this));
            return false;
        }
        for (long l : this.names) {
            lockingManager.acquireLock(l);
        }
        this.acquired = true;
        return true;
    }

    @Override
    public void runTask(Runnable postAction) {
        Preconditions.checkNotNull((Object)postAction);
        if (!this.acquired) {
            throw new IllegalStateException();
        }
        CompletableFuture<T> future = this.action.get();
        Preconditions.checkNotNull(future, (Object)"future");
        future.handleAsync((result, throwable) -> {
            this.schedulingManager.getExecutor().execute(() -> {
                NeighborLockingManager lockingManager = this.schedulingManager.getNeighborLockingManager();
                for (long l : this.names) {
                    lockingManager.releaseLock(l);
                }
            });
            try {
                postAction.run();
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
            if (throwable != null) {
                this.future.completeExceptionally((Throwable)throwable);
            } else {
                this.future.complete(result);
            }
            return null;
        }, GlobalExecutors.invokingExecutor);
    }

    @Override
    public long centerPos() {
        return this.center;
    }

    @Override
    public boolean isAsync() {
        return this.async;
    }

    public CompletableFuture<T> getFuture() {
        return this.future;
    }
}

