/*
 * Decompiled with CFR 0.152.
 */
package com.ishland.c2me.base.common.scheduler;

import com.ishland.c2me.base.common.structs.SimpleObjectPool;
import it.unimi.dsi.fastutil.longs.Long2ReferenceOpenHashMap;
import it.unimi.dsi.fastutil.objects.ReferenceArraySet;
import net.minecraft.class_1923;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NeighborLockingManager {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"NeighborLockingManager");
    private final SimpleObjectPool<ReferenceArraySet<Runnable>> pool = new SimpleObjectPool<ReferenceArraySet>(pool -> new ReferenceArraySet(16), ReferenceArraySet::clear, 1024);
    private final Long2ReferenceOpenHashMap<ReferenceArraySet<Runnable>> activeLocks = new Long2ReferenceOpenHashMap();

    public boolean isLocked(long pos) {
        return this.activeLocks.containsKey(pos);
    }

    public void acquireLock(long pos) {
        if (this.isLocked(pos)) {
            throw new IllegalStateException("Already locked");
        }
        this.activeLocks.put(pos, this.pool.alloc());
    }

    public void releaseLock(long pos) {
        if (!this.isLocked(pos)) {
            throw new IllegalStateException("Not locked");
        }
        ReferenceArraySet runnables = (ReferenceArraySet)this.activeLocks.remove(pos);
        for (Runnable runnable : runnables) {
            try {
                runnable.run();
            }
            catch (Throwable t) {
                LOGGER.error("Failed to notify lock release at chunk %s".formatted(new class_1923(pos)), t);
            }
        }
        runnables.clear();
        this.pool.release((ReferenceArraySet<Runnable>)runnables);
    }

    public void addReleaseListener(long pos, Runnable runnable) {
        if (!this.isLocked(pos)) {
            throw new IllegalStateException("Not locked");
        }
        ((ReferenceArraySet)this.activeLocks.get(pos)).add((Object)runnable);
    }
}

