/*
 * Decompiled with CFR 0.152.
 */
package com.ishland.c2me.base.common.config;

import com.electronwill.nightconfig.core.CommentedConfig;
import com.electronwill.nightconfig.core.Config;
import com.electronwill.nightconfig.core.file.CommentedFileConfig;
import com.ishland.c2me.base.common.config.Updaters;
import com.ishland.c2me.base.common.util.BooleanUtils;
import java.nio.file.Path;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Optional;
import java.util.function.Supplier;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.fabricmc.loader.api.Version;
import net.fabricmc.loader.api.metadata.CustomValue;
import net.fabricmc.loader.api.metadata.version.VersionPredicate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigSystem {
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"C2ME Config System");
    private static final long CURRENT_CONFIG_VERSION = 3L;
    private static final Supplier<CommentedFileConfig> configSupplier = () -> (CommentedFileConfig)CommentedFileConfig.builder((Path)FabricLoader.getInstance().getConfigDir().resolve("c2me.toml")).preserveInsertionOrder().sync().build();
    private static final CommentedFileConfig CONFIG;
    private static final HashSet<String> visitedConfig;

    public static void flushConfig() {
        ConfigSystem.purgeUnusedRecursively("", (CommentedConfig)CONFIG);
        CONFIG.save();
    }

    private static void purgeUnusedRecursively(String prefix, CommentedConfig config) {
        Iterator iterator = config.entrySet().iterator();
        while (iterator.hasNext()) {
            CommentedConfig.Entry entry = (CommentedConfig.Entry)iterator.next();
            String key = prefix + "." + entry.getKey();
            Object object = entry.getValue();
            if (object instanceof CommentedConfig) {
                CommentedConfig child = (CommentedConfig)object;
                ConfigSystem.purgeUnusedRecursively(key, child);
                if (!child.isEmpty()) continue;
                LOGGER.info("Removing config entry {} because it is not used", (Object)key);
                iterator.remove();
                continue;
            }
            if (visitedConfig.contains(key.substring(".".length()))) continue;
            LOGGER.info("Removing config entry {} because it is not used", (Object)key);
            iterator.remove();
        }
    }

    static {
        visitedConfig = new HashSet();
        CommentedFileConfig config = configSupplier.get();
        try {
            config.load();
        }
        catch (Throwable t) {
            config = configSupplier.get();
            config.save();
        }
        Updaters.update((Config)config);
        if ((long)config.getInt("version") != 3L) {
            config.clear();
            LOGGER.warn("Config version mismatch, resetting config");
            config.set("version", (Object)3L);
        }
        visitedConfig.add("version");
        CONFIG = config;
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static enum LongChecks {
        THREAD_COUNT{

            @Override
            public boolean test(long value) {
                return value >= 1L && value <= 32767L;
            }
        }
        ,
        NO_TICK_VIEW_DISTANCE{

            @Override
            public boolean test(long value) {
                return value >= 2L && value <= 248L;
            }
        }
        ,
        POSITIVE_VALUES_ONLY{

            @Override
            public boolean test(long value) {
                return value >= 1L;
            }
        };


        public abstract boolean test(long var1);
    }

    public static class ConfigAccessor {
        private static final String propertyPrefix = "c2me.base.config.override.";
        private final StringBuilder incompatibilityReason = new StringBuilder();
        private String key;
        private String comment;
        private boolean incompatibilityDetected;

        public ConfigAccessor key(String key) {
            this.key = key;
            this.markVisited();
            return this;
        }

        public ConfigAccessor comment(String comment) {
            this.comment = comment;
            return this;
        }

        public ConfigAccessor incompatibleMod(String modId, String predicate) {
            try {
                Optional optional = FabricLoader.getInstance().getModContainer(modId);
                if (optional.isPresent()) {
                    ModContainer modContainer = (ModContainer)optional.get();
                    Version version = modContainer.getMetadata().getVersion();
                    VersionPredicate versionPredicate = VersionPredicate.parse((String)predicate);
                    if (versionPredicate.test((Object)version)) {
                        String reason = String.format("Incompatible with %s@%s (%s) (defined in c2me)", modId, version.getFriendlyString(), predicate);
                        this.disableConfigWithReason(reason);
                    }
                }
            }
            catch (Throwable t) {
                throw new IllegalArgumentException(t);
            }
            return this;
        }

        public long getLong(long def, long incompatibleDef, LongChecks ... checks) {
            long configLong;
            boolean isDefaultValue;
            String configured;
            this.findModDefinedIncompatibility();
            String systemPropertyOverride = this.getSystemPropertyOverride();
            String string = configured = systemPropertyOverride != null ? systemPropertyOverride : CONFIG.get(this.key);
            if (configured != null) {
                if (String.valueOf(configured).equals("default")) {
                    isDefaultValue = true;
                } else if (!(configured instanceof Number)) {
                    try {
                        CONFIG.set(this.key, (Object)Long.valueOf(String.valueOf(configured)));
                        isDefaultValue = false;
                    }
                    catch (NumberFormatException e) {
                        LOGGER.warn("Invalid configured value: {} -> {}", (Object)this.key, (Object)configured);
                        CONFIG.remove(this.key);
                        isDefaultValue = true;
                    }
                } else {
                    isDefaultValue = false;
                }
            } else {
                isDefaultValue = true;
            }
            this.generateDefaultEntry(def, incompatibleDef);
            if (this.incompatibilityDetected) {
                return incompatibleDef;
            }
            long l = configLong = isDefaultValue ? def : CONFIG.getLong(this.key);
            if (this.checkConfig(configLong, checks)) {
                return configLong;
            }
            CONFIG.remove(this.key);
            this.generateDefaultEntry(def, incompatibleDef);
            return def;
        }

        private boolean checkConfig(long value, LongChecks ... checks) {
            for (LongChecks check : checks) {
                if (check.test(value)) continue;
                return false;
            }
            return true;
        }

        public boolean getBoolean(boolean def, boolean incompatibleDef) {
            boolean isDefaultValue;
            String configured;
            this.findModDefinedIncompatibility();
            String systemPropertyOverride = this.getSystemPropertyOverride();
            String string = configured = systemPropertyOverride != null ? systemPropertyOverride : CONFIG.get(this.key);
            if (configured != null) {
                if (String.valueOf(configured).equals("default")) {
                    isDefaultValue = true;
                } else if (!(configured instanceof Boolean)) {
                    try {
                        CONFIG.set(this.key, (Object)BooleanUtils.parseBoolean(String.valueOf(configured)));
                        isDefaultValue = false;
                    }
                    catch (BooleanUtils.BooleanFormatException e) {
                        LOGGER.warn("Invalid configured value: {} -> {}", (Object)this.key, (Object)configured);
                        CONFIG.remove(this.key);
                        isDefaultValue = true;
                    }
                } else {
                    isDefaultValue = false;
                }
            } else {
                isDefaultValue = true;
            }
            this.generateDefaultEntry(def, incompatibleDef);
            return this.incompatibilityDetected ? incompatibleDef : (isDefaultValue ? def : (Boolean)CONFIG.get(this.key));
        }

        public <T extends Enum<T>> T getEnum(Class<T> enumClass, T def, T incompatibleDef) {
            boolean isDefaultValue;
            String configured;
            this.findModDefinedIncompatibility();
            String systemPropertyOverride = this.getSystemPropertyOverride();
            String string = configured = systemPropertyOverride != null ? systemPropertyOverride : CONFIG.get(this.key);
            if (configured != null) {
                if (String.valueOf(configured).equals("default")) {
                    isDefaultValue = true;
                } else {
                    try {
                        CONFIG.set(this.key, Enum.valueOf(enumClass, String.valueOf(configured)));
                        isDefaultValue = false;
                    }
                    catch (IllegalArgumentException e) {
                        LOGGER.warn("Invalid configured value: {} -> {}", (Object)this.key, (Object)configured);
                        CONFIG.remove(this.key);
                        isDefaultValue = true;
                    }
                }
            } else {
                isDefaultValue = true;
            }
            this.generateDefaultEntry(def, incompatibleDef);
            return (T)(this.incompatibilityDetected ? incompatibleDef : (isDefaultValue ? def : CONFIG.getEnum(this.key, enumClass)));
        }

        public String getString(String def, String incompatibleDef) {
            boolean isDefaultValue;
            String configured;
            this.findModDefinedIncompatibility();
            String systemPropertyOverride = this.getSystemPropertyOverride();
            String string = configured = systemPropertyOverride != null ? systemPropertyOverride : CONFIG.get(this.key);
            if (configured != null) {
                if (String.valueOf(configured).equals("default")) {
                    isDefaultValue = true;
                } else if (!(configured instanceof String)) {
                    CONFIG.set(this.key, (Object)String.valueOf(configured));
                    isDefaultValue = false;
                } else {
                    isDefaultValue = false;
                }
            } else {
                isDefaultValue = true;
            }
            this.generateDefaultEntry(def, incompatibleDef);
            return this.incompatibilityDetected ? incompatibleDef : (isDefaultValue ? def : (String)CONFIG.get(this.key));
        }

        private void findModDefinedIncompatibility() {
            for (ModContainer modContainer : FabricLoader.getInstance().getAllMods()) {
                CustomValue incompatibilitiesValue = modContainer.getMetadata().getCustomValue("c2me:incompatibleConfig");
                if (incompatibilitiesValue == null || incompatibilitiesValue.getType() != CustomValue.CvType.ARRAY) continue;
                CustomValue.CvArray incompatibilities = incompatibilitiesValue.getAsArray();
                for (CustomValue value : incompatibilities) {
                    if (value.getType() != CustomValue.CvType.STRING || !value.getAsString().equals(this.key)) continue;
                    String reason = String.format("Incompatible with %s@%s (defined in %s)", modContainer.getMetadata().getId(), modContainer.getMetadata().getVersion().getFriendlyString(), modContainer.getMetadata().getId());
                    this.disableConfigWithReason(reason);
                }
            }
        }

        private String getSystemPropertyOverride() {
            String property = System.getProperty(propertyPrefix + this.key);
            if (property != null) {
                LOGGER.info("Setting {} to {} (defined in system property)", (Object)this.key, (Object)property);
            }
            return property;
        }

        private void disableConfigWithReason(String reason) {
            this.incompatibilityReason.append("\n ").append(reason);
            if (!Boolean.getBoolean("com.ishland.c2me.base.config.ignoreIncompatibility")) {
                LOGGER.info("Disabling config {}: {}", (Object)this.key, (Object)reason);
                this.incompatibilityDetected = true;
            } else {
                LOGGER.info("Compatibility issues ignored by system property: {}: {}", (Object)this.key, (Object)reason);
            }
        }

        private void generateDefaultEntry(Object def, Object incompatibleDef) {
            if (!CONFIG.contains(this.key)) {
                CONFIG.set(this.key, (Object)"default");
            }
            String comment = String.format(" (Default: %s) %s", def, this.comment.replace("\n", "\n "));
            if (this.incompatibilityDetected) {
                CONFIG.setComment(this.key, String.format("%s\n Set to %s for the following reasons: %s ", comment, incompatibleDef, this.incompatibilityReason));
            } else {
                CONFIG.setComment(this.key, comment);
            }
        }

        private void markVisited() {
            visitedConfig.add(this.key);
        }
    }
}

