/*
 * Decompiled with CFR 0.152.
 */
package dev.onyxstudios.cca.api.v3.component;

import dev.onyxstudios.cca.api.v3.component.Component;
import dev.onyxstudios.cca.api.v3.component.ComponentContainer;
import dev.onyxstudios.cca.api.v3.component.ComponentProvider;
import dev.onyxstudios.cca.api.v3.component.sync.AutoSyncedComponent;
import dev.onyxstudios.cca.api.v3.component.sync.ComponentPacketWriter;
import dev.onyxstudios.cca.api.v3.component.sync.PlayerSyncPredicate;
import dev.onyxstudios.cca.internal.base.asm.CcaBootstrap;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.class_2596;
import net.minecraft.class_2658;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nullable;

@ApiStatus.NonExtendable
public abstract class ComponentKey<C extends Component> {
    private final class_2960 id;
    private final Class<C> componentClass;

    public final class_2960 getId() {
        return this.id;
    }

    public final Class<C> getComponentClass() {
        return this.componentClass;
    }

    @Contract(pure=true)
    @Nullable
    public C getNullable(Object provider) {
        return this.getInternal(((ComponentProvider)provider).getComponentContainer());
    }

    public final C get(Object provider) {
        C component = this.getInternal(((ComponentProvider)provider).getComponentContainer());
        assert (component == null || this.getComponentClass().isInstance(component));
        if (component == null) {
            try {
                throw new NoSuchElementException(provider + " provides no component of type " + this.getId());
            }
            catch (NullPointerException e) {
                NoSuchElementException e1 = new NoSuchElementException(this.getId() + " not available");
                e1.addSuppressed(e);
                throw e1;
            }
        }
        return component;
    }

    public final Optional<C> maybeGet(@Nullable Object provider) {
        if (provider instanceof ComponentProvider) {
            ComponentProvider p = (ComponentProvider)provider;
            return Optional.ofNullable(this.getInternal(p.getComponentContainer()));
        }
        return Optional.empty();
    }

    @Contract(pure=true)
    public boolean isProvidedBy(Object provider) {
        return this.getNullable(provider) != null;
    }

    public void sync(Object provider) {
        C c = this.get(provider);
        if (c instanceof AutoSyncedComponent) {
            AutoSyncedComponent synced = (AutoSyncedComponent)c;
            this.sync(provider, synced, synced);
        }
    }

    public void sync(Object provider, ComponentPacketWriter packetWriter) {
        C c = this.get(provider);
        if (c instanceof AutoSyncedComponent) {
            AutoSyncedComponent synced = (AutoSyncedComponent)c;
            this.sync(provider, packetWriter, synced);
        }
    }

    public void sync(Object provider, ComponentPacketWriter packetWriter, PlayerSyncPredicate predicate) {
        for (class_3222 player : ((ComponentProvider)provider).getRecipientsForComponentSync()) {
            this.syncWith(player, (ComponentProvider)provider, packetWriter, predicate);
        }
    }

    @ApiStatus.Experimental
    public void syncWith(class_3222 player, ComponentProvider provider) {
        C c = this.get(provider);
        if (c instanceof AutoSyncedComponent) {
            AutoSyncedComponent synced = (AutoSyncedComponent)c;
            this.syncWith(player, provider, synced, synced);
        }
    }

    @ApiStatus.Experimental
    public void syncWith(class_3222 player, ComponentProvider provider, ComponentPacketWriter writer, PlayerSyncPredicate predicate) {
        class_2658 packet;
        if (predicate.shouldSyncWith(player) && (packet = provider.toComponentPacket(this, writer, player)) != null) {
            player.field_13987.method_14364((class_2596)packet);
        }
    }

    public final String toString() {
        return this.getClass().getSimpleName() + "[\"" + this.id + "\"]";
    }

    @ApiStatus.Internal
    protected ComponentKey(class_2960 id, Class<C> componentClass) {
        if (!CcaBootstrap.INSTANCE.isGenerated(this.getClass())) {
            throw new IllegalStateException();
        }
        this.componentClass = componentClass;
        this.id = id;
    }

    @Contract(pure=true)
    @ApiStatus.Internal
    @Nullable
    public abstract C getInternal(ComponentContainer var1);

    @ApiStatus.Internal
    public C getFromContainer(ComponentContainer container) {
        return (C)((Component)Objects.requireNonNull(this.getInternal(container)));
    }
}

