/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.api.event.fabric;

import journeymap.client.api.display.ModPopupMenu;
import journeymap.client.api.display.Waypoint;
import journeymap.client.api.event.fabric.FabricEvent;
import journeymap.client.api.model.IFullscreen;

public class PopupMenuEvent
extends FabricEvent {
    private final ModPopupMenu popupMenu;
    private final Layer layer;
    private final IFullscreen fullscreen;

    public PopupMenuEvent(ModPopupMenu popupMenu, Layer layer, IFullscreen fullscreen) {
        this.popupMenu = popupMenu;
        this.layer = layer;
        this.fullscreen = fullscreen;
    }

    public ModPopupMenu getPopupMenu() {
        return this.popupMenu;
    }

    public Layer getLayer() {
        return this.layer;
    }

    public IFullscreen getFullscreen() {
        return this.fullscreen;
    }

    @Override
    public boolean isCancelable() {
        return true;
    }

    public static enum Layer {
        WAYPOINT,
        FULLSCREEN;

    }

    public static class WaypointPopupMenuEvent
    extends PopupMenuEvent {
        private final Waypoint waypoint;

        public WaypointPopupMenuEvent(ModPopupMenu popupMenu, IFullscreen fullscreen, Waypoint waypoint) {
            super(popupMenu, Layer.WAYPOINT, fullscreen);
            this.waypoint = waypoint;
        }

        public Waypoint getWaypoint() {
            return this.waypoint;
        }
    }

    public static class FullscreenPopupMenuEvent
    extends PopupMenuEvent {
        public FullscreenPopupMenuEvent(ModPopupMenu popupMenu, IFullscreen fullscreen) {
            super(popupMenu, Layer.FULLSCREEN, fullscreen);
        }
    }
}

