/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.api.display;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.collect.Lists;
import com.google.gson.annotations.Since;
import java.util.Arrays;
import javax.annotation.Nullable;
import journeymap.client.api.display.WaypointGroup;
import journeymap.client.api.model.WaypointBase;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_5321;
import org.joml.Vector3d;
import org.joml.Vector3dc;

public class Waypoint
extends WaypointBase<Waypoint> {
    public static final double VERSION = 1.5;
    protected final transient CachedDimPosition cachedDimPosition = new CachedDimPosition();
    @Since(value=1.4)
    protected final double version = 1.5;
    @Since(value=1.4)
    protected String dim;
    @Since(value=1.4)
    protected class_2338 pos;
    @Since(value=1.4)
    protected WaypointGroup group;
    @Since(value=1.4)
    protected boolean persistent = true;
    @Since(value=1.4)
    protected boolean editable = true;
    @Since(value=1.5)
    protected boolean enabled = true;

    public Waypoint(String modId, String name, class_5321<class_1937> dimension, class_2338 position) {
        super(modId, name);
        this.setPosition(dimension.method_29177().toString(), position);
    }

    public Waypoint(String modId, String id, String name, class_5321<class_1937> dimension, class_2338 position) {
        super(modId, id, name);
        this.setPosition(dimension.method_29177().toString(), position);
    }

    public Waypoint(String modId, String id, String name, String dimension, class_2338 position) {
        super(modId, id, name);
        this.setPosition(dimension, position);
    }

    public Waypoint(String modId, String name, String dimension, class_2338 position) {
        super(modId, name);
        this.setPosition(dimension, position);
    }

    public final WaypointGroup getGroup() {
        return this.group;
    }

    public Waypoint setGroup(@Nullable WaypointGroup group) {
        this.group = group;
        return (Waypoint)this.setDirty();
    }

    public final String getDimension() {
        return this.dim;
    }

    public final class_2338 getPosition() {
        return this.pos;
    }

    public class_2338 getPosition(String targetDimension) {
        return this.cachedDimPosition.getPosition(targetDimension);
    }

    private class_2338 getInternalPosition(String targetDimension) {
        if (!this.dim.equalsIgnoreCase(targetDimension)) {
            if (this.dim.equalsIgnoreCase(class_1937.field_25180.method_29177().toString())) {
                this.pos = new class_2338(this.pos.method_10263() * 8, this.pos.method_10264(), this.pos.method_10260() * 8);
            } else if (targetDimension.equalsIgnoreCase(class_1937.field_25180.method_29177().toString())) {
                this.pos = class_2338.method_49637((double)((double)this.pos.method_10263() / 8.0), (double)this.pos.method_10264(), (double)((double)this.pos.method_10260() / 8.0));
            }
        }
        return this.pos;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public Waypoint setPosition(String dimension, class_2338 position) {
        if (position == null) {
            throw new IllegalArgumentException("position may not be null");
        }
        this.dim = dimension;
        this.pos = position;
        this.cachedDimPosition.reset();
        return (Waypoint)this.setDirty();
    }

    public Vector3d getVec(String dimension) {
        return this.cachedDimPosition.getVec(dimension);
    }

    public Vector3d getCenteredVec(String dimension) {
        return this.cachedDimPosition.getCenteredVec(dimension);
    }

    public final boolean isPersistent() {
        return this.persistent;
    }

    public final Waypoint setPersistent(boolean persistent) {
        this.persistent = persistent;
        if (!persistent) {
            this.dirty = false;
        }
        return (Waypoint)this.setDirty();
    }

    public final boolean isEditable() {
        return this.editable;
    }

    public final Waypoint setEditable(boolean editable) {
        this.editable = editable;
        return (Waypoint)this.setDirty();
    }

    public final boolean isTeleportReady(String targetDimension) {
        class_2338 pos = this.getPosition(targetDimension);
        return pos != null && pos.method_10264() >= 0;
    }

    @Override
    protected WaypointGroup getDelegate() {
        return this.getGroup();
    }

    @Override
    protected boolean hasDelegate() {
        return this.group != null;
    }

    @Override
    public String[] getDisplayDimensions() {
        String[] dims = super.getDisplayDimensions();
        if (dims == null) {
            this.setDisplayDimensions(this.dim);
        }
        return this.displayDims;
    }

    @Override
    public int getDisplayOrder() {
        return this.group != null ? this.group.getDisplayOrder() : 0;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Waypoint)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Waypoint that = (Waypoint)o;
        return this.isPersistent() == that.isPersistent() && this.isEditable() == that.isEditable() && Objects.equal((Object)this.getDimension(), (Object)that.getDimension()) && Objects.equal((Object)this.getColor(), (Object)that.getColor()) && Objects.equal((Object)this.getBackgroundColor(), (Object)that.getBackgroundColor()) && Objects.equal((Object)this.getName(), (Object)that.getName()) && Objects.equal((Object)this.getPosition(), (Object)that.getPosition()) && Objects.equal((Object)this.getIcon(), (Object)that.getIcon()) && Arrays.equals(this.getDisplayDimensions(), that.getDisplayDimensions());
    }

    @Override
    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{super.hashCode(), this.getName()});
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("name", (Object)this.name).add("dim", (Object)this.dim).add("pos", (Object)this.pos).add("group", (Object)this.group).add("icon", (Object)this.icon).add("color", (Object)this.color).add("bgColor", (Object)this.bgColor).add("displayDims", this.displayDims == null ? null : Lists.newArrayList((Object[])this.displayDims)).add("editable", this.editable).add("persistent", this.persistent).add("dirty", this.dirty).toString();
    }

    class CachedDimPosition {
        String cachedDim;
        class_2338 cachedPos;
        Vector3d cachedVec;
        Vector3d cachedCenteredVec;

        CachedDimPosition() {
        }

        CachedDimPosition reset() {
            this.cachedDim = null;
            this.cachedPos = null;
            this.cachedVec = null;
            this.cachedCenteredVec = null;
            return this;
        }

        private CachedDimPosition ensure(String dimension) {
            if (this.cachedDim != dimension) {
                this.cachedDim = dimension;
                this.cachedPos = Waypoint.this.getInternalPosition(dimension);
                this.cachedVec = new Vector3d((double)this.cachedPos.method_10263(), (double)this.cachedPos.method_10264(), (double)this.cachedPos.method_10260());
                this.cachedCenteredVec = new Vector3d(0.5, 0.5, 0.5);
                this.cachedCenteredVec.add((Vector3dc)this.cachedVec);
            }
            return this;
        }

        public class_2338 getPosition(String dimension) {
            return this.ensure((String)dimension).cachedPos;
        }

        public Vector3d getVec(String dimension) {
            return this.ensure((String)dimension).cachedVec;
        }

        public Vector3d getCenteredVec(String dimension) {
            return this.ensure((String)dimension).cachedCenteredVec;
        }
    }
}

