/*
 * Decompiled with CFR 0.152.
 */
package org.threadly.util.debug;

import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.atomic.LongAdder;
import java.util.function.Function;
import org.threadly.concurrent.SameThreadSubmitterExecutor;
import org.threadly.concurrent.future.ListenableFuture;
import org.threadly.concurrent.future.SettableListenableFuture;
import org.threadly.util.ArgumentVerifier;
import org.threadly.util.Clock;
import org.threadly.util.ExceptionUtils;
import org.threadly.util.Pair;
import org.threadly.util.StringUtils;
import org.threadly.util.debug.CommonStacktraces;
import org.threadly.util.debug.ComparableTrace;

public class Profiler {
    protected static final short DEFAULT_POLL_INTERVAL_IN_MILLIS = 100;
    protected static final short NUMBER_TARGET_LINE_LENGTH = 8;
    protected static final String FUNCTION_BY_NET_HEADER;
    protected static final String FUNCTION_BY_COUNT_HEADER;
    private static final short DEFAULT_MAP_INITIAL_SIZE = 16;
    private static final Set<String> BLACKLIST_THREAD_NAMES;
    protected final Object startStopLock = new Object();
    protected final ProfileStorage pStore;
    protected final List<WeakReference<SettableListenableFuture<String>>> stopFutures;
    private final Function<? super Profiler, String> startFutureResultSupplier;

    public Profiler() {
        this(100, null);
    }

    public Profiler(int pollIntervalInMs) {
        this(pollIntervalInMs, null);
    }

    public Profiler(int pollIntervalInMs, Function<? super Profiler, String> startFutureResultSupplier) {
        this(new ProfileStorage(pollIntervalInMs), startFutureResultSupplier);
    }

    protected Profiler(ProfileStorage pStore, Function<? super Profiler, String> startFutureResultSupplier) {
        this.pStore = pStore;
        this.stopFutures = new ArrayList<WeakReference<SettableListenableFuture<String>>>(2);
        this.startFutureResultSupplier = startFutureResultSupplier == null ? Profiler::dump : startFutureResultSupplier;
    }

    public void setPollInterval(int pollIntervalInMs) {
        ArgumentVerifier.assertNotNegative(pollIntervalInMs, "pollIntervalInMs");
        this.pStore.pollIntervalInMs = pollIntervalInMs;
    }

    public int getPollInterval() {
        return this.pStore.pollIntervalInMs;
    }

    public int getCollectedSampleQty() {
        return this.pStore.collectedSamples.intValue();
    }

    public void reset() {
        this.pStore.threadTraces.clear();
        this.pStore.collectedSamples.reset();
    }

    public boolean isRunning() {
        return this.pStore.collectorThread.get() != null;
    }

    public void start() {
        this.start(null, -1L, null);
    }

    public void start(Executor executor) {
        this.start(executor, -1L, null);
    }

    public ListenableFuture<String> start(long sampleDurationInMillis) {
        return this.start(null, sampleDurationInMillis);
    }

    public ListenableFuture<String> start(Executor executor, long sampleDurationInMillis) {
        SettableListenableFuture<String> result = new SettableListenableFuture<String>();
        this.start(executor, sampleDurationInMillis, result);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void start(Executor executor, final long sampleDurationInMillis, SettableListenableFuture<String> completionFuture) {
        ProfilerRunner pr = new ProfilerRunner(this.pStore);
        boolean runInCallingThread = false;
        Thread callingThread = null;
        Object object = this.startStopLock;
        synchronized (object) {
            if (sampleDurationInMillis > 0L) {
                this.stop();
            }
            if (completionFuture != null) {
                this.stopFutures.add(new WeakReference<SettableListenableFuture<String>>(completionFuture));
            }
            if (this.pStore.collectorThread.get() == null) {
                if (executor == null) {
                    Thread thread = new Thread(pr);
                    this.pStore.collectorThread.set(thread);
                    thread.setName("Threadly Profiler data collector");
                    thread.setPriority(10);
                    thread.start();
                } else if (executor == SameThreadSubmitterExecutor.instance() || executor instanceof SameThreadSubmitterExecutor) {
                    callingThread = Thread.currentThread();
                    this.pStore.collectorThread.set(callingThread);
                    runInCallingThread = true;
                } else {
                    SettableListenableFuture runningThreadFuture = new SettableListenableFuture();
                    executor.execute(new ExecutorRunnerTask(this.pStore, runningThreadFuture, pr));
                    try {
                        runningThreadFuture.get();
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        return;
                    }
                    catch (ExecutionException e) {
                        throw ExceptionUtils.makeRuntime(e.getCause());
                    }
                }
                if (sampleDurationInMillis > 0L) {
                    this.pStore.dumpLoopRun = new Runnable(){
                        private final long startTime = Clock.accurateForwardProgressingMillis();

                        @Override
                        public void run() {
                            if (Clock.lastKnownForwardProgressingMillis() - this.startTime > sampleDurationInMillis) {
                                Profiler.this.pStore.dumpLoopRun = null;
                                Profiler.this.stop();
                            }
                        }
                    };
                }
            }
        }
        if (runInCallingThread) {
            int origPriority = callingThread.getPriority();
            try {
                if (origPriority < 10) {
                    callingThread.setPriority(10);
                }
                pr.run();
            }
            finally {
                if (origPriority < 10) {
                    callingThread.setPriority(origPriority);
                }
            }
            Thread.interrupted();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        Object object = this.startStopLock;
        synchronized (object) {
            Thread runningThread = this.pStore.collectorThread.get();
            if (runningThread != null) {
                runningThread.interrupt();
                this.pStore.collectorThread.set(null);
                if (!this.stopFutures.isEmpty()) {
                    boolean needToGenerateResult = true;
                    String result = null;
                    Iterator<WeakReference<SettableListenableFuture<String>>> it = this.stopFutures.iterator();
                    while (it.hasNext()) {
                        SettableListenableFuture slf = (SettableListenableFuture)it.next().get();
                        if (slf == null) continue;
                        if (needToGenerateResult) {
                            needToGenerateResult = false;
                            result = this.startFutureResultSupplier.apply(this);
                        }
                        slf.setResult(result);
                    }
                    this.stopFutures.clear();
                }
            }
        }
    }

    public String dump() {
        return this.dump(true, 1);
    }

    public String dump(boolean dumpIndividualThreads, int minimumStackWitnessCount) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        this.dump(new BufferedOutputStream(baos), dumpIndividualThreads, minimumStackWitnessCount);
        return baos.toString();
    }

    public void dump(OutputStream out) {
        this.dump(out, true, 1);
    }

    public void dump(OutputStream out, boolean dumpIndividualThreads, int minimumStackWitnessCount) {
        this.dump(new PrintStream(out, false), dumpIndividualThreads, minimumStackWitnessCount);
    }

    public void dump(PrintStream ps) {
        this.dump(ps, true, 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dump(PrintStream ps, boolean dumpIndividualThreads, int minimumStackWitnessCount) {
        this.pStore.dumpingThread = Thread.currentThread();
        try {
            HashMap<Trace, Integer> globalTraces = new HashMap<Trace, Integer>();
            List<Pair<ThreadIdentifier, ThreadSamples>> threadSamples = Pair.convertMap(this.pStore.threadTraces);
            Collections.sort(threadSamples, (p1, p2) -> ((ThreadSamples)p1.getRight()).threadNames().compareTo(((ThreadSamples)p2.getRight()).threadNames()));
            for (Pair<ThreadIdentifier, ThreadSamples> entry : threadSamples) {
                if (dumpIndividualThreads) {
                    ps.println("Profile for thread: " + entry.getRight().threadNames() + ";" + entry.getLeft().threadId);
                    Profiler.dumpTraces(entry.getRight().traceSet(), null, ps, minimumStackWitnessCount);
                }
                Iterator<Trace> traceIt = entry.getRight().traceSet().iterator();
                while (traceIt.hasNext()) {
                    globalTraces.compute(traceIt.next(), (k, v) -> v == null ? k.getThreadCount() : v + k.getThreadCount());
                }
                if (!dumpIndividualThreads) continue;
                ps.println("--------------------------------------------------");
                ps.println();
            }
            if (globalTraces.size() > 1 || !dumpIndividualThreads) {
                ps.println("Combined profile for all threads....");
                Profiler.dumpTraces(globalTraces.keySet(), globalTraces, ps, minimumStackWitnessCount);
            }
            ps.flush();
        }
        finally {
            this.pStore.dumpingThread = null;
        }
    }

    private static void dumpTraces(Set<Trace> traces, Map<Trace, Integer> globalCounts, PrintStream out, int minimumStackWitnessCount) {
        int i;
        HashMap<WitnessedFunction, WitnessedFunction> methods = new HashMap<WitnessedFunction, WitnessedFunction>();
        Trace[] traceArray = traces.toArray(new Trace[traces.size()]);
        int total = 0;
        int nativeCount = 0;
        for (Trace t : traceArray) {
            total = globalCounts != null ? (total += globalCounts.get(t).intValue()) : (total += t.getThreadCount());
            if (t.elements.length > 0 && t.elements[0].isNativeMethod()) {
                nativeCount = globalCounts != null ? (nativeCount += globalCounts.get(t).intValue()) : (nativeCount += t.getThreadCount());
            }
            for (int i2 = 0; i2 < t.elements.length; ++i2) {
                WitnessedFunction n = new WitnessedFunction(t.elements[i2].getClassName(), t.elements[i2].getMethodName());
                WitnessedFunction f = (WitnessedFunction)methods.get(n);
                if (f == null) {
                    methods.put(n, n);
                    f = n;
                }
                if (globalCounts != null) {
                    f.incrementCount(globalCounts.get(t), i2 > 0);
                    continue;
                }
                f.incrementCount(t.getThreadCount(), i2 > 0);
            }
        }
        WitnessedFunction[] methodArray = methods.keySet().toArray(new WitnessedFunction[methods.size()]);
        out.println(" total count: " + StringUtils.padStart(Integer.toString(total), 8, ' '));
        out.println("native count: " + StringUtils.padStart(Integer.toString(nativeCount), 8, ' '));
        out.println();
        out.println(FUNCTION_BY_NET_HEADER);
        out.println();
        Arrays.sort(methodArray, (a, b) -> b.getStackTopCount() - a.getStackTopCount());
        for (i = 0; i < methodArray.length; ++i) {
            Profiler.dumpFunction(methodArray[i], out);
        }
        out.println();
        out.println(FUNCTION_BY_COUNT_HEADER);
        out.println();
        Arrays.sort(methodArray, (a, b) -> b.getCount() - a.getCount());
        for (i = 0; i < methodArray.length; ++i) {
            Profiler.dumpFunction(methodArray[i], out);
        }
        out.println();
        out.println("traces by count:");
        out.println();
        if (globalCounts != null) {
            Arrays.sort(traceArray, (a, b) -> (Integer)globalCounts.get(b) - (Integer)globalCounts.get(a));
        } else {
            Arrays.sort(traceArray, (a, b) -> b.getThreadCount() - a.getThreadCount());
        }
        for (i = 0; i < traceArray.length; ++i) {
            Trace t = traceArray[i];
            int count = globalCounts != null ? globalCounts.get(t).intValue() : t.getThreadCount();
            if (count < minimumStackWitnessCount) break;
            out.println(count + " time(s):");
            if (CommonStacktraces.IDLE_THREAD_TRACE_PRIORITY_SCHEDULE1.equals(t)) {
                out.println("\tPriorityScheduler idle thread (stack 1)\n");
                continue;
            }
            if (CommonStacktraces.IDLE_THREAD_TRACE_PRIORITY_SCHEDULE2.equals(t)) {
                out.println("\tPriorityScheduler idle thread (stack 2)\n");
                continue;
            }
            if (CommonStacktraces.IDLE_THREAD_TRACE_EXCEPTION_HANDLER_PRIORITY_SCHEDULE1.equals(t)) {
                out.println("\tPriorityScheduler with ExceptionHandler idle thread (stack 1)\n");
                continue;
            }
            if (CommonStacktraces.IDLE_THREAD_TRACE_EXCEPTION_HANDLER_PRIORITY_SCHEDULE2.equals(t)) {
                out.println("\tPriorityScheduler with ExceptionHandler idle thread (stack 2)\n");
                continue;
            }
            if (CommonStacktraces.IDLE_THREAD_TRACE_SINGLE_THREAD_SCHEDULER1.equals(t)) {
                out.println("\tSingleThreadScheduler idle thread (stack 1)\n");
                continue;
            }
            if (CommonStacktraces.IDLE_THREAD_TRACE_SINGLE_THREAD_SCHEDULER2.equals(t)) {
                out.println("\tSingleThreadScheduler idle thread (stack 2)\n");
                continue;
            }
            if (CommonStacktraces.IDLE_THREAD_TRACE_EXCEPTION_HANDLER_SINGLE_THREAD_SCHEDULER1.equals(t)) {
                out.println("\tSingleThreadScheduler with ExceptionHandler idle thread (stack 1)\n");
                continue;
            }
            if (CommonStacktraces.IDLE_THREAD_TRACE_EXCEPTION_HANDLER_SINGLE_THREAD_SCHEDULER2.equals(t)) {
                out.println("\tSingleThreadScheduler with ExceptionHandler idle thread (stack 2)\n");
                continue;
            }
            if (CommonStacktraces.IDLE_THREAD_TRACE_THREAD_POOL_EXECUTOR_SYNCHRONOUS_QUEUE.equals(t)) {
                out.println("\tThreadPoolExecutor SynchronousQueue idle thread\n");
                continue;
            }
            if (CommonStacktraces.IDLE_THREAD_TRACE_THREAD_POOL_EXECUTOR_ARRAY_QUEUE.equals(t)) {
                out.println("\tThreadPoolExecutor ArrayBlockingQueue idle thread\n");
                continue;
            }
            if (CommonStacktraces.IDLE_THREAD_TRACE_THREAD_POOL_EXECUTOR_LINKED_QUEUE.equals(t)) {
                out.println("\tThreadPoolExecutor LinkedBlockingQueue idle thread\n");
                continue;
            }
            if (CommonStacktraces.IDLE_THREAD_TRACE_SCHEDULED_THREAD_POOL_EXECUTOR1.equals(t)) {
                out.println("\tScheduledThreadPoolExecutor idle thread (stack 1)\n");
                continue;
            }
            if (CommonStacktraces.IDLE_THREAD_TRACE_SCHEDULED_THREAD_POOL_EXECUTOR2.equals(t)) {
                out.println("\tScheduledThreadPoolExecutor idle thread (stack 2)\n");
                continue;
            }
            if (CommonStacktraces.IDLE_THREAD_TRACE_FORK_JOIN_POOL.equals(t)) {
                out.println("\tForkJoinPool idle thread\n");
                continue;
            }
            out.println(ExceptionUtils.stackToString(t.elements));
        }
    }

    private static void dumpFunction(WitnessedFunction f, PrintStream out) {
        out.print(StringUtils.padStart(Integer.toString(f.getCount()), 8, ' '));
        out.print(StringUtils.padStart(Integer.toString(f.getStackTopCount()), 8, ' '));
        out.print(' ');
        out.print(f.className);
        out.print('.');
        out.println(f.function);
    }

    protected void finalize() {
        this.stop();
    }

    static {
        String prefix = "functions by ";
        String columns = "(total, top, name)";
        FUNCTION_BY_NET_HEADER = prefix + "top count: " + columns;
        FUNCTION_BY_COUNT_HEADER = prefix + "total count: " + columns;
        HashSet<String> blacklistThreadNames = new HashSet<String>(4);
        blacklistThreadNames.add("Threadly clock updater");
        blacklistThreadNames.add("Reference Handler");
        blacklistThreadNames.add("Finalizer");
        BLACKLIST_THREAD_NAMES = Collections.unmodifiableSet(blacklistThreadNames);
        CommonStacktraces.init();
    }

    protected static final class WitnessedFunction {
        protected final String className;
        protected final String function;
        protected final int hashCode;
        private int count;
        private int childCount;

        public WitnessedFunction(String className, String funtion) {
            this.className = className;
            this.function = funtion;
            this.hashCode = className.hashCode() ^ this.function.hashCode();
        }

        protected void incrementCount(int count, boolean child) {
            this.count += count;
            if (child) {
                this.childCount += count;
            }
        }

        protected int getCount() {
            return this.count;
        }

        protected int getStackTopCount() {
            return this.count - this.childCount;
        }

        public int hashCode() {
            return this.hashCode;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            try {
                WitnessedFunction m = (WitnessedFunction)o;
                return m.hashCode == this.hashCode && m.className.equals(this.className) && m.function.equals(this.function);
            }
            catch (ClassCastException e) {
                return false;
            }
        }
    }

    protected static final class Trace
    extends ComparableTrace {
        private volatile int threadSeenCount = 1;

        public Trace(StackTraceElement[] elements) {
            super(elements);
        }

        protected void incrementThreadCount() {
            ++this.threadSeenCount;
        }

        protected int getThreadCount() {
            return this.threadSeenCount;
        }
    }

    protected static final class ThreadIdentifier {
        private final long threadId;
        private final int hashCode;

        public ThreadIdentifier(Thread t) {
            this.threadId = t.getId();
            this.hashCode = t.hashCode();
        }

        public String toString() {
            return "ThreadId:" + this.threadId;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            try {
                ThreadIdentifier t = (ThreadIdentifier)o;
                return t.threadId == this.threadId && t.hashCode == this.hashCode;
            }
            catch (ClassCastException e) {
                return false;
            }
        }

        public int hashCode() {
            return this.hashCode;
        }
    }

    protected static final class ThreadSamples {
        private final Map<Trace, Trace> traces = new ConcurrentHashMap<Trace, Trace>(16);
        private final Set<String> threadNames = ConcurrentHashMap.newKeySet(1);
        private volatile String cachedThreadNames = null;

        protected ThreadSamples() {
        }

        public void recordSample(Trace trace, String threadName) {
            Trace existingTrace;
            if (this.threadNames.add(threadName)) {
                this.cachedThreadNames = null;
            }
            if ((existingTrace = this.traces.get(trace)) == null) {
                if (CommonStacktraces.IDLE_THREAD_TRACE_PRIORITY_SCHEDULE1.equals(trace)) {
                    trace = new Trace(CommonStacktraces.IDLE_THREAD_TRACE_PRIORITY_SCHEDULE1.elements);
                } else if (CommonStacktraces.IDLE_THREAD_TRACE_PRIORITY_SCHEDULE2.equals(trace)) {
                    trace = new Trace(CommonStacktraces.IDLE_THREAD_TRACE_PRIORITY_SCHEDULE2.elements);
                } else if (CommonStacktraces.IDLE_THREAD_TRACE_EXCEPTION_HANDLER_PRIORITY_SCHEDULE1.equals(trace)) {
                    trace = new Trace(CommonStacktraces.IDLE_THREAD_TRACE_EXCEPTION_HANDLER_PRIORITY_SCHEDULE1.elements);
                } else if (CommonStacktraces.IDLE_THREAD_TRACE_EXCEPTION_HANDLER_PRIORITY_SCHEDULE2.equals(trace)) {
                    trace = new Trace(CommonStacktraces.IDLE_THREAD_TRACE_EXCEPTION_HANDLER_PRIORITY_SCHEDULE2.elements);
                } else if (CommonStacktraces.IDLE_THREAD_TRACE_SINGLE_THREAD_SCHEDULER1.equals(trace)) {
                    trace = new Trace(CommonStacktraces.IDLE_THREAD_TRACE_SINGLE_THREAD_SCHEDULER1.elements);
                } else if (CommonStacktraces.IDLE_THREAD_TRACE_SINGLE_THREAD_SCHEDULER2.equals(trace)) {
                    trace = new Trace(CommonStacktraces.IDLE_THREAD_TRACE_SINGLE_THREAD_SCHEDULER2.elements);
                } else if (CommonStacktraces.IDLE_THREAD_TRACE_EXCEPTION_HANDLER_SINGLE_THREAD_SCHEDULER1.equals(trace)) {
                    trace = new Trace(CommonStacktraces.IDLE_THREAD_TRACE_EXCEPTION_HANDLER_SINGLE_THREAD_SCHEDULER1.elements);
                } else if (CommonStacktraces.IDLE_THREAD_TRACE_EXCEPTION_HANDLER_SINGLE_THREAD_SCHEDULER2.equals(trace)) {
                    trace = new Trace(CommonStacktraces.IDLE_THREAD_TRACE_EXCEPTION_HANDLER_SINGLE_THREAD_SCHEDULER2.elements);
                } else if (CommonStacktraces.IDLE_THREAD_TRACE_THREAD_POOL_EXECUTOR_SYNCHRONOUS_QUEUE.equals(trace)) {
                    trace = new Trace(CommonStacktraces.IDLE_THREAD_TRACE_THREAD_POOL_EXECUTOR_SYNCHRONOUS_QUEUE.elements);
                } else if (CommonStacktraces.IDLE_THREAD_TRACE_THREAD_POOL_EXECUTOR_ARRAY_QUEUE.equals(trace)) {
                    trace = new Trace(CommonStacktraces.IDLE_THREAD_TRACE_THREAD_POOL_EXECUTOR_ARRAY_QUEUE.elements);
                } else if (CommonStacktraces.IDLE_THREAD_TRACE_THREAD_POOL_EXECUTOR_LINKED_QUEUE.equals(trace)) {
                    trace = new Trace(CommonStacktraces.IDLE_THREAD_TRACE_THREAD_POOL_EXECUTOR_LINKED_QUEUE.elements);
                } else if (CommonStacktraces.IDLE_THREAD_TRACE_SCHEDULED_THREAD_POOL_EXECUTOR1.equals(trace)) {
                    trace = new Trace(CommonStacktraces.IDLE_THREAD_TRACE_SCHEDULED_THREAD_POOL_EXECUTOR1.elements);
                } else if (CommonStacktraces.IDLE_THREAD_TRACE_SCHEDULED_THREAD_POOL_EXECUTOR2.equals(trace)) {
                    trace = new Trace(CommonStacktraces.IDLE_THREAD_TRACE_SCHEDULED_THREAD_POOL_EXECUTOR2.elements);
                } else if (CommonStacktraces.IDLE_THREAD_TRACE_FORK_JOIN_POOL.equals(trace)) {
                    trace = new Trace(CommonStacktraces.IDLE_THREAD_TRACE_FORK_JOIN_POOL.elements);
                }
                this.traces.put(trace, trace);
            } else {
                existingTrace.incrementThreadCount();
            }
        }

        public String threadNames() {
            String cachedThreadNames = this.cachedThreadNames;
            if (cachedThreadNames != null) {
                return cachedThreadNames;
            }
            if (this.threadNames.size() == 1) {
                this.cachedThreadNames = this.threadNames.iterator().next();
                return this.cachedThreadNames;
            }
            if (this.threadNames.isEmpty()) {
                throw new IllegalStateException("No samples recorded for thread");
            }
            ArrayList<String> nameCopy = new ArrayList<String>(this.threadNames);
            Collections.sort(nameCopy);
            this.cachedThreadNames = ((Object)nameCopy).toString();
            return this.cachedThreadNames;
        }

        public Set<Trace> traceSet() {
            return this.traces.keySet();
        }
    }

    protected static final class ProfilerRunner
    implements Runnable {
        private final ProfileStorage pStore;

        protected ProfilerRunner(ProfileStorage pStore) {
            this.pStore = pStore;
        }

        @Override
        public void run() {
            Thread runningThread = Thread.currentThread();
            while (this.pStore.collectorThread.get() == runningThread) {
                boolean storedSample = false;
                Iterator<? extends ThreadSample> it = this.pStore.getProfileThreadsIterator();
                while (it.hasNext()) {
                    StackTraceElement[] threadStack;
                    ThreadSample threadSample = it.next();
                    if (!(threadSample.getThread() != runningThread & threadSample.getThread() != this.pStore.dumpingThread) || (threadStack = threadSample.getStackTrace()).length <= 0) continue;
                    storedSample = true;
                    this.pStore.threadTraces.computeIfAbsent(new ThreadIdentifier(threadSample.getThread()), k -> new ThreadSamples()).recordSample(new Trace(threadStack), threadSample.getThread().getName());
                }
                if (storedSample) {
                    this.pStore.collectedSamples.increment();
                }
                try {
                    Thread.sleep(this.pStore.pollIntervalInMs);
                }
                catch (InterruptedException e) {
                    this.pStore.collectorThread.compareAndSet(runningThread, null);
                    Thread.currentThread().interrupt();
                    return;
                }
                Runnable toRun = this.pStore.dumpLoopRun;
                if (toRun == null) continue;
                try {
                    toRun.run();
                }
                catch (Throwable t) {
                    ExceptionUtils.handleException(t);
                }
            }
        }
    }

    protected static final class ExecutorRunnerTask
    implements Runnable {
        private final ProfileStorage pStore;
        private final SettableListenableFuture<?> runningThreadFuture;
        private final ProfilerRunner pr;

        public ExecutorRunnerTask(ProfileStorage pStore, SettableListenableFuture<?> runningThreadFuture, ProfilerRunner pr) {
            this.pStore = pStore;
            this.runningThreadFuture = runningThreadFuture;
            this.pr = pr;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Thread currentThread = Thread.currentThread();
            try {
                if (!this.pStore.collectorThread.compareAndSet(null, currentThread)) {
                    return;
                }
            }
            finally {
                this.runningThreadFuture.setResult(null);
            }
            String originalName = currentThread.getName();
            int origPriority = currentThread.getPriority();
            try {
                if (origPriority < 10) {
                    currentThread.setPriority(10);
                }
                currentThread.setName("Threadly Profiler data collector[" + originalName + "]");
                this.pr.run();
            }
            finally {
                if (origPriority < 10) {
                    currentThread.setPriority(origPriority);
                }
                currentThread.setName(originalName);
            }
        }
    }

    protected static class ProfileStorage {
        protected final AtomicReference<Thread> collectorThread;
        protected final Map<ThreadIdentifier, ThreadSamples> threadTraces;
        protected final LongAdder collectedSamples;
        protected volatile int pollIntervalInMs;
        protected volatile Thread dumpingThread;
        protected volatile Runnable dumpLoopRun;

        public ProfileStorage(int pollIntervalInMs) {
            ArgumentVerifier.assertNotNegative(pollIntervalInMs, "pollIntervalInMs");
            this.collectorThread = new AtomicReference<Object>(null);
            this.threadTraces = new ConcurrentHashMap<ThreadIdentifier, ThreadSamples>(16);
            this.collectedSamples = new LongAdder();
            this.pollIntervalInMs = pollIntervalInMs;
            this.dumpingThread = null;
            this.dumpLoopRun = null;
        }

        protected Iterator<? extends ThreadSample> getProfileThreadsIterator() {
            return new ThreadIterator();
        }
    }

    protected static class ThreadIterator
    implements Iterator<ThreadSample> {
        protected final Iterator<Map.Entry<Thread, StackTraceElement[]>> it = Thread.getAllStackTraces().entrySet().iterator();
        private Map.Entry<Thread, StackTraceElement[]> next = this.it.next();

        protected ThreadIterator() {
        }

        @Override
        public boolean hasNext() {
            return this.next != null;
        }

        @Override
        public ThreadSample next() {
            if (this.next == null) {
                throw new NoSuchElementException();
            }
            Map.Entry<Thread, StackTraceElement[]> entry = this.next;
            if (this.it.hasNext()) {
                this.next = this.it.next();
                while (BLACKLIST_THREAD_NAMES.contains(this.next.getKey().getName())) {
                    if (this.it.hasNext()) {
                        this.next = this.it.next();
                        continue;
                    }
                    this.next = null;
                    break;
                }
            } else {
                this.next = null;
            }
            return new CachedThreadSample(entry.getKey(), entry.getValue());
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    protected static class CachedThreadSample
    implements ThreadSample {
        private final Thread thread;
        private final StackTraceElement[] cachedStackTrace;

        protected CachedThreadSample(Thread thread, StackTraceElement[] cachedStackTrace) {
            this.thread = thread;
            this.cachedStackTrace = cachedStackTrace;
        }

        @Override
        public Thread getThread() {
            return this.thread;
        }

        @Override
        public StackTraceElement[] getStackTrace() {
            return this.cachedStackTrace;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o instanceof ThreadSample) {
                return ((ThreadSample)o).getThread() == this.thread;
            }
            return false;
        }

        public int hashCode() {
            return this.thread.hashCode();
        }
    }

    protected static interface ThreadSample {
        public Thread getThread();

        public StackTraceElement[] getStackTrace();
    }
}

