/*
 * Decompiled with CFR 0.152.
 */
package org.threadly.util.debug;

import java.util.Arrays;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ForkJoinTask;
import java.util.concurrent.ForkJoinWorkerThread;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.threadly.concurrent.ConfigurableThreadFactory;
import org.threadly.concurrent.DoNothingRunnable;
import org.threadly.concurrent.PriorityScheduler;
import org.threadly.concurrent.SingleThreadScheduler;
import org.threadly.util.ExceptionHandler;
import org.threadly.util.ExceptionUtils;
import org.threadly.util.debug.ComparableTrace;

class CommonStacktraces {
    protected static final ComparableTrace IDLE_THREAD_TRACE_PRIORITY_SCHEDULE1;
    protected static final ComparableTrace IDLE_THREAD_TRACE_PRIORITY_SCHEDULE2;
    protected static final ComparableTrace IDLE_THREAD_TRACE_EXCEPTION_HANDLER_PRIORITY_SCHEDULE1;
    protected static final ComparableTrace IDLE_THREAD_TRACE_EXCEPTION_HANDLER_PRIORITY_SCHEDULE2;
    protected static final ComparableTrace IDLE_THREAD_TRACE_SINGLE_THREAD_SCHEDULER1;
    protected static final ComparableTrace IDLE_THREAD_TRACE_SINGLE_THREAD_SCHEDULER2;
    protected static final ComparableTrace IDLE_THREAD_TRACE_EXCEPTION_HANDLER_SINGLE_THREAD_SCHEDULER1;
    protected static final ComparableTrace IDLE_THREAD_TRACE_EXCEPTION_HANDLER_SINGLE_THREAD_SCHEDULER2;
    protected static final ComparableTrace IDLE_THREAD_TRACE_THREAD_POOL_EXECUTOR_SYNCHRONOUS_QUEUE;
    protected static final ComparableTrace IDLE_THREAD_TRACE_THREAD_POOL_EXECUTOR_ARRAY_QUEUE;
    protected static final ComparableTrace IDLE_THREAD_TRACE_THREAD_POOL_EXECUTOR_LINKED_QUEUE;
    protected static final ComparableTrace IDLE_THREAD_TRACE_SCHEDULED_THREAD_POOL_EXECUTOR1;
    protected static final ComparableTrace IDLE_THREAD_TRACE_SCHEDULED_THREAD_POOL_EXECUTOR2;
    protected static final ComparableTrace IDLE_THREAD_TRACE_FORK_JOIN_POOL;

    CommonStacktraces() {
    }

    private static Thread getParkedThread(AtomicReference<Thread> threadReference, Thread not) {
        StackTraceElement[] stackTrace;
        Thread thread;
        while ((thread = threadReference.get()) == not || !thread.isAlive() || !CommonStacktraces.isParkedStack(stackTrace = thread.getStackTrace())) {
            Thread.yield();
        }
        return thread;
    }

    private static void waitForParkedStack(Thread t) {
        while (!CommonStacktraces.isParkedStack(t.getStackTrace())) {
            Thread.yield();
        }
    }

    private static boolean isParkedStack(StackTraceElement[] stackTrace) {
        return stackTrace.length > 1 && stackTrace[0].getMethodName().equals("park");
    }

    public static void init() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        AtomicReference<Thread> psSchedulerThread = new AtomicReference<Thread>();
        AtomicReference<Thread> stsSchedulerThread = new AtomicReference<Thread>();
        AtomicReference<Thread> threadPoolExecutorSynchronousQueueThread = new AtomicReference<Thread>();
        AtomicReference<Thread> threadPoolExecutorArrayBlockingQueueThread = new AtomicReference<Thread>();
        AtomicReference<Thread> threadPoolExecutorLinkedBlockingQueueThread = new AtomicReference<Thread>();
        AtomicReference<Thread> scheduledThreadPoolExecutorThread = new AtomicReference<Thread>();
        AtomicReference<Thread> forkJoinPoolThread = new AtomicReference<Thread>();
        PriorityScheduler ps = new PriorityScheduler(1, null, 100L, r -> {
            Thread t = new Thread(r);
            t.setDaemon(true);
            psSchedulerThread.set(t);
            return t;
        });
        SingleThreadScheduler sts = new SingleThreadScheduler(r -> {
            Thread t = new Thread(r);
            t.setDaemon(true);
            stsSchedulerThread.set(t);
            return t;
        });
        ThreadPoolExecutor tpeSQ = new ThreadPoolExecutor(1, 1, 100L, TimeUnit.MILLISECONDS, new SynchronousQueue<Runnable>(), r -> {
            Thread t = new Thread(r);
            t.setDaemon(true);
            threadPoolExecutorSynchronousQueueThread.set(t);
            return t;
        });
        ThreadPoolExecutor tpeAQ = new ThreadPoolExecutor(1, 1, 100L, TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(1), r -> {
            Thread t = new Thread(r);
            t.setDaemon(true);
            threadPoolExecutorArrayBlockingQueueThread.set(t);
            return t;
        });
        ThreadPoolExecutor tpeLQ = new ThreadPoolExecutor(1, 1, 100L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), r -> {
            Thread t = new Thread(r);
            t.setDaemon(true);
            threadPoolExecutorLinkedBlockingQueueThread.set(t);
            return t;
        });
        ScheduledThreadPoolExecutor stpe = new ScheduledThreadPoolExecutor(1, r -> {
            Thread t = new Thread(r);
            t.setDaemon(true);
            scheduledThreadPoolExecutorThread.set(t);
            return t;
        });
        ForkJoinPool fjp = new ForkJoinPool(1, pool -> {
            ForkJoinWorkerThread t = new ForkJoinWorkerThread(pool){};
            t.setDaemon(true);
            forkJoinPoolThread.set(t);
            return t;
        }, null, true);
        try {
            sts.prestartExecutionThread(false);
            ps.prestartAllThreads();
            Thread psFirstThread = CommonStacktraces.getParkedThread(psSchedulerThread, null);
            ps.setPoolSize(2);
            ps.prestartAllThreads();
            Thread psSecondThread = CommonStacktraces.getParkedThread(psSchedulerThread, psFirstThread);
            Thread stsThread = CommonStacktraces.getParkedThread(stsSchedulerThread, null);
            IDLE_THREAD_TRACE_PRIORITY_SCHEDULE1 = new ComparableTrace(psFirstThread.getStackTrace());
            IDLE_THREAD_TRACE_PRIORITY_SCHEDULE2 = new ComparableTrace(psSecondThread.getStackTrace());
            IDLE_THREAD_TRACE_SINGLE_THREAD_SCHEDULER1 = new ComparableTrace(stsThread.getStackTrace());
            sts.schedule(DoNothingRunnable.instance(), TimeUnit.HOURS.toMillis(1L));
            sts.submit(DoNothingRunnable.instance()).get();
            tpeSQ.prestartCoreThread();
            tpeAQ.prestartCoreThread();
            tpeLQ.prestartCoreThread();
            stpe.prestartCoreThread();
            fjp.invoke(ForkJoinTask.adapt(DoNothingRunnable.instance()));
            Thread sqThread = CommonStacktraces.getParkedThread(threadPoolExecutorSynchronousQueueThread, null);
            Thread aqThread = CommonStacktraces.getParkedThread(threadPoolExecutorArrayBlockingQueueThread, null);
            Thread lqThread = CommonStacktraces.getParkedThread(threadPoolExecutorLinkedBlockingQueueThread, null);
            Thread stpeThread = CommonStacktraces.getParkedThread(scheduledThreadPoolExecutorThread, null);
            Thread fjpThread = CommonStacktraces.getParkedThread(forkJoinPoolThread, null);
            IDLE_THREAD_TRACE_THREAD_POOL_EXECUTOR_SYNCHRONOUS_QUEUE = new ComparableTrace(sqThread.getStackTrace());
            IDLE_THREAD_TRACE_THREAD_POOL_EXECUTOR_ARRAY_QUEUE = new ComparableTrace(aqThread.getStackTrace());
            IDLE_THREAD_TRACE_THREAD_POOL_EXECUTOR_LINKED_QUEUE = new ComparableTrace(lqThread.getStackTrace());
            IDLE_THREAD_TRACE_SCHEDULED_THREAD_POOL_EXECUTOR1 = new ComparableTrace(stpeThread.getStackTrace());
            IDLE_THREAD_TRACE_FORK_JOIN_POOL = new ComparableTrace(fjpThread.getStackTrace());
            stpe.schedule(DoNothingRunnable.instance(), 1L, TimeUnit.HOURS);
            stpe.submit(DoNothingRunnable.instance()).get();
            CommonStacktraces.waitForParkedStack(stsThread);
            CommonStacktraces.waitForParkedStack(stpeThread);
            IDLE_THREAD_TRACE_SINGLE_THREAD_SCHEDULER2 = new ComparableTrace(stsThread.getStackTrace());
            IDLE_THREAD_TRACE_SCHEDULED_THREAD_POOL_EXECUTOR2 = new ComparableTrace(stpeThread.getStackTrace());
            final AtomicReference insertElement = new AtomicReference();
            Thread t = new ConfigurableThreadFactory(ExceptionHandler.PRINT_STACKTRACE_HANDLER).newThread(new Runnable(){

                @Override
                public void run() {
                    StackTraceElement[] stack = Thread.currentThread().getStackTrace();
                    insertElement.set(stack[stack.length - 2]);
                }
            });
            t.start();
            t.join();
            StackTraceElement[] stackTrace = Arrays.copyOf(CommonStacktraces.IDLE_THREAD_TRACE_PRIORITY_SCHEDULE1.elements, CommonStacktraces.IDLE_THREAD_TRACE_PRIORITY_SCHEDULE1.elements.length + 1);
            stackTrace[stackTrace.length - 1] = stackTrace[stackTrace.length - 2];
            stackTrace[stackTrace.length - 2] = (StackTraceElement)insertElement.get();
            IDLE_THREAD_TRACE_EXCEPTION_HANDLER_PRIORITY_SCHEDULE1 = new ComparableTrace(stackTrace);
            stackTrace = Arrays.copyOf(CommonStacktraces.IDLE_THREAD_TRACE_PRIORITY_SCHEDULE2.elements, CommonStacktraces.IDLE_THREAD_TRACE_PRIORITY_SCHEDULE2.elements.length + 1);
            stackTrace[stackTrace.length - 1] = stackTrace[stackTrace.length - 2];
            stackTrace[stackTrace.length - 2] = (StackTraceElement)insertElement.get();
            IDLE_THREAD_TRACE_EXCEPTION_HANDLER_PRIORITY_SCHEDULE2 = new ComparableTrace(stackTrace);
            stackTrace = Arrays.copyOf(CommonStacktraces.IDLE_THREAD_TRACE_SINGLE_THREAD_SCHEDULER1.elements, CommonStacktraces.IDLE_THREAD_TRACE_SINGLE_THREAD_SCHEDULER1.elements.length + 1);
            stackTrace[stackTrace.length - 1] = stackTrace[stackTrace.length - 2];
            stackTrace[stackTrace.length - 2] = (StackTraceElement)insertElement.get();
            IDLE_THREAD_TRACE_EXCEPTION_HANDLER_SINGLE_THREAD_SCHEDULER1 = new ComparableTrace(stackTrace);
            stackTrace = Arrays.copyOf(CommonStacktraces.IDLE_THREAD_TRACE_SINGLE_THREAD_SCHEDULER2.elements, CommonStacktraces.IDLE_THREAD_TRACE_SINGLE_THREAD_SCHEDULER2.elements.length + 1);
            stackTrace[stackTrace.length - 1] = stackTrace[stackTrace.length - 2];
            stackTrace[stackTrace.length - 2] = (StackTraceElement)insertElement.get();
            IDLE_THREAD_TRACE_EXCEPTION_HANDLER_SINGLE_THREAD_SCHEDULER2 = new ComparableTrace(stackTrace);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException(e);
        }
        catch (ExecutionException e) {
            throw ExceptionUtils.makeRuntime(e.getCause());
        }
        finally {
            try {
                ps.shutdownNow();
            }
            finally {
                try {
                    sts.shutdownNow();
                }
                finally {
                    try {
                        tpeSQ.shutdownNow();
                    }
                    finally {
                        try {
                            tpeAQ.shutdownNow();
                        }
                        finally {
                            try {
                                tpeLQ.shutdownNow();
                            }
                            finally {
                                try {
                                    stpe.shutdownNow();
                                }
                                finally {
                                    fjp.shutdownNow();
                                }
                            }
                        }
                    }
                }
            }
        }
    }
}

