/*
 * Decompiled with CFR 0.152.
 */
package org.threadly.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;

public class StatisticsUtils {
    public static double getAverage(Collection<? extends Number> list) {
        if (list.isEmpty()) {
            return 0.0;
        }
        double totalTime = 0.0;
        Iterator<? extends Number> it = list.iterator();
        while (it.hasNext()) {
            totalTime += it.next().doubleValue();
        }
        return totalTime / (double)list.size();
    }

    public static <T extends Number> T getMax(Collection<T> list) {
        if (list == null || list.isEmpty()) {
            throw new IllegalArgumentException("Empty list");
        }
        Iterator<T> it = list.iterator();
        Number result = (Number)it.next();
        while (it.hasNext()) {
            Number next = (Number)it.next();
            if (((Comparable)((Object)result)).compareTo(next) >= 0) continue;
            result = next;
        }
        return (T)result;
    }

    public static <T extends Number> T getMin(Collection<T> list) {
        if (list == null || list.isEmpty()) {
            throw new IllegalArgumentException("Empty list");
        }
        Iterator<T> it = list.iterator();
        Number result = (Number)it.next();
        while (it.hasNext()) {
            Number next = (Number)it.next();
            if (((Comparable)((Object)result)).compareTo(next) <= 0) continue;
            result = next;
        }
        return (T)result;
    }

    public static <T extends Number> Map<Double, T> getPercentiles(Collection<? extends T> values, double ... percentiles) {
        if (percentiles.length == 0) {
            throw new IllegalArgumentException("No percentiles requested");
        }
        if (values.isEmpty()) {
            throw new IllegalArgumentException("No values provided to calculate against");
        }
        ArrayList<T> valuesCopy = new ArrayList<T>(values);
        Collections.sort(valuesCopy, new Comparator<Number>(){

            @Override
            public int compare(Number o1, Number o2) {
                double result = o1.doubleValue() - o2.doubleValue();
                if (result > 0.0) {
                    return 1;
                }
                if (result < 0.0) {
                    return -1;
                }
                return 0;
            }
        });
        LinkedHashMap<Double, Number> result = new LinkedHashMap<Double, Number>();
        for (double p : percentiles) {
            if (p > 100.0 || p < 0.0) {
                throw new IllegalArgumentException("Percentile not in range of 0 to 100: " + p);
            }
            int index = p == 100.0 ? valuesCopy.size() - 1 : (int)(p / 100.0 * (double)valuesCopy.size());
            result.put(p, (Number)valuesCopy.get(index));
        }
        return result;
    }
}

