/*
 * Decompiled with CFR 0.152.
 */
package org.threadly.util;

import java.util.List;
import java.util.function.Function;

public class SortUtils {
    protected static final short MAX_STEPS_TILL_B_SEARCH_SWITCH = 5;

    public static int getInsertionEndIndex(List<Long> values, long insertionValue, boolean randomAccessList) {
        return SortUtils.getInsertionEndIndex(values::get, values.size() - 1, insertionValue, randomAccessList);
    }

    public static int getInsertionEndIndex(Function<Integer, Long> valueProvider, int absoluteMax, long insertionValue, boolean randomAccessList) {
        int searchResult = SortUtils.binarySearch(valueProvider, absoluteMax, insertionValue, randomAccessList);
        if (searchResult >= 0) {
            while (searchResult <= absoluteMax && valueProvider.apply(searchResult) == insertionValue) {
                ++searchResult;
            }
            return searchResult;
        }
        return Math.abs(searchResult) - 1;
    }

    public static int binarySearch(List<Long> values, long insertionValue, boolean randomAccessList) {
        return SortUtils.binarySearch(values::get, values.size() - 1, insertionValue, randomAccessList);
    }

    public static int binarySearch(Function<Integer, Long> valueProvider, int absoluteMax, long insertionValue, boolean randomAccessList) {
        int pivot;
        if (absoluteMax < 0) {
            return -1;
        }
        int min = 0;
        int max = absoluteMax;
        long minVal = valueProvider.apply(min);
        long maxVal = valueProvider.apply(max);
        int nPreviousSteps = 1;
        while (true) {
            if (insertionValue <= minVal) {
                return insertionValue == minVal ? min : -1 - min;
            }
            if (insertionValue >= maxVal) {
                return insertionValue == maxVal ? max : -2 - max;
            }
            if (nPreviousSteps > 5) {
                pivot = min + max >> 1;
            } else {
                pivot = min + (int)(((float)insertionValue - (float)minVal) / ((float)maxVal - (float)minVal) * (float)(max - min));
                nPreviousSteps = (short)(nPreviousSteps + 1);
            }
            long pivotVal = valueProvider.apply(pivot);
            if (insertionValue > pivotVal) {
                min = pivot + 1;
                if (min > absoluteMax) {
                    return absoluteMax + 1;
                }
                minVal = valueProvider.apply(min);
                if (!randomAccessList) continue;
                maxVal = valueProvider.apply(--max);
                continue;
            }
            if (insertionValue >= pivotVal) break;
            max = pivot - 1;
            if (max < 0) {
                return 0;
            }
            maxVal = valueProvider.apply(max);
            if (!randomAccessList) continue;
            minVal = valueProvider.apply(++min);
        }
        return pivot;
    }
}

