/*
 * Decompiled with CFR 0.152.
 */
package org.threadly.util;

import java.util.concurrent.locks.LockSupport;

public class Clock {
    public static final int NANOS_IN_MILLISECOND = 1000000;
    public static final short AUTOMATIC_UPDATE_FREQUENCY_IN_MS = 100;
    protected static final short STOP_PARK_TIME_NANOS = 25000;
    protected static final Object UPDATE_LOCK = new Object();
    protected static ClockUpdater clockUpdater = null;
    protected static final long CLOCK_STARTUP_TIME_NANOS;
    private static volatile long nowNanos;
    private static volatile long nowMillis;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void startClockUpdateThread() {
        Object object = UPDATE_LOCK;
        synchronized (object) {
            if (clockUpdater != null) {
                return;
            }
            clockUpdater = new ClockUpdater();
            Thread thread = new Thread(clockUpdater);
            thread.setName("Threadly clock updater");
            thread.setDaemon(true);
            thread.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void stopClockUpdateThread() {
        ClockUpdater oldUpdater;
        Object object = UPDATE_LOCK;
        synchronized (object) {
            oldUpdater = clockUpdater;
            clockUpdater = null;
            UPDATE_LOCK.notifyAll();
        }
        if (oldUpdater != null) {
            Thread currentThread = Thread.currentThread();
            while (!oldUpdater.runnableFinished && !currentThread.isInterrupted()) {
                LockSupport.parkNanos(25000L);
            }
        }
    }

    public static long accurateTimeNanos() {
        nowNanos = System.nanoTime();
        return nowNanos;
    }

    public static long lastKnownTimeNanos() {
        return nowNanos;
    }

    public static long lastKnownForwardProgressingMillis() {
        return (nowNanos - CLOCK_STARTUP_TIME_NANOS) / 1000000L;
    }

    public static long accurateForwardProgressingMillis() {
        nowNanos = System.nanoTime();
        return (nowNanos - CLOCK_STARTUP_TIME_NANOS) / 1000000L;
    }

    public static long forwardProgressingDuration(long forwardMillis) {
        return Math.max(0L, Clock.lastKnownForwardProgressingMillis() - forwardMillis);
    }

    public static long lastKnownTimeMillis() {
        return nowMillis;
    }

    public static long accurateTimeMillis() {
        nowMillis = System.currentTimeMillis();
        return nowMillis;
    }

    static {
        nowNanos = CLOCK_STARTUP_TIME_NANOS = System.nanoTime();
        nowMillis = System.currentTimeMillis();
        Clock.startClockUpdateThread();
    }

    protected static class ClockUpdater
    implements Runnable {
        protected volatile boolean runnableFinished = false;
        protected long lastUpdatedMillis = -1L;
        protected long lastUpdatedNanos = -1L;

        protected ClockUpdater() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                Object object = UPDATE_LOCK;
                synchronized (object) {
                    while (clockUpdater == this) {
                        try {
                            if (nowMillis == this.lastUpdatedMillis || nowMillis - this.lastUpdatedMillis > 100L) {
                                nowMillis = this.lastUpdatedMillis = System.currentTimeMillis();
                            } else {
                                this.lastUpdatedMillis = nowMillis;
                            }
                            if (nowNanos == this.lastUpdatedNanos || nowNanos - this.lastUpdatedNanos > 100000000L) {
                                nowNanos = this.lastUpdatedNanos = System.nanoTime();
                            } else {
                                this.lastUpdatedNanos = nowNanos;
                            }
                            UPDATE_LOCK.wait(100L);
                        }
                        catch (InterruptedException e) {
                            clockUpdater = null;
                            Thread.currentThread().interrupt();
                        }
                    }
                }
            }
            finally {
                this.runnableFinished = true;
            }
        }
    }
}

