/*
 * Decompiled with CFR 0.152.
 */
package org.threadly.concurrent.wrapper.traceability;

import java.util.concurrent.Callable;
import org.threadly.concurrent.AbstractSubmitterScheduler;
import org.threadly.concurrent.PrioritySchedulerService;
import org.threadly.concurrent.RunnableCallableAdapter;
import org.threadly.concurrent.TaskPriority;
import org.threadly.concurrent.future.ListenableFuture;
import org.threadly.concurrent.future.ListenableFutureTask;
import org.threadly.concurrent.wrapper.traceability.ThreadRenamingRunnable;
import org.threadly.util.ArgumentVerifier;

public class ThreadRenamingPriorityScheduler
extends AbstractSubmitterScheduler
implements PrioritySchedulerService {
    protected final PrioritySchedulerService scheduler;
    protected final String threadName;
    protected final boolean replace;

    public ThreadRenamingPriorityScheduler(PrioritySchedulerService scheduler, String threadName, boolean replace) {
        this.scheduler = scheduler;
        this.threadName = threadName;
        this.replace = replace;
    }

    @Override
    public boolean remove(Runnable task) {
        return this.scheduler.remove(task);
    }

    @Override
    public boolean remove(Callable<?> task) {
        return this.scheduler.remove(task);
    }

    @Override
    public int getActiveTaskCount() {
        return this.scheduler.getActiveTaskCount();
    }

    @Override
    public int getQueuedTaskCount() {
        return this.scheduler.getQueuedTaskCount();
    }

    @Override
    public int getQueuedTaskCount(TaskPriority priority) {
        return this.scheduler.getQueuedTaskCount(priority);
    }

    @Override
    public int getWaitingForExecutionTaskCount() {
        return this.scheduler.getWaitingForExecutionTaskCount();
    }

    @Override
    public int getWaitingForExecutionTaskCount(TaskPriority priority) {
        return this.scheduler.getWaitingForExecutionTaskCount(priority);
    }

    @Override
    public boolean isShutdown() {
        return this.scheduler.isShutdown();
    }

    @Override
    public TaskPriority getDefaultPriority() {
        return this.scheduler.getDefaultPriority();
    }

    @Override
    public long getMaxWaitForLowPriority() {
        return this.scheduler.getMaxWaitForLowPriority();
    }

    @Override
    public void execute(Runnable task, TaskPriority priority) {
        this.schedule(task, 0L, priority);
    }

    @Override
    public <T> ListenableFuture<T> submit(Runnable task, T result, TaskPriority priority) {
        return this.submitScheduled(task, result, 0L, priority);
    }

    @Override
    public <T> ListenableFuture<T> submit(Callable<T> task, TaskPriority priority) {
        return this.submitScheduled(task, 0L, priority);
    }

    @Override
    public void schedule(Runnable task, long delayInMs, TaskPriority priority) {
        ArgumentVerifier.assertNotNull(task, "task");
        this.doSchedule(task, delayInMs, priority);
    }

    @Override
    public <T> ListenableFuture<T> submitScheduled(Runnable task, T result, long delayInMs, TaskPriority priority) {
        return this.submitScheduled(RunnableCallableAdapter.adapt(task, result), delayInMs, priority);
    }

    @Override
    public <T> ListenableFuture<T> submitScheduled(Callable<T> task, long delayInMs, TaskPriority priority) {
        ArgumentVerifier.assertNotNull(task, "task");
        ListenableFutureTask<T> rf = new ListenableFutureTask<T>(task, this);
        this.doSchedule(rf, delayInMs, priority);
        return rf;
    }

    @Override
    public void scheduleWithFixedDelay(Runnable task, long initialDelay, long recurringDelay) {
        this.scheduleWithFixedDelay(task, initialDelay, recurringDelay, null);
    }

    @Override
    public void scheduleWithFixedDelay(Runnable task, long initialDelay, long recurringDelay, TaskPriority priority) {
        this.scheduler.scheduleWithFixedDelay(new ThreadRenamingRunnable(task, this.threadName, this.replace), initialDelay, recurringDelay, priority);
    }

    @Override
    public void scheduleAtFixedRate(Runnable task, long initialDelay, long period) {
        this.scheduleAtFixedRate(task, initialDelay, period, null);
    }

    @Override
    public void scheduleAtFixedRate(Runnable task, long initialDelay, long period, TaskPriority priority) {
        this.scheduler.scheduleAtFixedRate(new ThreadRenamingRunnable(task, this.threadName, this.replace), initialDelay, period, priority);
    }

    @Override
    protected void doSchedule(Runnable task, long delayInMillis) {
        this.doSchedule(task, delayInMillis, null);
    }

    protected void doSchedule(Runnable task, long delayInMillis, TaskPriority priority) {
        this.scheduler.schedule(new ThreadRenamingRunnable(task, this.threadName, this.replace), delayInMillis, priority);
    }
}

