/*
 * Decompiled with CFR 0.152.
 */
package org.threadly.concurrent.wrapper.limiter;

import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.atomic.AtomicInteger;
import org.threadly.concurrent.AbstractSubmitterScheduler;
import org.threadly.concurrent.SubmitterScheduler;
import org.threadly.concurrent.wrapper.limiter.ExecutorQueueLimitRejector;
import org.threadly.concurrent.wrapper.limiter.RejectedExecutionHandler;
import org.threadly.util.ArgumentVerifier;

public class SubmitterSchedulerQueueLimitRejector
extends AbstractSubmitterScheduler {
    protected final SubmitterScheduler parentScheduler;
    protected final RejectedExecutionHandler rejectedExecutionHandler;
    protected final AtomicInteger queuedTaskCount;
    private int queuedTaskLimit;

    public SubmitterSchedulerQueueLimitRejector(SubmitterScheduler parentScheduler, int queuedTaskLimit) {
        this(parentScheduler, queuedTaskLimit, null);
    }

    public SubmitterSchedulerQueueLimitRejector(SubmitterScheduler parentScheduler, int queuedTaskLimit, RejectedExecutionHandler rejectedExecutionHandler) {
        ArgumentVerifier.assertNotNull(parentScheduler, "parentExecutor");
        this.parentScheduler = parentScheduler;
        if (rejectedExecutionHandler == null) {
            rejectedExecutionHandler = RejectedExecutionHandler.THROW_REJECTED_EXECUTION_EXCEPTION;
        }
        this.rejectedExecutionHandler = rejectedExecutionHandler;
        this.queuedTaskCount = new AtomicInteger();
        this.queuedTaskLimit = queuedTaskLimit;
    }

    @Override
    public void scheduleWithFixedDelay(Runnable task, long initialDelay, long recurringDelay) {
        this.parentScheduler.scheduleWithFixedDelay(task, initialDelay, recurringDelay);
    }

    @Override
    public void scheduleAtFixedRate(Runnable task, long initialDelay, long period) {
        this.parentScheduler.scheduleAtFixedRate(task, initialDelay, period);
    }

    public int getQueuedTaskCount() {
        return this.queuedTaskCount.get();
    }

    public int getQueueLimit() {
        return this.queuedTaskLimit;
    }

    public void setQueueLimit(int newLimit) {
        this.queuedTaskLimit = newLimit;
    }

    @Override
    protected void doSchedule(Runnable task, long delayInMillis) {
        int casValue;
        do {
            if ((casValue = this.queuedTaskCount.get()) < this.queuedTaskLimit) continue;
            this.rejectedExecutionHandler.handleRejectedTask(task);
            return;
        } while (!this.queuedTaskCount.weakCompareAndSetVolatile(casValue, casValue + 1));
        try {
            this.parentScheduler.schedule(new ExecutorQueueLimitRejector.DecrementingRunnable(task, this.queuedTaskCount), delayInMillis);
        }
        catch (RejectedExecutionException e) {
            this.queuedTaskCount.decrementAndGet();
            throw e;
        }
    }
}

