/*
 * Decompiled with CFR 0.152.
 */
package org.threadly.concurrent.future;

import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Consumer;
import java.util.function.Function;
import org.threadly.concurrent.future.FutureCallback;
import org.threadly.concurrent.future.InternalFutureUtils;

public interface ListenableFuture<T>
extends Future<T> {
    public boolean isCompletedExceptionally();

    public Throwable getFailure() throws InterruptedException;

    public Throwable getFailure(long var1, TimeUnit var3) throws InterruptedException, TimeoutException;

    default public <R> ListenableFuture<R> map(Function<? super T, ? extends R> mapper) {
        return InternalFutureUtils.transform(this, mapper, true, null, null);
    }

    default public <R> ListenableFuture<R> map(Function<? super T, ? extends R> mapper, Executor executor) {
        return InternalFutureUtils.transform(this, mapper, true, executor, null);
    }

    default public <R> ListenableFuture<R> map(Function<? super T, ? extends R> mapper, Executor executor, ListenerOptimizationStrategy optimizeExecution) {
        return InternalFutureUtils.transform(this, mapper, true, executor, optimizeExecution);
    }

    default public <R> ListenableFuture<R> throwMap(Function<? super T, ? extends R> mapper) {
        return InternalFutureUtils.transform(this, mapper, false, null, null);
    }

    default public <R> ListenableFuture<R> throwMap(Function<? super T, ? extends R> mapper, Executor executor) {
        return InternalFutureUtils.transform(this, mapper, false, executor, null);
    }

    default public <R> ListenableFuture<R> throwMap(Function<? super T, ? extends R> mapper, Executor executor, ListenerOptimizationStrategy optimizeExecution) {
        return InternalFutureUtils.transform(this, mapper, false, executor, optimizeExecution);
    }

    default public <R> ListenableFuture<R> flatMap(ListenableFuture<R> future) {
        return InternalFutureUtils.flatTransform(this, ignored -> future, null, null);
    }

    default public <R> ListenableFuture<R> flatMap(Function<? super T, ListenableFuture<R>> mapper) {
        return InternalFutureUtils.flatTransform(this, mapper, null, null);
    }

    default public <R> ListenableFuture<R> flatMap(Function<? super T, ListenableFuture<R>> mapper, Executor executor) {
        return InternalFutureUtils.flatTransform(this, mapper, executor, null);
    }

    default public <R> ListenableFuture<R> flatMap(Function<? super T, ListenableFuture<R>> mapper, Executor executor, ListenerOptimizationStrategy optimizeExecution) {
        return InternalFutureUtils.flatTransform(this, mapper, executor, optimizeExecution);
    }

    default public <TT extends Throwable> ListenableFuture<T> mapFailure(Class<TT> throwableType, Function<? super TT, ? extends T> mapper) {
        return InternalFutureUtils.failureTransform(this, null, mapper, throwableType, null, null);
    }

    default public <TT extends Throwable> ListenableFuture<T> mapFailure(Class<TT> throwableType, Function<? super TT, ? extends T> mapper, Executor executor) {
        return InternalFutureUtils.failureTransform(this, null, mapper, throwableType, executor, null);
    }

    default public <TT extends Throwable> ListenableFuture<T> mapFailure(Class<TT> throwableType, Function<? super TT, ? extends T> mapper, Executor executor, ListenerOptimizationStrategy optimizeExecution) {
        return InternalFutureUtils.failureTransform(this, null, mapper, throwableType, executor, optimizeExecution);
    }

    default public <TT extends Throwable> ListenableFuture<T> flatMapFailure(Class<TT> throwableType, Function<? super TT, ListenableFuture<T>> mapper) {
        return InternalFutureUtils.flatFailureTransform(this, null, mapper, throwableType, null, null);
    }

    default public <TT extends Throwable> ListenableFuture<T> flatMapFailure(Class<TT> throwableType, Function<? super TT, ListenableFuture<T>> mapper, Executor executor) {
        return InternalFutureUtils.flatFailureTransform(this, null, mapper, throwableType, executor, null);
    }

    default public <TT extends Throwable> ListenableFuture<T> flatMapFailure(Class<TT> throwableType, Function<? super TT, ListenableFuture<T>> mapper, Executor executor, ListenerOptimizationStrategy optimizeExecution) {
        return InternalFutureUtils.flatFailureTransform(this, null, mapper, throwableType, executor, optimizeExecution);
    }

    default public ListenableFuture<T> listener(Runnable listener) {
        return this.listener(listener, null, null);
    }

    default public ListenableFuture<T> listener(Runnable listener, Executor executor) {
        return this.listener(listener, executor, null);
    }

    public ListenableFuture<T> listener(Runnable var1, Executor var2, ListenerOptimizationStrategy var3);

    default public ListenableFuture<T> callback(FutureCallback<? super T> callback) {
        return this.callback(callback, null, null);
    }

    default public ListenableFuture<T> callback(FutureCallback<? super T> callback, Executor executor) {
        return this.callback(callback, executor, null);
    }

    default public ListenableFuture<T> callback(FutureCallback<? super T> callback, Executor executor, ListenerOptimizationStrategy optimizeExecution) {
        block5: {
            if (InternalFutureUtils.invokeCompletedDirectly(executor, optimizeExecution) && this.isDone()) {
                try {
                    Throwable failure = this.getFailure();
                    if (failure != null) {
                        callback.handleFailure(failure);
                        break block5;
                    }
                    callback.handleResult(this.get());
                }
                catch (Exception e) {
                    callback.handleFailure(e);
                }
            } else {
                this.listener(() -> {
                    try {
                        Throwable failure = this.getFailure();
                        if (failure != null) {
                            callback.handleFailure(failure);
                        } else {
                            callback.handleResult(this.get());
                        }
                    }
                    catch (Exception e) {
                        callback.handleFailure(e);
                    }
                }, executor, optimizeExecution);
            }
        }
        return this;
    }

    default public ListenableFuture<T> resultCallback(Consumer<? super T> callback) {
        return this.resultCallback(callback, null, null);
    }

    default public ListenableFuture<T> resultCallback(Consumer<? super T> callback, Executor executor) {
        return this.resultCallback(callback, executor, null);
    }

    default public ListenableFuture<T> resultCallback(Consumer<? super T> callback, Executor executor, ListenerOptimizationStrategy optimizeExecution) {
        if (InternalFutureUtils.invokeCompletedDirectly(executor, optimizeExecution) && this.isDone()) {
            if (!this.isCompletedExceptionally()) {
                try {
                    callback.accept(this.get());
                }
                catch (InterruptedException | ExecutionException exception) {}
            }
        } else if (!this.isCompletedExceptionally()) {
            this.listener(() -> {
                if (!this.isCompletedExceptionally()) {
                    try {
                        callback.accept(this.get());
                    }
                    catch (InterruptedException | ExecutionException exception) {
                        // empty catch block
                    }
                }
            }, executor, optimizeExecution);
        }
        return this;
    }

    default public ListenableFuture<T> failureCallback(Consumer<Throwable> callback) {
        return this.failureCallback(callback, null, null);
    }

    default public ListenableFuture<T> failureCallback(Consumer<Throwable> callback, Executor executor) {
        return this.failureCallback(callback, executor, null);
    }

    default public ListenableFuture<T> failureCallback(Consumer<Throwable> callback, Executor executor, ListenerOptimizationStrategy optimizeExecution) {
        if (InternalFutureUtils.invokeCompletedDirectly(executor, optimizeExecution) && this.isDone()) {
            try {
                if (this.isCompletedExceptionally()) {
                    callback.accept(this.getFailure());
                }
            }
            catch (Exception e) {
                callback.accept(e);
            }
        } else {
            this.listener(() -> {
                try {
                    if (this.isCompletedExceptionally()) {
                        callback.accept(this.getFailure());
                    }
                }
                catch (Exception e) {
                    callback.accept(e);
                }
            }, executor, optimizeExecution);
        }
        return this;
    }

    public StackTraceElement[] getRunningStackTrace();

    public static enum ListenerOptimizationStrategy {
        None,
        InvokingThreadIfDone,
        SingleThreadIfExecutorMatch,
        SingleThreadIfExecutorMatchOrDone;

    }
}

