/*
 * Decompiled with CFR 0.152.
 */
package org.threadly.concurrent.future;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.threadly.concurrent.future.FutureCallback;
import org.threadly.concurrent.future.FutureUtils;
import org.threadly.concurrent.future.ListenableFuture;
import org.threadly.concurrent.future.SettableListenableFuture;

public class CompletableFutureAdapter {
    public static <T> CompletableFuture<T> toCompletable(ListenableFuture<? extends T> lf) {
        return new AdaptedCompletableFuture<T>(lf);
    }

    public static <T> ListenableFuture<T> toListenable(CompletableFuture<? extends T> cf) {
        if (cf instanceof ListenableFuture) {
            return (ListenableFuture)((Object)cf);
        }
        if (cf.isDone() && !cf.isCompletedExceptionally()) {
            try {
                return FutureUtils.immediateResultFuture(cf.get());
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new RuntimeException(e);
            }
            catch (ExecutionException e) {
                return FutureUtils.immediateFailureFuture(e.getCause());
            }
        }
        return new AdaptedListenableFuture<T>(cf);
    }

    protected static class AdaptedListenableFuture<T>
    extends SettableListenableFuture<T> {
        protected final CompletableFuture<? extends T> cf;

        public AdaptedListenableFuture(CompletableFuture<? extends T> cf) {
            this.cf = cf;
            cf.whenComplete((result, error) -> {
                if (error != null) {
                    this.setFailure((Throwable)error);
                } else {
                    this.setResult(result);
                }
            });
        }
    }

    protected static class AdaptedCompletableFuture<T>
    extends CompletableFuture<T>
    implements ListenableFuture<T> {
        protected final ListenableFuture<? extends T> lf;

        public AdaptedCompletableFuture(ListenableFuture<? extends T> lf) {
            this.lf = lf;
            lf.callback(new FutureCallback<T>(){

                @Override
                public void handleResult(T result) {
                    this.complete(result);
                }

                @Override
                public void handleFailure(Throwable t) {
                    this.completeExceptionally(t);
                }
            });
        }

        @Override
        public ListenableFuture<T> listener(Runnable listener, Executor executor, ListenableFuture.ListenerOptimizationStrategy optimizeExecution) {
            this.lf.listener(listener, executor, optimizeExecution);
            return this;
        }

        @Override
        public StackTraceElement[] getRunningStackTrace() {
            return this.lf.getRunningStackTrace();
        }

        @Override
        public Throwable getFailure() throws InterruptedException {
            return this.lf.getFailure();
        }

        @Override
        public Throwable getFailure(long timeout, TimeUnit unit) throws InterruptedException, TimeoutException {
            return this.lf.getFailure(timeout, unit);
        }
    }
}

