/*
 * Decompiled with CFR 0.152.
 */
package org.threadly.concurrent.event;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.concurrent.Executor;
import org.threadly.concurrent.event.DefaultExecutorListenerHelper;
import org.threadly.concurrent.event.ListenerHelper;
import org.threadly.util.ExceptionUtils;

public class InvocationTee {
    public static <T> T tee(Class<? super T> teeInterface, T ... instances) {
        return InvocationTee.setupHelper(new ListenerHelper<T>(teeInterface), instances);
    }

    public static <T> T teeWithExceptionThrowing(Class<? super T> teeInterface, T ... instances) {
        ListenerHelper lh = new ListenerHelper<T>((Class)teeInterface){

            @Override
            protected T makeProxyInstance(Class<? super T> listenerInterface) {
                return Proxy.newProxyInstance(listenerInterface.getClassLoader(), new Class[]{listenerInterface}, (InvocationHandler)new ListenerHelper.ListenerCaller(){

                    @Override
                    protected void callListener(T listener, Method method, Object[] args) {
                        try {
                            method.invoke(listener, args);
                        }
                        catch (IllegalAccessException e) {
                            ExceptionUtils.handleException(e);
                        }
                        catch (InvocationTargetException e) {
                            throw ExceptionUtils.makeRuntime(e.getCause());
                        }
                    }
                });
            }
        };
        return InvocationTee.setupHelper(lh, instances);
    }

    public static <T> T teeWithExecutor(Executor executor, Class<? super T> teeInterface, T ... instances) {
        return InvocationTee.setupHelper(new DefaultExecutorListenerHelper<T>(teeInterface, executor), instances);
    }

    private static <T> T setupHelper(ListenerHelper<T> lh, T ... instances) {
        for (T instance : instances) {
            lh.addListener(instance);
        }
        return lh.call();
    }
}

