/*
 * Decompiled with CFR 0.152.
 */
package org.threadly.concurrent;

import java.util.Objects;
import java.util.concurrent.Delayed;
import java.util.concurrent.TimeUnit;
import org.threadly.concurrent.AbstractPriorityScheduler;
import org.threadly.concurrent.NoThreadScheduler;
import org.threadly.concurrent.PriorityScheduler;
import org.threadly.concurrent.SingleThreadScheduler;
import org.threadly.concurrent.TaskPriority;
import org.threadly.util.Clock;

public final class ThreadlyInternalAccessor {
    public static Delayed doScheduleAndGetDelayed(AbstractPriorityScheduler pScheduler, Runnable task, TaskPriority priority, long delayInMillis) {
        return new DelayedTaskWrapper(pScheduler.doSchedule(task, delayInMillis, priority));
    }

    public static Delayed doScheduleAtFixedRateAndGetDelayed(PriorityScheduler pScheduler, Runnable task, TaskPriority priority, long initialDelay, long periodInMillis) {
        AbstractPriorityScheduler.QueueSet queueSet = pScheduler.queueManager.getQueueSet(priority);
        AbstractPriorityScheduler.AccurateRecurringRateTaskWrapper rrtw = new AbstractPriorityScheduler.AccurateRecurringRateTaskWrapper(task, queueSet, Clock.accurateForwardProgressingMillis() + initialDelay, periodInMillis);
        pScheduler.queueScheduled(queueSet, rrtw);
        return new DelayedTaskWrapper(rrtw);
    }

    public static Delayed doScheduleWithFixedDelayAndGetDelayed(PriorityScheduler pScheduler, Runnable task, TaskPriority priority, long initialDelay, long delayInMs) {
        AbstractPriorityScheduler.QueueSet queueSet = pScheduler.queueManager.getQueueSet(priority);
        AbstractPriorityScheduler.AccurateRecurringDelayTaskWrapper rdtw = new AbstractPriorityScheduler.AccurateRecurringDelayTaskWrapper(task, queueSet, Clock.accurateForwardProgressingMillis() + initialDelay, delayInMs);
        pScheduler.queueScheduled(queueSet, rdtw);
        return new DelayedTaskWrapper(rdtw);
    }

    public static Delayed doScheduleAtFixedRateAndGetDelayed(SingleThreadScheduler scheduler, Runnable task, TaskPriority priority, long initialDelay, long periodInMillis) {
        NoThreadScheduler nts = scheduler.getRunningScheduler();
        AbstractPriorityScheduler.QueueSet queueSet = nts.queueManager.getQueueSet(priority);
        NoThreadScheduler noThreadScheduler = nts;
        Objects.requireNonNull(noThreadScheduler);
        NoThreadScheduler.NoThreadRecurringRateTaskWrapper rt = new NoThreadScheduler.NoThreadRecurringRateTaskWrapper(noThreadScheduler, task, queueSet, Clock.accurateForwardProgressingMillis() + initialDelay, periodInMillis);
        queueSet.addScheduled(rt);
        return new DelayedTaskWrapper(rt);
    }

    public static Delayed doScheduleWithFixedDelayAndGetDelayed(SingleThreadScheduler scheduler, Runnable task, TaskPriority priority, long initialDelay, long delayInMs) {
        NoThreadScheduler nts = scheduler.getRunningScheduler();
        AbstractPriorityScheduler.QueueSet queueSet = nts.queueManager.getQueueSet(priority);
        NoThreadScheduler noThreadScheduler = nts;
        Objects.requireNonNull(noThreadScheduler);
        NoThreadScheduler.NoThreadRecurringDelayTaskWrapper rdt = new NoThreadScheduler.NoThreadRecurringDelayTaskWrapper(noThreadScheduler, task, queueSet, Clock.accurateForwardProgressingMillis() + initialDelay, delayInMs);
        queueSet.addScheduled(rdt);
        return new DelayedTaskWrapper(rdt);
    }

    protected static final class DelayedTaskWrapper
    implements Delayed {
        private final AbstractPriorityScheduler.TaskWrapper task;

        public DelayedTaskWrapper(AbstractPriorityScheduler.TaskWrapper task) {
            this.task = task;
        }

        @Override
        public long getDelay(TimeUnit unit) {
            return unit.convert(this.task.getRunTime() - Clock.accurateForwardProgressingMillis(), TimeUnit.MILLISECONDS);
        }

        @Override
        public int compareTo(Delayed o) {
            long otherDelay;
            if (this == o) {
                return 0;
            }
            if (o instanceof DelayedTaskWrapper) {
                return (int)(this.task.getRunTime() - ((DelayedTaskWrapper)o).task.getRunTime());
            }
            long thisDelay = this.getDelay(TimeUnit.MILLISECONDS);
            if (thisDelay == (otherDelay = o.getDelay(TimeUnit.MILLISECONDS))) {
                return 0;
            }
            if (thisDelay > otherDelay) {
                return 1;
            }
            return -1;
        }
    }
}

