/*
 * Decompiled with CFR 0.152.
 */
package com.ishland.c2me.threading.worldgen.common.debug;

import com.google.common.collect.Sets;
import com.ishland.c2me.threading.worldgen.common.Config;
import com.mojang.logging.LogUtils;
import java.util.Arrays;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1948;
import net.minecraft.class_3532;
import net.minecraft.class_3754;
import net.minecraft.class_3826;
import net.minecraft.class_4538;
import net.minecraft.class_5138;
import net.minecraft.class_5329;
import net.minecraft.class_6749;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;

public class StacktraceRecorder {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final boolean doRecord = Config.reduceLockRadius && Boolean.getBoolean("com.ishland.c2me.common.threading.worldgen.debug.DebugReducedLockRadius");
    private static final int recordFrequency = class_3532.method_15340((int)Integer.getInteger("com.ishland.c2me.common.threading.worldgen.debug.DebugReducedLockRadiusFrequency", 4), (int)1, (int)16);
    private static final long frequencyBitMask = (1L << recordFrequency) - 1L;
    private static final Set<StacktraceHolder> recordedStacktraces = Sets.newConcurrentHashSet();
    private static final AtomicLong sampledCount = new AtomicLong();

    public static void record() {
        if (!doRecord) {
            return;
        }
        if ((sampledCount.incrementAndGet() & frequencyBitMask) != 0L) {
            return;
        }
        StacktraceHolder stacktraceHolder = new StacktraceHolder();
        if (recordedStacktraces.add(stacktraceHolder) && stacktraceHolder.needPrint()) {
            LOGGER.warn("Potential dangerous call with reducedLockRadius", stacktraceHolder.throwable);
        }
    }

    public static class StacktraceHolder {
        private static final String StructureProcessor$process = FabricLoader.getInstance().getMappingResolver().mapMethodName("intermediary", "net.minecraft.class_3491", "method_15110", "(Lnet/minecraft/class_4538;Lnet/minecraft/class_2338;Lnet/minecraft/class_2338;Lnet/minecraft/class_3499$class_3501;Lnet/minecraft/class_3499$class_3501;Lnet/minecraft/class_3492;)Lnet/minecraft/class_3499$class_3501;");
        private static final String BlendingData$getBlendingData = FabricLoader.getInstance().getMappingResolver().mapMethodName("intermediary", "net.minecraft.class_6749", "method_39570", "(Lnet/minecraft/class_3233;II)Lnet/minecraft/class_6749;");
        private static final String ChunkGenerator$carve = FabricLoader.getInstance().getMappingResolver().mapMethodName("intermediary", "net.minecraft.class_2794", "method_12108", "(Lnet/minecraft/class_3233;JLnet/minecraft/class_7138;Lnet/minecraft/class_4543;Lnet/minecraft/class_5138;Lnet/minecraft/class_2791;Lnet/minecraft/class_2893$class_2894;)V");
        private static final String SpawnHelper$populateEntities = FabricLoader.getInstance().getMappingResolver().mapMethodName("intermediary", "net.minecraft.class_1948", "method_8661", "(Lnet/minecraft/class_5425;Lnet/minecraft/class_1959;Lnet/minecraft/class_1923;Ljava/util/Random;)V");
        private static final String StructureAccessor$method_41032 = FabricLoader.getInstance().getMappingResolver().mapMethodName("intermediary", "net.minecraft.class_5138", "method_41032", "(Lnet/minecraft/class_4076;Lnet/minecraft/class_5312;)Ljava/util/List;");
        private static final String BiomeAccess$Storage$getBiomeForNoiseGen = FabricLoader.getInstance().getMappingResolver().mapMethodName("intermediary", "net.minecraft.class_4543$class_4544", "method_16359", "(III)Lnet/minecraft/class_6880;");
        private static final String BlockCollisionSpliterator$getChunk = FabricLoader.getInstance().getMappingResolver().mapMethodName("intermediary", "net.minecraft.class_5329", "method_29283", "(II)Lnet/minecraft/class_1922;");
        @NotNull
        private final StackTraceElement[] stackTrace;
        private final Throwable throwable = new Throwable();

        public StacktraceHolder() {
            this.stackTrace = this.throwable.getStackTrace();
        }

        public boolean needPrint() {
            for (StackTraceElement stackTraceElement : this.stackTrace) {
                if (stackTraceElement.getMethodName().equals("method_26971")) {
                    return false;
                }
                if (stackTraceElement.getClassName().equals(class_3826.class.getName()) && stackTraceElement.getMethodName().equals(StructureProcessor$process)) {
                    return false;
                }
                if (stackTraceElement.getClassName().equals(class_6749.class.getName()) && stackTraceElement.getMethodName().equals(BlendingData$getBlendingData)) {
                    return false;
                }
                if (stackTraceElement.getClassName().equals(class_3754.class.getName()) && stackTraceElement.getMethodName().equals(ChunkGenerator$carve)) {
                    return false;
                }
                if (stackTraceElement.getClassName().equals(class_1948.class.getName()) && stackTraceElement.getMethodName().equals(SpawnHelper$populateEntities)) {
                    return false;
                }
                if (stackTraceElement.getClassName().equals(class_5138.class.getName()) && stackTraceElement.getMethodName().equals(StructureAccessor$method_41032)) {
                    return false;
                }
                if (stackTraceElement.getClassName().equals(class_4538.class.getName()) && stackTraceElement.getMethodName().equals(BiomeAccess$Storage$getBiomeForNoiseGen)) {
                    return false;
                }
                if (stackTraceElement.getClassName().equals(class_5329.class.getName()) && stackTraceElement.getMethodName().equals(BlockCollisionSpliterator$getChunk)) {
                    return false;
                }
                if (!stackTraceElement.getClassName().equals("me.jellysquid.mods.lithium.common.entity.movement.ChunkAwareBlockCollisionSweeper")) continue;
                return false;
            }
            return true;
        }

        public String toString() {
            return "StacktraceHolder{stackTrace=" + Arrays.toString(this.stackTrace) + "}";
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            StacktraceHolder that = (StacktraceHolder)o;
            return Arrays.equals(this.stackTrace, that.stackTrace);
        }

        public int hashCode() {
            return Arrays.hashCode(this.stackTrace);
        }
    }
}

