/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.api.networking.v1;

import java.util.Objects;
import java.util.Set;
import net.fabricmc.fabric.api.networking.v1.FabricPacket;
import net.fabricmc.fabric.api.networking.v1.PacketSender;
import net.fabricmc.fabric.api.networking.v1.PacketType;
import net.fabricmc.fabric.impl.networking.server.ServerNetworkingImpl;
import net.minecraft.class_2540;
import net.minecraft.class_2596;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3244;
import net.minecraft.class_8705;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.Nullable;

public final class ServerPlayNetworking {
    public static boolean registerGlobalReceiver(class_2960 channelName, PlayChannelHandler channelHandler) {
        return ServerNetworkingImpl.PLAY.registerGlobalReceiver(channelName, channelHandler);
    }

    public static <T extends FabricPacket> boolean registerGlobalReceiver(final PacketType<T> type, final PlayPacketHandler<T> handler) {
        return ServerPlayNetworking.registerGlobalReceiver(type.getId(), new PlayChannelHandlerProxy<T>(){

            @Override
            public PlayPacketHandler<T> getOriginalHandler() {
                return handler;
            }

            @Override
            public void receive(MinecraftServer server, class_3222 player, class_3244 networkHandler, class_2540 buf, PacketSender sender) {
                Object packet = type.read(buf);
                if (server.method_18854()) {
                    handler.receive(packet, player, sender);
                } else {
                    server.execute(() -> {
                        if (networkHandler.method_48106()) {
                            handler.receive(packet, player, sender);
                        }
                    });
                }
            }
        });
    }

    @Nullable
    public static PlayChannelHandler unregisterGlobalReceiver(class_2960 channelName) {
        return ServerNetworkingImpl.PLAY.unregisterGlobalReceiver(channelName);
    }

    @Nullable
    public static <T extends FabricPacket> PlayPacketHandler<T> unregisterGlobalReceiver(PacketType<T> type) {
        PlayPacketHandler playPacketHandler;
        PlayChannelHandler handler = ServerNetworkingImpl.PLAY.unregisterGlobalReceiver(type.getId());
        if (handler instanceof PlayChannelHandlerProxy) {
            PlayChannelHandlerProxy proxy = (PlayChannelHandlerProxy)handler;
            playPacketHandler = proxy.getOriginalHandler();
        } else {
            playPacketHandler = null;
        }
        return playPacketHandler;
    }

    public static Set<class_2960> getGlobalReceivers() {
        return ServerNetworkingImpl.PLAY.getChannels();
    }

    public static boolean registerReceiver(class_3244 networkHandler, class_2960 channelName, PlayChannelHandler channelHandler) {
        Objects.requireNonNull(networkHandler, "Network handler cannot be null");
        return ServerNetworkingImpl.getAddon(networkHandler).registerChannel(channelName, channelHandler);
    }

    public static <T extends FabricPacket> boolean registerReceiver(class_3244 networkHandler, final PacketType<T> type, final PlayPacketHandler<T> handler) {
        return ServerPlayNetworking.registerReceiver(networkHandler, type.getId(), new PlayChannelHandlerProxy<T>(){

            @Override
            public PlayPacketHandler<T> getOriginalHandler() {
                return handler;
            }

            @Override
            public void receive(MinecraftServer server, class_3222 player, class_3244 networkHandler2, class_2540 buf, PacketSender sender) {
                Object packet = type.read(buf);
                if (server.method_18854()) {
                    handler.receive(packet, player, sender);
                } else {
                    server.execute(() -> {
                        if (networkHandler2.method_48106()) {
                            handler.receive(packet, player, sender);
                        }
                    });
                }
            }
        });
    }

    @Nullable
    public static PlayChannelHandler unregisterReceiver(class_3244 networkHandler, class_2960 channelName) {
        Objects.requireNonNull(networkHandler, "Network handler cannot be null");
        return (PlayChannelHandler)ServerNetworkingImpl.getAddon(networkHandler).unregisterChannel(channelName);
    }

    @Nullable
    public static <T extends FabricPacket> PlayPacketHandler<T> unregisterReceiver(class_3244 networkHandler, PacketType<T> type) {
        PlayPacketHandler playPacketHandler;
        PlayChannelHandler handler = ServerPlayNetworking.unregisterReceiver(networkHandler, type.getId());
        if (handler instanceof PlayChannelHandlerProxy) {
            PlayChannelHandlerProxy proxy = (PlayChannelHandlerProxy)handler;
            playPacketHandler = proxy.getOriginalHandler();
        } else {
            playPacketHandler = null;
        }
        return playPacketHandler;
    }

    public static Set<class_2960> getReceived(class_3222 player) {
        Objects.requireNonNull(player, "Server player entity cannot be null");
        return ServerPlayNetworking.getReceived(player.field_13987);
    }

    public static Set<class_2960> getReceived(class_3244 handler) {
        Objects.requireNonNull(handler, "Server play network handler cannot be null");
        return ServerNetworkingImpl.getAddon(handler).getReceivableChannels();
    }

    public static Set<class_2960> getSendable(class_3222 player) {
        Objects.requireNonNull(player, "Server player entity cannot be null");
        return ServerPlayNetworking.getSendable(player.field_13987);
    }

    public static Set<class_2960> getSendable(class_3244 handler) {
        Objects.requireNonNull(handler, "Server play network handler cannot be null");
        return ServerNetworkingImpl.getAddon(handler).getSendableChannels();
    }

    public static boolean canSend(class_3222 player, class_2960 channelName) {
        Objects.requireNonNull(player, "Server player entity cannot be null");
        return ServerPlayNetworking.canSend(player.field_13987, channelName);
    }

    public static boolean canSend(class_3222 player, PacketType<?> type) {
        Objects.requireNonNull(player, "Server player entity cannot be null");
        return ServerPlayNetworking.canSend(player.field_13987, type.getId());
    }

    public static boolean canSend(class_3244 handler, class_2960 channelName) {
        Objects.requireNonNull(handler, "Server play network handler cannot be null");
        Objects.requireNonNull(channelName, "Channel name cannot be null");
        return ServerNetworkingImpl.getAddon(handler).getSendableChannels().contains(channelName);
    }

    public static boolean canSend(class_3244 handler, PacketType<?> type) {
        Objects.requireNonNull(handler, "Server play network handler cannot be null");
        Objects.requireNonNull(type, "Packet type cannot be null");
        return ServerNetworkingImpl.getAddon(handler).getSendableChannels().contains(type.getId());
    }

    public static class_2596<class_8705> createS2CPacket(class_2960 channelName, class_2540 buf) {
        Objects.requireNonNull(channelName, "Channel cannot be null");
        Objects.requireNonNull(buf, "Buf cannot be null");
        return ServerNetworkingImpl.createS2CPacket(channelName, buf);
    }

    public static <T extends FabricPacket> class_2596<class_8705> createS2CPacket(T packet) {
        return ServerNetworkingImpl.createS2CPacket(packet);
    }

    public static PacketSender getSender(class_3222 player) {
        Objects.requireNonNull(player, "Server player entity cannot be null");
        return ServerPlayNetworking.getSender(player.field_13987);
    }

    public static PacketSender getSender(class_3244 handler) {
        Objects.requireNonNull(handler, "Server play network handler cannot be null");
        return ServerNetworkingImpl.getAddon(handler);
    }

    public static void send(class_3222 player, class_2960 channelName, class_2540 buf) {
        Objects.requireNonNull(player, "Server player entity cannot be null");
        Objects.requireNonNull(channelName, "Channel name cannot be null");
        Objects.requireNonNull(buf, "Packet byte buf cannot be null");
        player.field_13987.method_14364(ServerPlayNetworking.createS2CPacket(channelName, buf));
    }

    public static <T extends FabricPacket> void send(class_3222 player, T packet) {
        Objects.requireNonNull(player, "Server player entity cannot be null");
        Objects.requireNonNull(packet, "Packet cannot be null");
        Objects.requireNonNull(packet.getType(), "Packet#getType cannot return null");
        player.field_13987.method_14364(ServerPlayNetworking.createS2CPacket(packet));
    }

    public static MinecraftServer getServer(class_3244 handler) {
        Objects.requireNonNull(handler, "Network handler cannot be null");
        return handler.field_14140.field_13995;
    }

    private ServerPlayNetworking() {
    }

    @FunctionalInterface
    public static interface PlayPacketHandler<T extends FabricPacket> {
        public void receive(T var1, class_3222 var2, PacketSender var3);
    }

    @FunctionalInterface
    public static interface PlayChannelHandler {
        public void receive(MinecraftServer var1, class_3222 var2, class_3244 var3, class_2540 var4, PacketSender var5);
    }

    private static interface PlayChannelHandlerProxy<T extends FabricPacket>
    extends PlayChannelHandler {
        public PlayPacketHandler<T> getOriginalHandler();
    }
}

