/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.api.networking.v1;

import java.util.Objects;
import java.util.Set;
import net.fabricmc.fabric.api.networking.v1.FabricPacket;
import net.fabricmc.fabric.api.networking.v1.PacketSender;
import net.fabricmc.fabric.api.networking.v1.PacketType;
import net.fabricmc.fabric.impl.networking.server.ServerNetworkingImpl;
import net.fabricmc.fabric.mixin.networking.accessor.ServerCommonNetworkHandlerAccessor;
import net.minecraft.class_2540;
import net.minecraft.class_2596;
import net.minecraft.class_2960;
import net.minecraft.class_8610;
import net.minecraft.class_8705;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.Nullable;

public final class ServerConfigurationNetworking {
    public static boolean registerGlobalReceiver(class_2960 channelName, ConfigurationChannelHandler channelHandler) {
        return ServerNetworkingImpl.CONFIGURATION.registerGlobalReceiver(channelName, channelHandler);
    }

    public static <T extends FabricPacket> boolean registerGlobalReceiver(final PacketType<T> type, final ConfigurationPacketHandler<T> handler) {
        return ServerConfigurationNetworking.registerGlobalReceiver(type.getId(), new ConfigurationChannelHandlerProxy<T>(){

            @Override
            public ConfigurationPacketHandler<T> getOriginalHandler() {
                return handler;
            }

            @Override
            public void receive(MinecraftServer server, class_8610 networkHandler, class_2540 buf, PacketSender sender) {
                Object packet = type.read(buf);
                handler.receive(packet, networkHandler, sender);
            }
        });
    }

    @Nullable
    public static ConfigurationChannelHandler unregisterGlobalReceiver(class_2960 channelName) {
        return ServerNetworkingImpl.CONFIGURATION.unregisterGlobalReceiver(channelName);
    }

    @Nullable
    public static <T extends FabricPacket> ConfigurationPacketHandler<T> unregisterGlobalReceiver(PacketType<T> type) {
        ConfigurationPacketHandler configurationPacketHandler;
        ConfigurationChannelHandler handler = ServerNetworkingImpl.CONFIGURATION.unregisterGlobalReceiver(type.getId());
        if (handler instanceof ConfigurationChannelHandlerProxy) {
            ConfigurationChannelHandlerProxy proxy = (ConfigurationChannelHandlerProxy)handler;
            configurationPacketHandler = proxy.getOriginalHandler();
        } else {
            configurationPacketHandler = null;
        }
        return configurationPacketHandler;
    }

    public static Set<class_2960> getGlobalReceivers() {
        return ServerNetworkingImpl.CONFIGURATION.getChannels();
    }

    public static boolean registerReceiver(class_8610 networkHandler, class_2960 channelName, ConfigurationChannelHandler channelHandler) {
        Objects.requireNonNull(networkHandler, "Network handler cannot be null");
        return ServerNetworkingImpl.getAddon(networkHandler).registerChannel(channelName, channelHandler);
    }

    public static <T extends FabricPacket> boolean registerReceiver(class_8610 networkHandler, final PacketType<T> type, final ConfigurationPacketHandler<T> handler) {
        return ServerConfigurationNetworking.registerReceiver(networkHandler, type.getId(), new ConfigurationChannelHandlerProxy<T>(){

            @Override
            public ConfigurationPacketHandler<T> getOriginalHandler() {
                return handler;
            }

            @Override
            public void receive(MinecraftServer server, class_8610 networkHandler2, class_2540 buf, PacketSender sender) {
                Object packet = type.read(buf);
                handler.receive(packet, networkHandler2, sender);
            }
        });
    }

    @Nullable
    public static ConfigurationChannelHandler unregisterReceiver(class_8610 networkHandler, class_2960 channelName) {
        Objects.requireNonNull(networkHandler, "Network handler cannot be null");
        return (ConfigurationChannelHandler)ServerNetworkingImpl.getAddon(networkHandler).unregisterChannel(channelName);
    }

    @Nullable
    public static <T extends FabricPacket> ConfigurationPacketHandler<T> unregisterReceiver(class_8610 networkHandler, PacketType<T> type) {
        ConfigurationPacketHandler configurationPacketHandler;
        ConfigurationChannelHandler handler = ServerConfigurationNetworking.unregisterReceiver(networkHandler, type.getId());
        if (handler instanceof ConfigurationChannelHandlerProxy) {
            ConfigurationChannelHandlerProxy proxy = (ConfigurationChannelHandlerProxy)handler;
            configurationPacketHandler = proxy.getOriginalHandler();
        } else {
            configurationPacketHandler = null;
        }
        return configurationPacketHandler;
    }

    public static Set<class_2960> getReceived(class_8610 handler) {
        Objects.requireNonNull(handler, "Server configuration network handler cannot be null");
        return ServerNetworkingImpl.getAddon(handler).getReceivableChannels();
    }

    public static Set<class_2960> getSendable(class_8610 handler) {
        Objects.requireNonNull(handler, "Server configuration network handler cannot be null");
        return ServerNetworkingImpl.getAddon(handler).getSendableChannels();
    }

    public static boolean canSend(class_8610 handler, class_2960 channelName) {
        Objects.requireNonNull(handler, "Server configuration network handler cannot be null");
        Objects.requireNonNull(channelName, "Channel name cannot be null");
        return ServerNetworkingImpl.getAddon(handler).getSendableChannels().contains(channelName);
    }

    public static boolean canSend(class_8610 handler, PacketType<?> type) {
        Objects.requireNonNull(handler, "Server configuration network handler cannot be null");
        Objects.requireNonNull(type, "Packet type cannot be null");
        return ServerNetworkingImpl.getAddon(handler).getSendableChannels().contains(type.getId());
    }

    public static class_2596<class_8705> createS2CPacket(class_2960 channelName, class_2540 buf) {
        Objects.requireNonNull(channelName, "Channel cannot be null");
        Objects.requireNonNull(buf, "Buf cannot be null");
        return ServerNetworkingImpl.createS2CPacket(channelName, buf);
    }

    public static <T extends FabricPacket> class_2596<class_8705> createS2CPacket(T packet) {
        Objects.requireNonNull(packet, "Packet cannot be null");
        Objects.requireNonNull(packet.getType(), "Packet#getType cannot return null");
        return ServerNetworkingImpl.createS2CPacket(packet);
    }

    public static PacketSender getSender(class_8610 handler) {
        Objects.requireNonNull(handler, "Server configuration network handler cannot be null");
        return ServerNetworkingImpl.getAddon(handler);
    }

    public static void send(class_8610 handler, class_2960 channelName, class_2540 buf) {
        Objects.requireNonNull(handler, "Server configuration entity cannot be null");
        Objects.requireNonNull(channelName, "Channel name cannot be null");
        Objects.requireNonNull(buf, "Packet byte buf cannot be null");
        handler.method_14364(ServerConfigurationNetworking.createS2CPacket(channelName, buf));
    }

    public static <T extends FabricPacket> void send(class_8610 handler, T packet) {
        Objects.requireNonNull(handler, "Server configuration handler cannot be null");
        Objects.requireNonNull(packet, "Packet cannot be null");
        Objects.requireNonNull(packet.getType(), "Packet#getType cannot return null");
        handler.method_14364(ServerConfigurationNetworking.createS2CPacket(packet));
    }

    public static MinecraftServer getServer(class_8610 handler) {
        Objects.requireNonNull(handler, "Network handler cannot be null");
        return ((ServerCommonNetworkHandlerAccessor)handler).getServer();
    }

    private ServerConfigurationNetworking() {
    }

    @FunctionalInterface
    public static interface ConfigurationPacketHandler<T extends FabricPacket> {
        public void receive(T var1, class_8610 var2, PacketSender var3);
    }

    @FunctionalInterface
    public static interface ConfigurationChannelHandler {
        public void receive(MinecraftServer var1, class_8610 var2, class_2540 var3, PacketSender var4);
    }

    private static interface ConfigurationChannelHandlerProxy<T extends FabricPacket>
    extends ConfigurationChannelHandler {
        public ConfigurationPacketHandler<T> getOriginalHandler();
    }
}

