/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.api.client.networking.v1;

import java.util.Objects;
import java.util.Set;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.networking.v1.FabricPacket;
import net.fabricmc.fabric.api.networking.v1.PacketSender;
import net.fabricmc.fabric.api.networking.v1.PacketType;
import net.fabricmc.fabric.impl.networking.client.ClientNetworkingImpl;
import net.fabricmc.fabric.impl.networking.client.ClientPlayNetworkAddon;
import net.minecraft.class_2540;
import net.minecraft.class_2596;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_634;
import net.minecraft.class_746;
import net.minecraft.class_8706;
import org.jetbrains.annotations.Nullable;

@Environment(value=EnvType.CLIENT)
public final class ClientPlayNetworking {
    public static boolean registerGlobalReceiver(class_2960 channelName, PlayChannelHandler channelHandler) {
        return ClientNetworkingImpl.PLAY.registerGlobalReceiver(channelName, channelHandler);
    }

    public static <T extends FabricPacket> boolean registerGlobalReceiver(final PacketType<T> type, final PlayPacketHandler<T> handler) {
        return ClientPlayNetworking.registerGlobalReceiver(type.getId(), new PlayChannelHandlerProxy<T>(){

            @Override
            public PlayPacketHandler<T> getOriginalHandler() {
                return handler;
            }

            @Override
            public void receive(class_310 client, class_634 networkHandler, class_2540 buf, PacketSender sender) {
                Object packet = type.read(buf);
                if (client.method_18854()) {
                    handler.receive(packet, client.field_1724, sender);
                } else {
                    client.execute(() -> {
                        if (networkHandler.method_48296().method_10758()) {
                            handler.receive(packet, client.field_1724, sender);
                        }
                    });
                }
            }
        });
    }

    @Nullable
    public static PlayChannelHandler unregisterGlobalReceiver(class_2960 channelName) {
        return ClientNetworkingImpl.PLAY.unregisterGlobalReceiver(channelName);
    }

    @Nullable
    public static <T extends FabricPacket> PlayPacketHandler<T> unregisterGlobalReceiver(PacketType<T> type) {
        PlayPacketHandler playPacketHandler;
        PlayChannelHandler handler = ClientNetworkingImpl.PLAY.unregisterGlobalReceiver(type.getId());
        if (handler instanceof PlayChannelHandlerProxy) {
            PlayChannelHandlerProxy proxy = (PlayChannelHandlerProxy)handler;
            playPacketHandler = proxy.getOriginalHandler();
        } else {
            playPacketHandler = null;
        }
        return playPacketHandler;
    }

    public static Set<class_2960> getGlobalReceivers() {
        return ClientNetworkingImpl.PLAY.getChannels();
    }

    public static boolean registerReceiver(class_2960 channelName, PlayChannelHandler channelHandler) {
        ClientPlayNetworkAddon addon = ClientNetworkingImpl.getClientPlayAddon();
        if (addon != null) {
            return addon.registerChannel(channelName, channelHandler);
        }
        throw new IllegalStateException("Cannot register receiver while not in game!");
    }

    public static <T extends FabricPacket> boolean registerReceiver(final PacketType<T> type, final PlayPacketHandler<T> handler) {
        return ClientPlayNetworking.registerReceiver(type.getId(), new PlayChannelHandlerProxy<T>(){

            @Override
            public PlayPacketHandler<T> getOriginalHandler() {
                return handler;
            }

            @Override
            public void receive(class_310 client, class_634 networkHandler, class_2540 buf, PacketSender sender) {
                Object packet = type.read(buf);
                if (client.method_18854()) {
                    handler.receive(packet, client.field_1724, sender);
                } else {
                    client.execute(() -> {
                        if (networkHandler.method_48296().method_10758()) {
                            handler.receive(packet, client.field_1724, sender);
                        }
                    });
                }
            }
        });
    }

    @Nullable
    public static PlayChannelHandler unregisterReceiver(class_2960 channelName) throws IllegalStateException {
        ClientPlayNetworkAddon addon = ClientNetworkingImpl.getClientPlayAddon();
        if (addon != null) {
            return (PlayChannelHandler)addon.unregisterChannel(channelName);
        }
        throw new IllegalStateException("Cannot unregister receiver while not in game!");
    }

    @Nullable
    public static <T extends FabricPacket> PlayPacketHandler<T> unregisterReceiver(PacketType<T> type) {
        PlayPacketHandler playPacketHandler;
        PlayChannelHandler handler = ClientPlayNetworking.unregisterReceiver(type.getId());
        if (handler instanceof PlayChannelHandlerProxy) {
            PlayChannelHandlerProxy proxy = (PlayChannelHandlerProxy)handler;
            playPacketHandler = proxy.getOriginalHandler();
        } else {
            playPacketHandler = null;
        }
        return playPacketHandler;
    }

    public static Set<class_2960> getReceived() throws IllegalStateException {
        ClientPlayNetworkAddon addon = ClientNetworkingImpl.getClientPlayAddon();
        if (addon != null) {
            return addon.getReceivableChannels();
        }
        throw new IllegalStateException("Cannot get a list of channels the client can receive packets on while not in game!");
    }

    public static Set<class_2960> getSendable() throws IllegalStateException {
        ClientPlayNetworkAddon addon = ClientNetworkingImpl.getClientPlayAddon();
        if (addon != null) {
            return addon.getSendableChannels();
        }
        throw new IllegalStateException("Cannot get a list of channels the server can receive packets on while not in game!");
    }

    public static boolean canSend(class_2960 channelName) throws IllegalArgumentException {
        if (class_310.method_1551().method_1562() != null) {
            return ClientNetworkingImpl.getAddon(class_310.method_1551().method_1562()).getSendableChannels().contains(channelName);
        }
        return false;
    }

    public static boolean canSend(PacketType<?> type) {
        return ClientPlayNetworking.canSend(type.getId());
    }

    public static class_2596<class_8706> createC2SPacket(class_2960 channelName, class_2540 buf) {
        Objects.requireNonNull(channelName, "Channel name cannot be null");
        Objects.requireNonNull(buf, "Buf cannot be null");
        return ClientNetworkingImpl.createC2SPacket(channelName, buf);
    }

    public static <T extends FabricPacket> class_2596<class_8706> createC2SPacket(T packet) {
        return ClientNetworkingImpl.createC2SPacket(packet);
    }

    public static PacketSender getSender() throws IllegalStateException {
        if (class_310.method_1551().method_1562() != null) {
            return ClientNetworkingImpl.getAddon(class_310.method_1551().method_1562());
        }
        throw new IllegalStateException("Cannot get packet sender when not in game!");
    }

    public static void send(class_2960 channelName, class_2540 buf) throws IllegalStateException {
        if (class_310.method_1551().method_1562() != null) {
            class_310.method_1551().method_1562().method_52787(ClientPlayNetworking.createC2SPacket(channelName, buf));
            return;
        }
        throw new IllegalStateException("Cannot send packets when not in game!");
    }

    public static <T extends FabricPacket> void send(T packet) {
        Objects.requireNonNull(packet, "Packet cannot be null");
        Objects.requireNonNull(packet.getType(), "Packet#getType cannot return null");
        if (class_310.method_1551().method_1562() != null) {
            class_310.method_1551().method_1562().method_52787(ClientPlayNetworking.createC2SPacket(packet));
            return;
        }
        throw new IllegalStateException("Cannot send packets when not in game!");
    }

    private ClientPlayNetworking() {
    }

    @FunctionalInterface
    @Environment(value=EnvType.CLIENT)
    public static interface PlayPacketHandler<T extends FabricPacket> {
        public void receive(T var1, class_746 var2, PacketSender var3);
    }

    @FunctionalInterface
    @Environment(value=EnvType.CLIENT)
    public static interface PlayChannelHandler {
        public void receive(class_310 var1, class_634 var2, class_2540 var3, PacketSender var4);
    }

    @Environment(value=EnvType.CLIENT)
    private static interface PlayChannelHandlerProxy<T extends FabricPacket>
    extends PlayChannelHandler {
        public PlayPacketHandler<T> getOriginalHandler();
    }
}

