/*
 * Decompiled with CFR 0.152.
 */
package lol.bai.badpackets.impl.registry;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import lol.bai.badpackets.api.config.ClientConfigPacketReceiver;
import lol.bai.badpackets.api.config.ServerConfigPacketReceiver;
import lol.bai.badpackets.api.play.ClientPlayPacketReceiver;
import lol.bai.badpackets.api.play.ServerPlayPacketReceiver;
import lol.bai.badpackets.impl.Constants;
import lol.bai.badpackets.impl.handler.AbstractPacketHandler;
import net.minecraft.class_2960;
import net.minecraft.class_8710;

public class ChannelRegistry<T> {
    private static final Set<class_2960> RESERVED_CHANNELS = Set.of(Constants.CHANNEL_SYNC, Constants.MC_REGISTER_CHANNEL, Constants.MC_UNREGISTER_CHANNEL);
    public static final ChannelRegistry<ClientConfigPacketReceiver<class_8710>> CONFIG_S2C = new ChannelRegistry(RESERVED_CHANNELS);
    public static final ChannelRegistry<ServerConfigPacketReceiver<class_8710>> CONFIG_C2S = new ChannelRegistry(RESERVED_CHANNELS);
    public static final ChannelRegistry<ClientPlayPacketReceiver<class_8710>> PLAY_S2C = new ChannelRegistry(RESERVED_CHANNELS);
    public static final ChannelRegistry<ServerPlayPacketReceiver<class_8710>> PLAY_C2S = new ChannelRegistry(RESERVED_CHANNELS);
    public final Map<class_2960, T> channels = new HashMap<class_2960, T>();
    private final Set<class_2960> reservedChannels;
    private final Set<AbstractPacketHandler<T>> handlers = new HashSet<AbstractPacketHandler<T>>();

    public ChannelRegistry(Set<class_2960> reservedChannels) {
        this.reservedChannels = reservedChannels;
    }

    public void register(class_2960 id, T receiver) {
        if (this.reservedChannels.contains(id)) {
            throw new IllegalArgumentException("Reserved channel id " + id);
        }
        this.channels.put(id, receiver);
        for (AbstractPacketHandler<T> handler : this.handlers) {
            handler.onRegister(id);
        }
    }

    public void addHandler(AbstractPacketHandler<T> handler) {
        this.handlers.add(handler);
    }

    public void removeHandler(AbstractPacketHandler<T> handler) {
        this.handlers.remove(handler);
    }
}

