/*
 * Decompiled with CFR 0.152.
 */
package lol.bai.badpackets.impl.handler;

import io.netty.buffer.Unpooled;
import java.nio.charset.StandardCharsets;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import lol.bai.badpackets.api.PacketSender;
import lol.bai.badpackets.impl.Constants;
import lol.bai.badpackets.impl.payload.UntypedPayload;
import lol.bai.badpackets.impl.registry.ChannelRegistry;
import net.minecraft.class_2535;
import net.minecraft.class_2540;
import net.minecraft.class_2596;
import net.minecraft.class_2960;
import net.minecraft.class_7648;
import net.minecraft.class_8710;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractPacketHandler<T>
implements PacketSender {
    protected final ChannelRegistry<T> registry;
    protected final Logger logger;
    private final Function<class_8710, class_2596<?>> packetFactory;
    private final Set<class_2960> sendableChannels = new HashSet<class_2960>();
    private final class_2535 connection;
    private boolean initialized = false;

    protected AbstractPacketHandler(String desc, ChannelRegistry<T> registry, Function<class_8710, class_2596<?>> packetFactory, class_2535 connection) {
        this.logger = LogManager.getLogger((String)desc);
        this.registry = registry;
        this.packetFactory = packetFactory;
        this.connection = connection;
        registry.addHandler(this);
    }

    private void receiveChannelSyncPacket(class_2540 buf) {
        switch (buf.readByte()) {
            case 0: {
                this.sendableChannels.add(buf.method_10810());
                break;
            }
            case 1: {
                int groupSize = buf.method_10816();
                for (int i = 0; i < groupSize; ++i) {
                    String namespace = buf.method_19772();
                    int pathSize = buf.method_10816();
                    for (int j = 0; j < pathSize; ++j) {
                        String path = buf.method_19772();
                        this.sendableChannels.add(new class_2960(namespace, path));
                    }
                }
                this.onInitialChannelSyncPacketReceived();
            }
        }
    }

    public static void addChannelSyncReader(Map<class_2960, class_2540.class_7461<? extends class_8710>> map) {
        map.put(Constants.CHANNEL_SYNC, UntypedPayload.reader(Constants.CHANNEL_SYNC));
    }

    public boolean receive(class_8710 payload) {
        class_2960 id = payload.comp_1678();
        if (id.equals((Object)Constants.CHANNEL_SYNC)) {
            UntypedPayload untyped = (UntypedPayload)payload;
            this.receiveChannelSyncPacket(untyped.buffer());
            return true;
        }
        if (this.registry.channels.containsKey(id)) {
            try {
                this.receive(this.registry.channels.get(id), payload);
            }
            catch (Throwable t) {
                this.logger.error("Error when receiving packet {}", (Object)id, (Object)t);
                throw t;
            }
            return true;
        }
        return false;
    }

    protected abstract void onInitialChannelSyncPacketReceived();

    protected abstract void receive(T var1, class_8710 var2);

    public void sendInitialChannelSyncPacket() {
        if (!this.initialized) {
            this.initialized = true;
            this.sendVanillaChannelRegisterPacket(Set.of(Constants.CHANNEL_SYNC));
            class_2540 buf = new class_2540(Unpooled.buffer());
            buf.method_52997(1);
            Map<String, List<class_2960>> group = this.registry.channels.keySet().stream().collect(Collectors.groupingBy(class_2960::method_12836));
            buf.method_10804(group.size());
            for (Map.Entry<String, List<class_2960>> entry : group.entrySet()) {
                buf.method_10814(entry.getKey());
                buf.method_10804(entry.getValue().size());
                for (class_2960 value : entry.getValue()) {
                    buf.method_10814(value.method_12832());
                }
            }
            this.send(Constants.CHANNEL_SYNC, buf);
            this.sendVanillaChannelRegisterPacket(this.registry.channels.keySet());
        }
    }

    public void onRegister(class_2960 id) {
        class_2540 buf = new class_2540(Unpooled.buffer());
        buf.method_52997(0);
        buf.method_10812(id);
        this.send(Constants.CHANNEL_SYNC, buf);
        this.sendVanillaChannelRegisterPacket(Set.of(id));
    }

    public void remove() {
        this.registry.removeHandler(this);
    }

    private void sendVanillaChannelRegisterPacket(Set<class_2960> channels) {
        if (!channels.isEmpty()) {
            class_2540 buf = new class_2540(Unpooled.buffer());
            boolean first = true;
            for (class_2960 channel : channels) {
                if (first) {
                    first = false;
                } else {
                    buf.method_52997(0);
                }
                buf.method_52983(channel.toString().getBytes(StandardCharsets.US_ASCII));
            }
            this.connection.method_10743(this.createVanillaRegisterPacket(buf));
        }
    }

    protected abstract class_2596<?> createVanillaRegisterPacket(class_2540 var1);

    @Override
    public void send(class_8710 payload, @Nullable class_7648 callback) {
        this.connection.method_10752(this.packetFactory.apply(payload), callback);
    }

    @Override
    public boolean canSend(class_2960 id) {
        return this.sendableChannels.contains(id);
    }
}

