/*
 * Decompiled with CFR 0.152.
 */
package nl.enjarai.cicada.api.conversation.conditions;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.time.LocalDateTime;
import nl.enjarai.cicada.api.conversation.Conversation;
import nl.enjarai.cicada.api.conversation.conditions.LineCondition;
import nl.enjarai.cicada.api.util.IntRange;

public record DateCondition(IntRange year, IntRange month, IntRange weekDay, IntRange day, IntRange hour, IntRange minute) implements LineCondition
{
    public static final String TYPE = "cicada:date";
    public static final Codec<DateCondition> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)IntRange.CODEC.optionalFieldOf("year", (Object)IntRange.ANY).forGetter(DateCondition::year), (App)IntRange.CODEC.optionalFieldOf("month", (Object)IntRange.ANY).forGetter(DateCondition::month), (App)IntRange.CODEC.optionalFieldOf("week_day", (Object)IntRange.ANY).forGetter(DateCondition::weekDay), (App)IntRange.CODEC.optionalFieldOf("day", (Object)IntRange.ANY).forGetter(DateCondition::day), (App)IntRange.CODEC.optionalFieldOf("hour", (Object)IntRange.ANY).forGetter(DateCondition::hour), (App)IntRange.CODEC.optionalFieldOf("minute", (Object)IntRange.ANY).forGetter(DateCondition::minute)).apply((Applicative)instance, DateCondition::new));

    @Override
    public boolean test(Conversation conversation) {
        LocalDateTime now = LocalDateTime.now();
        return this.year.isInRange(now.getYear()) && this.month.isInRange(now.getMonthValue()) && this.weekDay.isInRange(now.getDayOfWeek().getValue()) && this.day.isInRange(now.getDayOfMonth()) && this.hour.isInRange(now.getHour()) && this.minute.isInRange(now.getMinute());
    }

    @Override
    public String getType() {
        return TYPE;
    }
}

