/*
 * Decompiled with CFR 0.152.
 */
package me.bymartrixx.vtd;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.function.Consumer;
import me.bymartrixx.vtd.data.DownloadPackRequestData;
import me.bymartrixx.vtd.data.DownloadPackResponseData;
import me.bymartrixx.vtd.data.Pack;
import me.bymartrixx.vtd.data.RpCategories;
import me.bymartrixx.vtd.data.SharePackRequestData;
import me.bymartrixx.vtd.data.SharePackResponseData;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.minecraft.class_1011;
import net.minecraft.class_1043;
import net.minecraft.class_1044;
import net.minecraft.class_1060;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3262;
import net.minecraft.class_3288;
import net.minecraft.class_3545;
import net.minecraft.class_7367;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicNameValuePair;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VTDMod
implements ClientModInitializer {
    public static final boolean USE_LOCAL_CATEGORIES = false;
    private static final ThreadFactory DOWNLOAD_THREAD_FACTORY = new ThreadFactoryBuilder().setNameFormat("VT Download %d").build();
    private static final ExecutorService DOWNLOAD_EXECUTOR = Executors.newCachedThreadPool(DOWNLOAD_THREAD_FACTORY);
    private static final Gson GSON = new GsonBuilder().registerTypeAdapter(DownloadPackRequestData.class, (Object)new DownloadPackRequestData.Serializer()).registerTypeAdapter(SharePackRequestData.class, (Object)new SharePackRequestData.Serializer()).create();
    public static final String MOD_NAME = "VTDownloader";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"VTDownloader");
    public static final String BASE_URL = "https://vanillatweaks.net";
    public static final String MOD_ID = "vt_downloader";
    public static final String VT_VERSION;
    public static final String VERSION;
    private static HttpClient httpClient;
    public static RpCategories rpCategories;

    private static HttpClient getClient() {
        if (httpClient == null) {
            httpClient = HttpClients.createDefault();
        }
        return httpClient;
    }

    private static String getResourceUri(String resource) {
        resource = !((String)resource).startsWith("/") ? "/" + (String)resource : resource;
        return BASE_URL + (String)resource;
    }

    @Contract(value="_ -> new")
    private static HttpGet createHttpGet(String resource) {
        return new HttpGet(VTDMod.getResourceUri(resource));
    }

    @Contract(value="_ -> new")
    private static HttpPost createHttpPost(String resource) {
        return new HttpPost(VTDMod.getResourceUri(resource));
    }

    public static <R extends HttpRequestBase> HttpResponse executeRequest(R request) throws IOException {
        request.addHeader("User-Agent", "VTDownloader v" + VERSION);
        return VTDMod.getClient().execute(request);
    }

    public static void loadRpCategories() {
        try {
            RpCategories categories = null;
            String file = System.getProperty("vtd.debug.rpCategoriesFile");
            if (categories == null) {
                HttpResponse response = VTDMod.executeRequest(VTDMod.createHttpGet("/assets/resources/json/" + VT_VERSION + "/rpcategories.json"));
                try (BufferedInputStream stream = new BufferedInputStream(response.getEntity().getContent());){
                    categories = (RpCategories)GSON.fromJson((Reader)new InputStreamReader(stream), RpCategories.class);
                }
            }
            if (categories == null) {
                LOGGER.error("Failed to load resource pack categories");
                return;
            }
            rpCategories = categories;
            LOGGER.info("Loaded {} resource pack categories", (Object)rpCategories.getCategories().size());
        }
        catch (IOException e) {
            LOGGER.error("Failed to load resource pack categories", (Throwable)e);
        }
    }

    public static CompletableFuture<Boolean> executePackDownload(DownloadPackRequestData requestData, Consumer<Float> progressCallback, Path downloadPath, @Nullable String userFileName) {
        LOGGER.debug("Downloading resource packs: {}", (Object)GSON.toJson((Object)requestData));
        return ((CompletableFuture)((CompletableFuture)CompletableFuture.supplyAsync(() -> {
            try {
                HttpPost request = VTDMod.createHttpPost("/assets/server/zipresourcepacks.php");
                ArrayList<BasicNameValuePair> params = new ArrayList<BasicNameValuePair>();
                params.add(new BasicNameValuePair("version", VT_VERSION));
                params.add(new BasicNameValuePair("packs", GSON.toJson((Object)requestData)));
                request.setEntity((HttpEntity)new UrlEncodedFormEntity(params));
                return VTDMod.executeRequest(request);
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to execute pack zipping request", e);
            }
        }, DOWNLOAD_EXECUTOR).thenApplyAsync(response -> {
            DownloadPackResponseData downloadPackResponseData;
            progressCallback.accept(Float.valueOf(0.1f));
            int code = response.getStatusLine().getStatusCode();
            if (code / 100 != 2) {
                throw new IllegalStateException("Pack zipping request returned status code " + code);
            }
            BufferedInputStream stream = new BufferedInputStream(response.getEntity().getContent());
            try {
                downloadPackResponseData = (DownloadPackResponseData)GSON.fromJson((Reader)new InputStreamReader(stream), DownloadPackResponseData.class);
            }
            catch (Throwable throwable) {
                try {
                    try {
                        ((InputStream)stream).close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new RuntimeException("Failed to read pack zipping response", e);
                }
            }
            ((InputStream)stream).close();
            return downloadPackResponseData;
        }, (Executor)DOWNLOAD_EXECUTOR)).thenApplyAsync(data -> {
            progressCallback.accept(Float.valueOf(0.3f));
            Object fileName = userFileName != null ? userFileName + ".zip" : data.getFileName();
            try {
                HttpGet request = VTDMod.createHttpGet(data.getLink());
                request.setConfig(RequestConfig.custom().setConnectTimeout(4000).build());
                return new class_3545(fileName, (Object)VTDMod.executeRequest(request));
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to execute pack download request", e);
            }
        }, (Executor)DOWNLOAD_EXECUTOR)).thenApplyAsync(data -> {
            Boolean bl;
            progressCallback.accept(Float.valueOf(0.4f));
            HttpResponse response = (HttpResponse)data.method_15441();
            int code = response.getStatusLine().getStatusCode();
            if (code / 100 != 2) {
                throw new IllegalStateException("Pack download request returned status code " + code);
            }
            String fileName = ((String)data.method_15442()).trim();
            BufferedInputStream stream = new BufferedInputStream(response.getEntity().getContent());
            try {
                bl = Files.copy(stream, downloadPath.resolve(fileName), StandardCopyOption.REPLACE_EXISTING) > 0L;
            }
            catch (Throwable throwable) {
                try {
                    try {
                        ((InputStream)stream).close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new RuntimeException("Failed to read pack download response", e);
                }
            }
            ((InputStream)stream).close();
            return bl;
        }, (Executor)DOWNLOAD_EXECUTOR);
    }

    public static CompletableFuture<String> executeShare(SharePackRequestData requestData) {
        return ((CompletableFuture)CompletableFuture.supplyAsync(() -> {
            try {
                HttpPost request = VTDMod.createHttpPost("/assets/server/sharecode.php");
                List<BasicNameValuePair> params = Collections.singletonList(new BasicNameValuePair("data", GSON.toJson((Object)requestData)));
                request.setEntity((HttpEntity)new UrlEncodedFormEntity(params));
                return VTDMod.executeRequest(request);
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to execute pack share request", e);
            }
        }).thenApplyAsync(response -> {
            SharePackResponseData sharePackResponseData;
            int code = response.getStatusLine().getStatusCode();
            if (code / 100 != 2) {
                throw new IllegalStateException("Pack share request returned status code " + code);
            }
            BufferedInputStream stream = new BufferedInputStream(response.getEntity().getContent());
            try {
                sharePackResponseData = (SharePackResponseData)GSON.fromJson((Reader)new InputStreamReader(stream), SharePackResponseData.class);
            }
            catch (Throwable throwable) {
                try {
                    try {
                        ((InputStream)stream).close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new RuntimeException("Failed to read pack share response", e);
                }
            }
            ((InputStream)stream).close();
            return sharePackResponseData;
        })).thenApplyAsync(data -> {
            if (data.getResult().equals("error")) {
                throw new IllegalStateException("There was an error sharing the pack");
            }
            return data.getCode();
        });
    }

    public static CompletableFuture<Boolean> downloadIcon(Pack pack) {
        return CompletableFuture.supplyAsync(() -> {
            try {
                return VTDMod.executeRequest(VTDMod.createHttpPost(String.format("/assets/resources/icons/resourcepacks/%s/%s.png", VT_VERSION, pack.getIcon())));
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to execute icon download request", e);
            }
        }, DOWNLOAD_EXECUTOR).thenApplyAsync(response -> {
            Boolean bl;
            block9: {
                int code = response.getStatusLine().getStatusCode();
                if (code / 100 != 2) {
                    throw new IllegalStateException("Icon download request returned status code " + code);
                }
                InputStream stream = response.getEntity().getContent();
                try {
                    class_1060 textureManager = class_310.method_1551().method_1531();
                    class_2960 id = VTDMod.getIconId(pack);
                    class_1043 icon = new class_1043(class_1011.method_4309((InputStream)stream));
                    textureManager.method_4616(id, (class_1044)icon);
                    textureManager.method_22813(id);
                    bl = true;
                    if (stream == null) break block9;
                }
                catch (Throwable throwable) {
                    try {
                        if (stream != null) {
                            try {
                                stream.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        throw new RuntimeException("Failed to read icon download response", e);
                    }
                }
                stream.close();
            }
            return bl;
        });
    }

    @Contract(value="_ -> new")
    public static class_2960 getIconId(Pack pack) {
        return new class_2960(MOD_ID, pack.getId().toLowerCase(Locale.ROOT));
    }

    public static CompletableFuture<List<String>> readResourcePackData(class_3288 profile) {
        return CompletableFuture.supplyAsync(() -> {
            try (class_3262 resourcePack = profile.method_14458();){
                List list;
                block18: {
                    InputStream stream;
                    block16: {
                        List<String> list2;
                        block17: {
                            class_7367 fileStream = resourcePack.method_14410(new String[]{"Selected Packs.txt"});
                            stream = fileStream != null ? (InputStream)fileStream.get() : null;
                            try {
                                if (stream == null) break block16;
                                list2 = VTDMod.readSelectedPacks(new BufferedReader(new InputStreamReader(stream)));
                                if (stream == null) break block17;
                            }
                            catch (Throwable throwable) {
                                if (stream != null) {
                                    try {
                                        stream.close();
                                    }
                                    catch (Throwable throwable2) {
                                        throwable.addSuppressed(throwable2);
                                    }
                                }
                                throw throwable;
                            }
                            stream.close();
                        }
                        return list2;
                    }
                    list = Collections.emptyList();
                    if (stream == null) break block18;
                    stream.close();
                }
                return list;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        });
    }

    public static List<String> readSelectedPacks(BufferedReader reader) throws IOException {
        String line;
        ArrayList<String> selectedPacks = new ArrayList<String>();
        int count = 0;
        while ((line = reader.readLine()) != null) {
            if (count == 0 && line.trim().equals("Vanilla Tweaks Resource Pack")) {
                ++count;
                continue;
            }
            if (count == 1 && line.trim().startsWith("Version:")) {
                if (!line.substring(8).trim().equals(VT_VERSION)) {
                    throw new IllegalArgumentException("Unsupported pack version");
                }
                ++count;
                continue;
            }
            if (count == 2 && line.trim().startsWith("Packs:")) {
                ++count;
                continue;
            }
            if (count > 2) {
                if (!line.isBlank()) {
                    selectedPacks.add(line.trim());
                }
                ++count;
                continue;
            }
            throw new IllegalStateException("Invalid selected packs file");
        }
        return selectedPacks;
    }

    public void onInitializeClient() {
        LOGGER.info("VTDownloader {}, using Vanilla Tweaks {}", (Object)VERSION, (Object)VT_VERSION);
        VTDMod.loadRpCategories();
    }

    static {
        String version = "2.0.7";
        String vtVersion = "1.20";
        Optional container = FabricLoader.getInstance().getModContainer(MOD_ID);
        if (container.isPresent()) {
            vtVersion = ((ModContainer)container.get()).getMetadata().getCustomValue("vt_version").getAsString();
        }
        VERSION = version;
        VT_VERSION = vtVersion;
    }
}

