/*
 * Decompiled with CFR 0.152.
 */
package dev.yurisuika.raised.client.option;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.io.FileWriter;
import java.nio.file.Files;
import net.fabricmc.loader.api.FabricLoader;

public class RaisedConfig {
    public static File file = new File(FabricLoader.getInstance().getConfigDir().toFile(), "raised.json");
    public static Gson gson = new GsonBuilder().setPrettyPrinting().create();
    public static Config config = new Config();

    public static void saveConfig() {
        try {
            FileWriter fileWriter = new FileWriter(file);
            fileWriter.write(gson.toJson((Object)RaisedConfig.getConfig()));
            fileWriter.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void loadConfig() {
        try {
            config = file.exists() ? (Config)gson.fromJson(Files.readString(file.toPath()), Config.class) : new Config();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        RaisedConfig.setConfig(config);
    }

    public static void setConfig(Config config) {
        RaisedConfig.config = config;
    }

    public static Config getConfig() {
        return config;
    }

    public static void setHud(int value) {
        RaisedConfig.config.value.hud = value;
        RaisedConfig.saveConfig();
        RaisedConfig.putObjects();
    }

    public static void setChat(int value) {
        RaisedConfig.config.value.chat = value;
        RaisedConfig.saveConfig();
        RaisedConfig.putObjects();
    }

    public static void setShare(boolean value) {
        RaisedConfig.config.toggle.share = value;
        RaisedConfig.saveConfig();
        RaisedConfig.putObjects();
    }

    public static void setSupport(boolean value) {
        RaisedConfig.config.toggle.support = value;
        RaisedConfig.saveConfig();
        RaisedConfig.putObjects();
    }

    public static void setSync(boolean value) {
        RaisedConfig.config.toggle.sync = value;
        RaisedConfig.saveConfig();
    }

    public static int getHud() {
        return RaisedConfig.config.value.hud;
    }

    public static int getChat() {
        if (RaisedConfig.getSync()) {
            return RaisedConfig.config.value.hud;
        }
        return RaisedConfig.config.value.chat;
    }

    public static boolean getShare() {
        return RaisedConfig.config.toggle.share;
    }

    public static boolean getSupport() {
        return RaisedConfig.config.toggle.support;
    }

    public static boolean getSync() {
        return RaisedConfig.config.toggle.sync;
    }

    public static void putObjects() {
        FabricLoader.getInstance().getObjectShare().put("raised:hud", (Object)(RaisedConfig.getShare() ? RaisedConfig.getHud() : 0));
        FabricLoader.getInstance().getObjectShare().put("raised:chat", (Object)(RaisedConfig.getShare() ? RaisedConfig.getChat() : 0));
    }

    public static class Config {
        public Value value = new Value(2, 0);
        public Toggle toggle = new Toggle(true, true, false);

        public static class Value {
            public int hud;
            public int chat;

            public Value(int hud, int chat) {
                this.hud = hud;
                this.chat = chat;
            }
        }

        public static class Toggle {
            public boolean share;
            public boolean support;
            public boolean sync;

            public Toggle(boolean share, boolean support, boolean sync) {
                this.share = share;
                this.support = support;
                this.sync = sync;
            }
        }
    }
}

