/*
 * Decompiled with CFR 0.152.
 */
package com.ishland.c2me.rewrites.chunkio.common;

import com.ibm.asyncutil.util.Either;
import com.ishland.c2me.base.common.GlobalExecutors;
import com.ishland.c2me.base.common.structs.RawByteArrayOutputStream;
import com.ishland.c2me.base.common.util.SneakyThrow;
import com.ishland.c2me.base.mixin.access.IRegionBasedStorage;
import com.ishland.c2me.base.mixin.access.IRegionFile;
import com.ishland.c2me.opts.chunkio.common.ConfigConstants;
import it.unimi.dsi.fastutil.longs.Long2ReferenceLinkedOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArraySet;
import java.io.ByteArrayInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.file.Path;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.LockSupport;
import java.util.function.Function;
import net.minecraft.class_1923;
import net.minecraft.class_2487;
import net.minecraft.class_2505;
import net.minecraft.class_2507;
import net.minecraft.class_2520;
import net.minecraft.class_2861;
import net.minecraft.class_2867;
import net.minecraft.class_6836;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class C2MEStorageThread
extends Thread {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"C2ME Storage");
    private static final AtomicLong SERIAL = new AtomicLong(0L);
    private final AtomicBoolean closing = new AtomicBoolean(false);
    private final CompletableFuture<Void> closeFuture = new CompletableFuture();
    private final class_2867 storage;
    private final Long2ReferenceLinkedOpenHashMap<Either<class_2487, byte[]>> writeBacklog = new Long2ReferenceLinkedOpenHashMap();
    private final Long2ReferenceLinkedOpenHashMap<Either<class_2487, byte[]>> cache = new Long2ReferenceLinkedOpenHashMap();
    private final ConcurrentLinkedQueue<ReadRequest> pendingReadRequests = new ConcurrentLinkedQueue();
    private final ConcurrentLinkedQueue<WriteRequest> pendingWriteRequests = new ConcurrentLinkedQueue();
    private final ConcurrentLinkedQueue<Runnable> pendingTasks = new ConcurrentLinkedQueue();
    private final Executor executor = command -> {
        if (Thread.currentThread() == this) {
            command.run();
        } else {
            this.pendingTasks.add(command);
            LockSupport.unpark(this);
        }
    };
    private final ObjectArraySet<CompletableFuture<Void>> writeFutures = new ObjectArraySet();

    public C2MEStorageThread(Path directory, boolean dsync, String name) {
        this.storage = new class_2867(directory, dsync);
        this.setName("C2ME Storage #%d".formatted(SERIAL.incrementAndGet()));
        this.setDaemon(true);
        this.setUncaughtExceptionHandler((t, e) -> LOGGER.error("Thread %s died".formatted(t), e));
        this.start();
    }

    @Override
    public void run() {
        while (true) {
            boolean hasWork = false;
            hasWork = this.handleTasks() || hasWork;
            hasWork = this.handlePendingWrites() || hasWork;
            hasWork = this.handlePendingReads() || hasWork;
            hasWork = this.writeBacklog() || hasWork;
            this.runWriteFutureGC();
            if (hasWork) continue;
            if (this.closing.get()) {
                this.flush0(true);
                try {
                    this.storage.close();
                }
                catch (Throwable t) {
                    LOGGER.error("Error closing storage", t);
                }
                break;
            }
            LockSupport.parkNanos("Waiting for tasks", 10000000L);
        }
        this.closeFuture.complete(null);
        LOGGER.info("Storage thread {} stopped", (Object)this);
    }

    public CompletableFuture<class_2487> getChunkData(long pos, class_6836 scanner) {
        CompletableFuture<class_2487> future = new CompletableFuture<class_2487>();
        if (this.closing.get()) {
            future.completeExceptionally(new CancellationException());
            return future.thenApply(Function.identity());
        }
        this.pendingReadRequests.add(new ReadRequest(pos, future, scanner));
        LockSupport.unpark(this);
        ((CompletableFuture)future.thenApply(Function.identity())).orTimeout(60L, TimeUnit.SECONDS).exceptionally(throwable -> {
            if (throwable instanceof TimeoutException) {
                LOGGER.warn("Chunk read at pos {} took too long (> 1min)", (Object)new class_1923(pos).method_8324());
            }
            return null;
        });
        return future.thenApply(Function.identity());
    }

    public void setChunkData(long pos, @Nullable class_2487 nbt) {
        this.pendingWriteRequests.add(new WriteRequest(pos, (Either<class_2487, byte[]>)(nbt != null ? Either.left((Object)nbt) : null)));
        LockSupport.unpark(this);
    }

    public void setChunkData(long pos, @Nullable byte[] data) {
        this.pendingWriteRequests.add(new WriteRequest(pos, (Either<class_2487, byte[]>)(data != null ? Either.right((Object)data) : null)));
        LockSupport.unpark(this);
    }

    public CompletableFuture<Void> flush(boolean sync) {
        return CompletableFuture.runAsync(() -> this.flush0(sync), this.executor);
    }

    private void flush0(boolean sync) {
        try {
            do {
                this.runWriteFutureGC();
            } while (this.handleTasks() || this.handlePendingReads() || this.handlePendingWrites() || this.writeBacklog());
            this.flushBacklog();
            if (sync) {
                this.storage.method_26982();
            }
        }
        catch (Throwable t) {
            LOGGER.error("Error flushing storage", t);
        }
    }

    public CompletableFuture<Void> close() {
        this.closing.set(true);
        LockSupport.unpark(this);
        return this.closeFuture.thenApply(Function.identity());
    }

    private boolean handleTasks() {
        Runnable runnable;
        boolean hasWork = false;
        while ((runnable = this.pendingTasks.poll()) != null) {
            hasWork = true;
            try {
                runnable.run();
            }
            catch (Throwable t) {
                LOGGER.error("Error while executing task", t);
            }
        }
        return hasWork;
    }

    private boolean handlePendingWrites() {
        WriteRequest writeRequest;
        boolean hasWork = false;
        while ((writeRequest = this.pendingWriteRequests.poll()) != null) {
            hasWork = true;
            this.cache.put(writeRequest.pos, writeRequest.nbt);
            this.writeBacklog.put(writeRequest.pos, writeRequest.nbt);
        }
        return hasWork;
    }

    private boolean handlePendingReads() {
        boolean hasWork = false;
        while (!this.pendingReadRequests.isEmpty()) {
            ReadRequest readRequest = this.pendingReadRequests.poll();
            hasWork = true;
            assert (readRequest != null);
            long pos = readRequest.pos;
            CompletableFuture<class_2487> future = readRequest.future;
            class_6836 scanner = readRequest.scanner;
            if (this.cache.containsKey(pos)) {
                Either cached = (Either)this.cache.get(pos);
                if (cached == null) {
                    future.complete(null);
                    continue;
                }
                if (cached.left().isPresent()) {
                    if (scanner != null) {
                        GlobalExecutors.executor.execute(() -> {
                            try {
                                ((class_2487)cached.left().get()).method_39876(scanner);
                                future.complete(null);
                            }
                            catch (Throwable t) {
                                future.completeExceptionally(t);
                            }
                        });
                        continue;
                    }
                    future.complete((class_2487)cached.left().get());
                    continue;
                }
                ((CompletableFuture)CompletableFuture.supplyAsync(() -> {
                    try {
                        DataInputStream input = new DataInputStream(new ByteArrayInputStream((byte[])cached.right().get()));
                        if (scanner != null) {
                            class_2507.method_39855((DataInput)input, (class_6836)scanner, (class_2505)class_2505.method_53898());
                            return null;
                        }
                        class_2487 compound = class_2507.method_10627((DataInput)input);
                        return compound;
                    }
                    catch (IOException e) {
                        SneakyThrow.sneaky((Throwable)e);
                        return null;
                    }
                }, GlobalExecutors.executor).thenAccept(future::complete)).exceptionally(throwable -> {
                    future.completeExceptionally((Throwable)throwable);
                    return null;
                });
                continue;
            }
            this.scheduleChunkRead(pos, future, scanner);
        }
        return hasWork;
    }

    private boolean writeBacklog() {
        if (!this.writeBacklog.isEmpty()) {
            long pos = this.writeBacklog.firstLongKey();
            Either nbt = (Either)this.writeBacklog.removeFirst();
            this.writeChunk(pos, (Either<class_2487, byte[]>)nbt);
            return true;
        }
        return false;
    }

    private void runWriteFutureGC() {
        this.writeFutures.removeIf(CompletableFuture::isDone);
    }

    private void flushBacklog() {
        while (!this.writeFutures.isEmpty()) {
            while (this.writeBacklog()) {
            }
            this.runWriteFutureGC();
            CompletableFuture<Void> allFuture = CompletableFuture.allOf((CompletableFuture[])this.writeFutures.stream().map(future -> future.exceptionally(unused -> null)).distinct().toArray(CompletableFuture[]::new));
            while (!allFuture.isDone()) {
                this.handleTasks();
            }
            this.runWriteFutureGC();
        }
    }

    private void scheduleChunkRead(long pos, CompletableFuture<class_2487> future, class_6836 scanner) {
        try {
            class_1923 pos1 = new class_1923(pos);
            class_2861 regionFile = ((IRegionBasedStorage)this.storage).invokeGetRegionFile(pos1);
            DataInputStream chunkInputStream = regionFile.method_21873(pos1);
            if (chunkInputStream == null) {
                future.complete(null);
                return;
            }
            CompletableFuture.supplyAsync(() -> {
                try (DataInputStream inputStream = chunkInputStream;){
                    if (scanner != null) {
                        class_2507.method_39855((DataInput)inputStream, (class_6836)scanner, (class_2505)class_2505.method_53898());
                        class_2487 class_24873 = null;
                        return class_24873;
                    }
                    class_2487 class_24872 = class_2507.method_10627((DataInput)inputStream);
                    return class_24872;
                }
                catch (Throwable t) {
                    SneakyThrow.sneaky((Throwable)t);
                    return null;
                }
            }, GlobalExecutors.executor).handle((compound, throwable) -> {
                if (throwable != null) {
                    future.completeExceptionally((Throwable)throwable);
                } else {
                    future.complete((class_2487)compound);
                }
                return null;
            });
        }
        catch (Throwable t) {
            future.completeExceptionally(t);
        }
    }

    private void writeChunk(long pos, Either<class_2487, byte[]> nbt) {
        if (nbt == null) {
            if (this.cache.get(pos) == null) {
                try {
                    class_1923 pos1 = new class_1923(pos);
                    class_2861 regionFile = ((IRegionBasedStorage)this.storage).invokeGetRegionFile(pos1);
                    regionFile.method_31740(pos1);
                }
                catch (Throwable t) {
                    LOGGER.error("Error writing chunk %s".formatted(new class_1923(pos)), t);
                }
                this.cache.remove(pos);
            }
        } else {
            CompletionStage future = ((CompletableFuture)CompletableFuture.supplyAsync(() -> {
                try {
                    RawByteArrayOutputStream out = new RawByteArrayOutputStream(8096);
                    out.write(0);
                    out.write(0);
                    out.write(0);
                    out.write(0);
                    out.write(ConfigConstants.CHUNK_STREAM_VERSION.method_21882());
                    try (DataOutputStream dataOutputStream = new DataOutputStream(ConfigConstants.CHUNK_STREAM_VERSION.method_21886((OutputStream)out));){
                        if (nbt.left().isPresent()) {
                            class_2507.method_10631((class_2520)((class_2520)nbt.left().get()), (DataOutput)dataOutputStream);
                        } else {
                            dataOutputStream.write((byte[])nbt.right().get());
                        }
                    }
                    return out;
                }
                catch (Throwable t) {
                    SneakyThrow.sneaky((Throwable)t);
                    return null;
                }
            }, GlobalExecutors.executor).thenAcceptAsync(bytes -> {
                if (nbt == this.cache.get(pos)) {
                    try {
                        class_1923 pos1 = new class_1923(pos);
                        class_2861 regionFile = ((IRegionBasedStorage)this.storage).invokeGetRegionFile(pos1);
                        ByteBuffer byteBuffer = bytes.asByteBuffer();
                        byteBuffer.putInt(0, bytes.size() - 5 + 1);
                        ((IRegionFile)regionFile).invokeWriteChunk(pos1, byteBuffer);
                    }
                    catch (Throwable t) {
                        SneakyThrow.sneaky((Throwable)t);
                    }
                    this.cache.remove(pos);
                }
            }, this.executor)).handleAsync((unused, throwable) -> {
                if (throwable != null) {
                    LOGGER.error("Error writing chunk %s".formatted(new class_1923(pos)), throwable);
                }
                return null;
            }, this.executor);
            this.writeFutures.add((Object)future);
        }
    }

    private record ReadRequest(long pos, CompletableFuture<class_2487> future, @Nullable class_6836 scanner) {
    }

    private record WriteRequest(long pos, Either<class_2487, byte[]> nbt) {
    }
}

