/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.gbuffer_overrides.matching;

public class InputAvailability {
    public static final int NUM_VALUES = 8;
    public final boolean texture;
    public final boolean lightmap;
    public final boolean overlay;

    public InputAvailability(boolean bl, boolean bl2, boolean bl3) {
        this.texture = bl;
        this.lightmap = bl2;
        this.overlay = bl3;
    }

    public InputAvailability withoutOverlay() {
        return new InputAvailability(this.texture, this.lightmap, false);
    }

    public static InputAvailability unpack(int n) {
        return new InputAvailability((n & 1) == 1, (n & 2) == 2, (n & 4) == 4);
    }

    public int pack() {
        int n = 0;
        if (this.overlay) {
            n |= 4;
        }
        if (this.lightmap) {
            n |= 2;
        }
        if (this.texture) {
            n |= 1;
        }
        return n;
    }

    public String toString() {
        return "InputAvailability{texture=" + this.texture + ", lightmap=" + this.lightmap + ", overlay=" + this.overlay + "}";
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + (this.texture ? 1231 : 1237);
        n = 31 * n + (this.lightmap ? 1231 : 1237);
        n = 31 * n + (this.overlay ? 1231 : 1237);
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        InputAvailability inputAvailability = (InputAvailability)object;
        if (this.texture != inputAvailability.texture) {
            return false;
        }
        if (this.lightmap != inputAvailability.lightmap) {
            return false;
        }
        return this.overlay == inputAvailability.overlay;
    }
}

