/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.mixin.client.message;

import com.mojang.authlib.GameProfile;
import java.time.Instant;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.message.v1.ClientReceiveMessageEvents;
import net.minecraft.class_2556;
import net.minecraft.class_2561;
import net.minecraft.class_7471;
import net.minecraft.class_7594;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Environment(value=EnvType.CLIENT)
@Mixin(value={class_7594.class})
public abstract class MessageHandlerMixin {
    @Inject(method={"processChatMessageInternal"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/gui/hud/InGameHud;getChatHud()Lnet/minecraft/client/gui/hud/ChatHud;", ordinal=0)}, cancellable=true)
    private void fabric_onSignedChatMessage(class_2556.class_7602 params, class_7471 message, class_2561 decorated, GameProfile sender, boolean onlyShowSecureChat, Instant receptionTimestamp, CallbackInfoReturnable<Boolean> cir) {
        this.fabric_onChatMessage(decorated, message, sender, params, receptionTimestamp, cir);
    }

    @Inject(method={"processChatMessageInternal"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/gui/hud/InGameHud;getChatHud()Lnet/minecraft/client/gui/hud/ChatHud;", ordinal=1)}, cancellable=true)
    private void fabric_onFilteredSignedChatMessage(class_2556.class_7602 params, class_7471 message, class_2561 decorated, GameProfile sender, boolean onlyShowSecureChat, Instant receptionTimestamp, CallbackInfoReturnable<Boolean> cir) {
        class_2561 filtered = message.comp_981().method_46256(message.method_44862());
        if (filtered != null) {
            this.fabric_onChatMessage(params.method_44837(filtered), message, sender, params, receptionTimestamp, cir);
        }
    }

    @Inject(method={"method_45745"}, at={@At(value="HEAD")}, cancellable=true)
    private void fabric_onProfilelessChatMessage(class_2556.class_7602 params, class_2561 content, Instant receptionTimestamp, CallbackInfoReturnable<Boolean> cir) {
        this.fabric_onChatMessage(params.method_44837(content), null, null, params, receptionTimestamp, cir);
    }

    @Unique
    private void fabric_onChatMessage(class_2561 message, @Nullable class_7471 signedMessage, @Nullable GameProfile sender, class_2556.class_7602 params, Instant receptionTimestamp, CallbackInfoReturnable<Boolean> cir) {
        if (((ClientReceiveMessageEvents.AllowChat)ClientReceiveMessageEvents.ALLOW_CHAT.invoker()).allowReceiveChatMessage(message, signedMessage, sender, params, receptionTimestamp)) {
            ((ClientReceiveMessageEvents.Chat)ClientReceiveMessageEvents.CHAT.invoker()).onReceiveChatMessage(message, signedMessage, sender, params, receptionTimestamp);
        } else {
            ((ClientReceiveMessageEvents.ChatCanceled)ClientReceiveMessageEvents.CHAT_CANCELED.invoker()).onReceiveChatMessageCanceled(message, signedMessage, sender, params, receptionTimestamp);
            cir.setReturnValue((Object)false);
        }
    }

    @Inject(method={"onGameMessage"}, at={@At(value="HEAD")}, cancellable=true)
    private void fabric_allowGameMessage(class_2561 message, boolean overlay, CallbackInfo ci) {
        if (!((ClientReceiveMessageEvents.AllowGame)ClientReceiveMessageEvents.ALLOW_GAME.invoker()).allowReceiveGameMessage(message, overlay)) {
            ((ClientReceiveMessageEvents.GameCanceled)ClientReceiveMessageEvents.GAME_CANCELED.invoker()).onReceiveGameMessageCanceled(message, overlay);
            ci.cancel();
        }
    }

    @ModifyVariable(method={"onGameMessage"}, at=@At(value="LOAD", ordinal=0), ordinal=0, argsOnly=true)
    private class_2561 fabric_modifyGameMessage(class_2561 message, class_2561 message1, boolean overlay) {
        message = ((ClientReceiveMessageEvents.ModifyGame)ClientReceiveMessageEvents.MODIFY_GAME.invoker()).modifyReceivedGameMessage(message, overlay);
        ((ClientReceiveMessageEvents.Game)ClientReceiveMessageEvents.GAME.invoker()).onReceiveGameMessage(message, overlay);
        return message;
    }
}

