/*
 * Decompiled with CFR 0.152.
 */
package com.ishland.c2me.notickvd.common;

import com.ishland.c2me.base.common.GlobalExecutors;
import com.ishland.c2me.notickvd.common.NormalTicketDistanceMap;
import com.ishland.c2me.notickvd.common.PlayerNoTickDistanceMap;
import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import it.unimi.dsi.fastutil.longs.LongSets;
import java.util.ArrayList;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;
import net.minecraft.class_1923;
import net.minecraft.class_3204;
import net.minecraft.class_3228;
import net.minecraft.class_3898;
import org.threadly.concurrent.NoThreadScheduler;

public class NoTickSystem {
    private final PlayerNoTickDistanceMap playerNoTickDistanceMap;
    private final NormalTicketDistanceMap normalTicketDistanceMap;
    private final class_3204 chunkTicketManager;
    private final ConcurrentLinkedQueue<Runnable> pendingActionsOnScheduler = new ConcurrentLinkedQueue();
    final ConcurrentLinkedQueue<Runnable> mainBeforeTicketTicks = new ConcurrentLinkedQueue();
    final ConcurrentLinkedQueue<Runnable> mainAfterTicketTicks = new ConcurrentLinkedQueue();
    final NoThreadScheduler noThreadScheduler = new NoThreadScheduler();
    private final AtomicBoolean isTicking = new AtomicBoolean();
    final Executor executor = GlobalExecutors.asyncScheduler;
    private volatile LongSet noTickOnlyChunksSnapshot = LongSets.EMPTY_SET;
    private volatile boolean pendingPurge = false;
    private volatile long age = 0L;

    public NoTickSystem(class_3204 chunkTicketManager) {
        this.chunkTicketManager = chunkTicketManager;
        this.playerNoTickDistanceMap = new PlayerNoTickDistanceMap(chunkTicketManager, this);
        this.normalTicketDistanceMap = new NormalTicketDistanceMap(chunkTicketManager);
    }

    public void onTicketAdded(long position, class_3228<?> ticket) {
        this.pendingActionsOnScheduler.add(() -> this.normalTicketDistanceMap.addTicket(position, ticket));
    }

    public void onTicketRemoved(long position, class_3228<?> ticket) {
        this.pendingActionsOnScheduler.add(() -> this.normalTicketDistanceMap.removeTicket(position, ticket));
    }

    public void addPlayerSource(class_1923 chunkPos) {
        this.pendingActionsOnScheduler.add(() -> this.playerNoTickDistanceMap.addSource(chunkPos));
    }

    public void removePlayerSource(class_1923 chunkPos) {
        this.pendingActionsOnScheduler.add(() -> this.playerNoTickDistanceMap.removeSource(chunkPos));
    }

    public void setNoTickViewDistance(int viewDistance) {
        this.pendingActionsOnScheduler.add(() -> this.playerNoTickDistanceMap.setViewDistance(viewDistance));
    }

    public void tickScheduler() {
        this.noThreadScheduler.tick(Throwable::printStackTrace);
    }

    public void beforeTicketTicks() {
        this.drainQueue(this.mainBeforeTicketTicks);
    }

    public void afterTicketTicks() {
        this.drainQueue(this.mainAfterTicketTicks);
    }

    public void tick(class_3898 tacs) {
        this.tickScheduler();
        this.scheduleTick(tacs);
    }

    private void scheduleTick(class_3898 tacs) {
        if (this.isTicking.compareAndSet(false, true)) {
            Runnable r;
            ArrayList<Runnable> tasks = new ArrayList<Runnable>(this.pendingActionsOnScheduler.size() + 3);
            while ((r = this.pendingActionsOnScheduler.poll()) != null) {
                tasks.add(r);
            }
            this.executor.execute(() -> {
                boolean hasNoTickTicketUpdates;
                for (Runnable task : tasks) {
                    try {
                        task.run();
                    }
                    catch (Throwable t) {
                        t.printStackTrace();
                    }
                }
                if (this.pendingPurge) {
                    this.normalTicketDistanceMap.purge(this.age);
                    hasNoTickTicketUpdates = this.playerNoTickDistanceMap.runPendingTicketUpdates(tacs);
                } else {
                    hasNoTickTicketUpdates = false;
                }
                boolean hasNormalTicketUpdates = this.normalTicketDistanceMap.update();
                boolean hasNoTickUpdates = this.playerNoTickDistanceMap.update();
                if (hasNormalTicketUpdates || hasNoTickUpdates || hasNoTickTicketUpdates) {
                    LongSet noTickChunks = this.playerNoTickDistanceMap.getChunks();
                    LongSet normalChunks = this.normalTicketDistanceMap.getChunks();
                    LongOpenHashSet longs = new LongOpenHashSet(noTickChunks.size() * 3 / 2);
                    LongIterator iterator = noTickChunks.iterator();
                    while (iterator.hasNext()) {
                        long chunk = iterator.nextLong();
                        if (normalChunks.contains(chunk)) continue;
                        longs.add(chunk);
                    }
                    this.noTickOnlyChunksSnapshot = LongSets.unmodifiable((LongSet)longs);
                }
                this.isTicking.set(false);
                if (hasNormalTicketUpdates || hasNoTickUpdates) {
                    this.scheduleTick(tacs);
                }
            });
        }
    }

    private void drainQueue(ConcurrentLinkedQueue<Runnable> queue) {
        Runnable runnable;
        while ((runnable = queue.poll()) != null) {
            try {
                runnable.run();
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
    }

    public void runPurge(long age) {
        this.age = age;
        this.pendingPurge = true;
    }

    public LongSet getNoTickOnlyChunksSnapshot() {
        return this.noTickOnlyChunksSnapshot;
    }

    public int getPendingNoTickTicketUpdatesCount() {
        return this.playerNoTickDistanceMap.getPendingTicketUpdatesCount();
    }
}

