/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.impl.container;

import io.netty.buffer.Unpooled;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import net.fabricmc.fabric.api.container.ContainerFactory;
import net.fabricmc.fabric.api.container.ContainerProviderRegistry;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.fabricmc.fabric.impl.container.ServerPlayerEntitySyncHook;
import net.fabricmc.fabric.mixin.container.ServerPlayerEntityAccessor;
import net.minecraft.class_1657;
import net.minecraft.class_1703;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContainerProviderImpl
implements ContainerProviderRegistry {
    public static final class_2960 OPEN_CONTAINER = new class_2960("fabric", "container/open");
    private static final Logger LOGGER = LoggerFactory.getLogger(ContainerProviderImpl.class);
    private static final Map<class_2960, ContainerFactory<class_1703>> FACTORIES = new HashMap<class_2960, ContainerFactory<class_1703>>();
    private boolean emittedNoSyncHookWarning = false;

    @Override
    public void registerFactory(class_2960 identifier, ContainerFactory<class_1703> factory) {
        if (FACTORIES.containsKey(identifier)) {
            throw new RuntimeException("A factory has already been registered as " + identifier.toString());
        }
        FACTORIES.put(identifier, factory);
    }

    @Override
    public void openContainer(class_2960 identifier, class_1657 player, Consumer<class_2540> writer) {
        if (!(player instanceof class_3222)) {
            LOGGER.warn("Please only use ContainerProviderRegistry.openContainer() with server-sided player entities!");
            return;
        }
        this.openContainer(identifier, (class_3222)player, writer);
    }

    @Override
    public void openContainer(class_2960 identifier, class_3222 player, Consumer<class_2540> writer) {
        int syncId;
        if (player instanceof ServerPlayerEntitySyncHook) {
            ServerPlayerEntitySyncHook serverPlayerEntitySyncHook = (ServerPlayerEntitySyncHook)player;
            syncId = serverPlayerEntitySyncHook.fabric_incrementSyncId();
        } else if (player instanceof ServerPlayerEntityAccessor) {
            if (!this.emittedNoSyncHookWarning) {
                LOGGER.warn("ServerPlayerEntitySyncHook could not be applied - fabric-containers is using a hack!");
                this.emittedNoSyncHookWarning = true;
            }
            syncId = (((ServerPlayerEntityAccessor)player).getScreenHandlerSyncId() + 1) % 100;
            ((ServerPlayerEntityAccessor)player).setScreenHandlerSyncId(syncId);
        } else {
            throw new RuntimeException("Neither ServerPlayerEntitySyncHook nor Accessor present! This should not happen!");
        }
        class_2540 buf = new class_2540(Unpooled.buffer());
        buf.method_10812(identifier);
        buf.method_52997(syncId);
        writer.accept(buf);
        player.field_13987.method_14364(ServerPlayNetworking.createS2CPacket((class_2960)OPEN_CONTAINER, (class_2540)buf));
        class_2540 clonedBuf = new class_2540(buf.duplicate());
        clonedBuf.method_10810();
        clonedBuf.readUnsignedByte();
        Object screenHandler = this.createContainer(syncId, identifier, (class_1657)player, clonedBuf);
        if (screenHandler == null) {
            return;
        }
        player.field_7512 = screenHandler;
        ((ServerPlayerEntityAccessor)player).callOnScreenHandlerOpened((class_1703)screenHandler);
    }

    public <C extends class_1703> C createContainer(int syncId, class_2960 identifier, class_1657 player, class_2540 buf) {
        ContainerFactory<class_1703> factory = FACTORIES.get(identifier);
        if (factory == null) {
            LOGGER.error("No container factory found for {}!", (Object)identifier.toString());
            return null;
        }
        return (C)factory.create(syncId, identifier, player, buf);
    }
}

