/*
 * Decompiled with CFR 0.152.
 */
package traben.entity_texture_features.utils;

import it.unimi.dsi.fastutil.objects.Object2ObjectLinkedOpenHashMap;
import org.jetbrains.annotations.Nullable;
import traben.entity_texture_features.ETFClientCommon;
import traben.entity_texture_features.texture_handlers.ETFManager;
import traben.entity_texture_features.utils.ETFCacheKey;

public class ETFLruCache<X, Y> {
    final Object2ObjectLinkedOpenHashMap<X, Y> cache = new Object2ObjectLinkedOpenHashMap();
    final int capacity = 2048;

    public boolean containsKey(X key) {
        return this.cache.containsKey(key);
    }

    @Nullable
    public Y get(X key) {
        return (Y)this.cache.getAndMoveToFirst(key);
    }

    public void put(X key, Y value) {
        Object lastKey;
        double d = this.cache.size();
        double d2 = ETFClientCommon.ETFConfigData.advanced_IncreaseCacheSizeModifier > 1.0 ? ETFClientCommon.ETFConfigData.advanced_IncreaseCacheSizeModifier : 1.0;
        if (d >= 2048.0 * d2 && !(lastKey = this.cache.lastKey()).equals(key)) {
            if (lastKey instanceof ETFCacheKey) {
                ETFCacheKey ETFKey = (ETFCacheKey)lastKey;
                ETFManager.getInstance().removeThisEntityDataFromAllStorage(ETFKey);
            }
            this.cache.remove(lastKey);
        }
        this.cache.putAndMoveToFirst(key, value);
    }

    public int size() {
        return this.cache.size();
    }

    public void removeEntryOnly(X key) {
        this.cache.remove(key);
    }

    public String toString() {
        return this.cache.toString();
    }
}

