/*
 * Decompiled with CFR 0.152.
 */
package traben.entity_texture_features.texture_handlers;

import java.io.FileInputStream;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.HashSet;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import net.minecraft.class_1011;
import net.minecraft.class_1046;
import net.minecraft.class_156;
import net.minecraft.class_1657;
import net.minecraft.class_1664;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1921;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3879;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_5253;
import net.minecraft.class_5598;
import net.minecraft.class_591;
import net.minecraft.class_742;
import net.minecraft.class_918;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import traben.entity_texture_features.ETFClientCommon;
import traben.entity_texture_features.config.screens.ETFConfigScreenSkinTool;
import traben.entity_texture_features.entity_handlers.ETFPlayerEntity;
import traben.entity_texture_features.entity_handlers.ETFPlayerEntityWrapper;
import traben.entity_texture_features.mixin.accessor.FileCacheAccessor;
import traben.entity_texture_features.mixin.accessor.PlayerSkinProviderAccessor;
import traben.entity_texture_features.mixin.accessor.PlayerSkinTextureAccessor;
import traben.entity_texture_features.texture_handlers.ETFCustomPlayerFeatureModel;
import traben.entity_texture_features.texture_handlers.ETFManager;
import traben.entity_texture_features.texture_handlers.ETFTexture;
import traben.entity_texture_features.utils.ETFUtils2;

public class ETFPlayerTexture {
    public static final String SKIN_NAMESPACE = "etf_skin";
    public static final UUID Dev = UUID.fromString("fd22e573-178c-415a-94fe-e476b328abfd");
    public static final UUID Wife = UUID.fromString("cab7d2e2-519f-4b34-afbd-b65f4542b8a1");
    private static final class_2960 villagerTexture = new class_2960("textures/entity/villager/villager.png");
    public static class_1011 clientPlayerOriginalSkinImageForTool = null;
    public class_2960 baseEnchantIdentifier = null;
    public class_2960 baseEnchantBlinkIdentifier = null;
    public class_2960 baseEnchantBlink2Identifier = null;
    public class_2960 etfCapeIdentifier = null;
    public class_2960 texturedNoseIdentifier = null;
    public class_2960 texturedNoseIdentifierEmissive = null;
    public class_2960 texturedNoseIdentifierEnchanted = null;
    public boolean hasVillagerNose = false;
    public boolean hasFeatures = false;
    public int coatStyle = 0;
    public int coatLength = 1;
    public int blinkType = 0;
    public int blinkHeight = 1;
    public boolean hasEmissives = false;
    public boolean hasEnchant = false;
    public ETFTexture etfTextureOfFinalBaseSkin;
    public ETFConfigScreenSkinTool.CapeType capeType = ETFConfigScreenSkinTool.CapeType.NONE;
    public ETFConfigScreenSkinTool.NoseType noseType = ETFConfigScreenSkinTool.NoseType.NONE;
    ETFPlayerEntity player;
    private ETFCustomPlayerFeatureModel<class_1657> customPlayerModel;
    private boolean isTextureReady = false;
    private class_1011 originalSkin;
    private class_1011 originalCape;
    private class_2960 coatIdentifier = null;
    private class_2960 coatEmissiveIdentifier = null;
    private class_2960 coatEnchantedIdentifier = null;
    private int[] enchantCapeBounds = null;
    private int[] emissiveCapeBounds = null;
    private class_2960 etfCapeEmissiveIdentifier = null;
    private class_2960 etfCapeEnchantedIdentifier = null;
    private class_2960 normalVanillaSkinIdentifier = null;
    private boolean hasFatCoat = false;
    public boolean wasForcedSolid = false;

    ETFPlayerTexture(ETFPlayerEntity player, class_2960 rendererGivenSkin) {
        this.player = player;
        this.normalVanillaSkinIdentifier = rendererGivenSkin;
        if (player instanceof ETFPlayerEntityWrapper) {
            this.checkTexture(false);
        } else {
            try {
                class_1046 skin = (class_1046)((FileCacheAccessor)((PlayerSkinProviderAccessor)class_310.method_1551().method_1582()).getSkinCache()).getTextureManager().method_34590(rendererGivenSkin, null);
                FileInputStream fileInputStream = new FileInputStream(((PlayerSkinTextureAccessor)skin).getCacheFile());
                class_1011 vanilla = class_1011.method_4309((InputStream)fileInputStream);
                fileInputStream.close();
                this.originalSkin = ETFUtils2.emptyNativeImage(64, 64);
                this.originalSkin.method_4317(vanilla);
                vanilla.close();
                this.checkTexture(true);
            }
            catch (Exception e) {
                e.printStackTrace();
                this.skinFailed();
            }
        }
    }

    private ETFPlayerTexture(class_2960 rendererGivenSkin) {
        this.player = null;
        this.normalVanillaSkinIdentifier = rendererGivenSkin;
    }

    public ETFPlayerTexture() {
        this.player = new ETFPlayerEntityWrapper((class_1657)class_310.method_1551().field_1724);
        if (this.player.entity() != null) {
            assert (class_310.method_1551().field_1724 != null);
            class_1011 skin = ETFUtils2.getNativeImageElseNull(class_310.method_1551().field_1724.method_52814().comp_1626());
            if (skin != null) {
                clientPlayerOriginalSkinImageForTool = skin;
                this.changeSkinToThisForTool(skin);
                return;
            }
        }
        ETFUtils2.logError("ETFPlayerTexture went wrong");
    }

    @Nullable
    private static class_1011 returnMatchPixels(class_1011 baseSkin, int[] boundsToCheck) {
        return ETFPlayerTexture.returnMatchPixels(baseSkin, boundsToCheck, null);
    }

    @Nullable
    private static class_1011 returnMatchPixels(class_1011 baseSkin, int[] boundsToCheck, @Nullable class_1011 second) {
        class_1011 texture;
        if (baseSkin == null || boundsToCheck == null) {
            return null;
        }
        boolean hasSecondImageToBeUsedAsBase = second != null;
        HashSet<Integer> matchColors = new HashSet<Integer>();
        for (int x = boundsToCheck[0]; x <= boundsToCheck[2]; ++x) {
            for (int y = boundsToCheck[1]; y <= boundsToCheck[3]; ++y) {
                if (baseSkin.method_4311(x, y) == 0) continue;
                matchColors.add(baseSkin.method_4315(x, y));
            }
        }
        if (matchColors.isEmpty()) {
            return null;
        }
        if (!hasSecondImageToBeUsedAsBase) {
            texture = new class_1011(baseSkin.method_4307(), baseSkin.method_4323(), false);
            texture.method_4317(baseSkin);
        } else {
            texture = new class_1011(second.method_4307(), second.method_4323(), false);
            texture.method_4317(second);
        }
        for (int x = 0; x < texture.method_4307(); ++x) {
            for (int y = 0; y < texture.method_4323(); ++y) {
                if (matchColors.contains(texture.method_4315(x, y))) continue;
                texture.method_4305(x, y, 0);
            }
        }
        return ETFPlayerTexture.returnNullIfEmptyImage(texture);
    }

    @Nullable
    private static class_1011 returnNullIfEmptyImage(class_1011 imageToCheck) {
        boolean foundAPixel = false;
        block0: for (int x = 0; x < imageToCheck.method_4307(); ++x) {
            for (int y = 0; y < imageToCheck.method_4323(); ++y) {
                if (imageToCheck.method_4315(x, y) == 0) continue;
                foundAPixel = true;
                break block0;
            }
        }
        return foundAPixel ? imageToCheck : null;
    }

    private static class_1011 returnCustomTexturedCape(class_1011 skin) {
        class_1011 cape = ETFUtils2.emptyNativeImage(64, 32);
        class_1011 elytra = ETFUtils2.getNativeImageElseNull(new class_2960("textures/entity/elytra.png"));
        if (elytra == null || elytra.method_4307() != 64 || elytra.method_4323() != 32) {
            elytra = ETFUtils2.getNativeImageElseNull(new class_2960("entity_texture_features", "textures/capes/default_elytra.png"));
        }
        if (elytra != null) {
            cape.method_4317(elytra);
        }
        ETFPlayerTexture.copyToPixels(skin, cape, ETFPlayerTexture.getSkinPixelBounds("cape1"), 1, 1);
        ETFPlayerTexture.copyToPixels(skin, cape, ETFPlayerTexture.getSkinPixelBounds("cape1"), 12, 1);
        ETFPlayerTexture.copyToPixels(skin, cape, ETFPlayerTexture.getSkinPixelBounds("cape2"), 1, 5);
        ETFPlayerTexture.copyToPixels(skin, cape, ETFPlayerTexture.getSkinPixelBounds("cape2"), 12, 5);
        ETFPlayerTexture.copyToPixels(skin, cape, ETFPlayerTexture.getSkinPixelBounds("cape3"), 1, 9);
        ETFPlayerTexture.copyToPixels(skin, cape, ETFPlayerTexture.getSkinPixelBounds("cape3"), 12, 9);
        ETFPlayerTexture.copyToPixels(skin, cape, ETFPlayerTexture.getSkinPixelBounds("cape4"), 1, 13);
        ETFPlayerTexture.copyToPixels(skin, cape, ETFPlayerTexture.getSkinPixelBounds("cape4"), 12, 13);
        ETFPlayerTexture.copyToPixels(skin, cape, ETFPlayerTexture.getSkinPixelBounds("cape5.1"), 9, 1);
        ETFPlayerTexture.copyToPixels(skin, cape, ETFPlayerTexture.getSkinPixelBounds("cape5.1"), 20, 1);
        ETFPlayerTexture.copyToPixels(skin, cape, ETFPlayerTexture.getSkinPixelBounds("cape5.2"), 9, 5);
        ETFPlayerTexture.copyToPixels(skin, cape, ETFPlayerTexture.getSkinPixelBounds("cape5.2"), 20, 5);
        ETFPlayerTexture.copyToPixels(skin, cape, ETFPlayerTexture.getSkinPixelBounds("cape5.3"), 9, 9);
        ETFPlayerTexture.copyToPixels(skin, cape, ETFPlayerTexture.getSkinPixelBounds("cape5.3"), 20, 9);
        ETFPlayerTexture.copyToPixels(skin, cape, ETFPlayerTexture.getSkinPixelBounds("cape5.4"), 9, 13);
        ETFPlayerTexture.copyToPixels(skin, cape, ETFPlayerTexture.getSkinPixelBounds("cape5.4"), 20, 13);
        ETFPlayerTexture.copyToPixels(cape, cape, ETFPlayerTexture.getSkinPixelBounds("capeVertL"), 0, 1);
        ETFPlayerTexture.copyToPixels(cape, cape, ETFPlayerTexture.getSkinPixelBounds("capeVertR"), 11, 1);
        ETFPlayerTexture.copyToPixels(cape, cape, ETFPlayerTexture.getSkinPixelBounds("capeHorizL"), 1, 0);
        ETFPlayerTexture.copyToPixels(cape, cape, ETFPlayerTexture.getSkinPixelBounds("capeHorizR"), 11, 0);
        return cape;
    }

    private static int[] getSkinPixelBounds(String choiceKey) {
        int[] nArray;
        switch (choiceKey) {
            case "marker1": {
                int[] nArray2 = new int[4];
                nArray2[0] = 56;
                nArray2[1] = 16;
                nArray2[2] = 63;
                nArray = nArray2;
                nArray2[3] = 23;
                break;
            }
            case "marker2": {
                int[] nArray3 = new int[4];
                nArray3[0] = 56;
                nArray3[1] = 24;
                nArray3[2] = 63;
                nArray = nArray3;
                nArray3[3] = 31;
                break;
            }
            case "marker3": {
                int[] nArray4 = new int[4];
                nArray4[0] = 56;
                nArray4[1] = 32;
                nArray4[2] = 63;
                nArray = nArray4;
                nArray4[3] = 39;
                break;
            }
            case "marker4": {
                int[] nArray5 = new int[4];
                nArray5[0] = 56;
                nArray5[1] = 40;
                nArray5[2] = 63;
                nArray = nArray5;
                nArray5[3] = 47;
                break;
            }
            case "optimizedEyeSmall": {
                int[] nArray6 = new int[4];
                nArray6[0] = 12;
                nArray6[1] = 16;
                nArray6[2] = 19;
                nArray = nArray6;
                nArray6[3] = 16;
                break;
            }
            case "optimizedEye2High": {
                int[] nArray7 = new int[4];
                nArray7[0] = 12;
                nArray7[1] = 16;
                nArray7[2] = 19;
                nArray = nArray7;
                nArray7[3] = 17;
                break;
            }
            case "optimizedEye2High_second": {
                int[] nArray8 = new int[4];
                nArray8[0] = 12;
                nArray8[1] = 18;
                nArray8[2] = 19;
                nArray = nArray8;
                nArray8[3] = 19;
                break;
            }
            case "optimizedEye4High": {
                int[] nArray9 = new int[4];
                nArray9[0] = 12;
                nArray9[1] = 16;
                nArray9[2] = 19;
                nArray = nArray9;
                nArray9[3] = 19;
                break;
            }
            case "optimizedEye4High_second": {
                int[] nArray10 = new int[4];
                nArray10[0] = 36;
                nArray10[1] = 16;
                nArray10[2] = 43;
                nArray = nArray10;
                nArray10[3] = 19;
                break;
            }
            case "face1": {
                int[] nArray11 = new int[4];
                nArray11[0] = 0;
                nArray11[1] = 0;
                nArray11[2] = 7;
                nArray = nArray11;
                nArray11[3] = 7;
                break;
            }
            case "face2": {
                int[] nArray12 = new int[4];
                nArray12[0] = 24;
                nArray12[1] = 0;
                nArray12[2] = 31;
                nArray = nArray12;
                nArray12[3] = 7;
                break;
            }
            case "face3": {
                int[] nArray13 = new int[4];
                nArray13[0] = 32;
                nArray13[1] = 0;
                nArray13[2] = 39;
                nArray = nArray13;
                nArray13[3] = 7;
                break;
            }
            case "face4": {
                int[] nArray14 = new int[4];
                nArray14[0] = 56;
                nArray14[1] = 0;
                nArray14[2] = 63;
                nArray = nArray14;
                nArray14[3] = 7;
                break;
            }
            case "cape1": {
                int[] nArray15 = new int[4];
                nArray15[0] = 12;
                nArray15[1] = 32;
                nArray15[2] = 19;
                nArray = nArray15;
                nArray15[3] = 35;
                break;
            }
            case "cape2": {
                int[] nArray16 = new int[4];
                nArray16[0] = 36;
                nArray16[1] = 32;
                nArray16[2] = 43;
                nArray = nArray16;
                nArray16[3] = 35;
                break;
            }
            case "cape3": {
                int[] nArray17 = new int[4];
                nArray17[0] = 12;
                nArray17[1] = 48;
                nArray17[2] = 19;
                nArray = nArray17;
                nArray17[3] = 51;
                break;
            }
            case "cape4": {
                int[] nArray18 = new int[4];
                nArray18[0] = 28;
                nArray18[1] = 48;
                nArray18[2] = 35;
                nArray = nArray18;
                nArray18[3] = 51;
                break;
            }
            case "cape5": {
                int[] nArray19 = new int[4];
                nArray19[0] = 44;
                nArray19[1] = 48;
                nArray19[2] = 51;
                nArray = nArray19;
                nArray19[3] = 51;
                break;
            }
            case "cape5.1": {
                int[] nArray20 = new int[4];
                nArray20[0] = 44;
                nArray20[1] = 48;
                nArray20[2] = 45;
                nArray = nArray20;
                nArray20[3] = 51;
                break;
            }
            case "cape5.2": {
                int[] nArray21 = new int[4];
                nArray21[0] = 46;
                nArray21[1] = 48;
                nArray21[2] = 47;
                nArray = nArray21;
                nArray21[3] = 51;
                break;
            }
            case "cape5.3": {
                int[] nArray22 = new int[4];
                nArray22[0] = 48;
                nArray22[1] = 48;
                nArray22[2] = 49;
                nArray = nArray22;
                nArray22[3] = 51;
                break;
            }
            case "cape5.4": {
                int[] nArray23 = new int[4];
                nArray23[0] = 50;
                nArray23[1] = 48;
                nArray23[2] = 51;
                nArray = nArray23;
                nArray23[3] = 51;
                break;
            }
            case "capeVertL": {
                int[] nArray24 = new int[4];
                nArray24[0] = 1;
                nArray24[1] = 1;
                nArray24[2] = 1;
                nArray = nArray24;
                nArray24[3] = 16;
                break;
            }
            case "capeVertR": {
                int[] nArray25 = new int[4];
                nArray25[0] = 10;
                nArray25[1] = 1;
                nArray25[2] = 10;
                nArray = nArray25;
                nArray25[3] = 16;
                break;
            }
            case "capeHorizL": {
                int[] nArray26 = new int[4];
                nArray26[0] = 1;
                nArray26[1] = 1;
                nArray26[2] = 10;
                nArray = nArray26;
                nArray26[3] = 1;
                break;
            }
            case "capeHorizR": {
                int[] nArray27 = new int[4];
                nArray27[0] = 1;
                nArray27[1] = 16;
                nArray27[2] = 10;
                nArray = nArray27;
                nArray27[3] = 16;
                break;
            }
            default: {
                int[] nArray28 = new int[4];
                nArray28[0] = 0;
                nArray28[1] = 0;
                nArray28[2] = 0;
                nArray = nArray28;
                nArray28[3] = 0;
            }
        }
        return nArray;
    }

    private static class_1011 returnOptimizedBlinkFace(class_1011 baseSkin, int[] eyeBounds, int eyeHeightFromTopDown) {
        return ETFPlayerTexture.returnOptimizedBlinkFace(baseSkin, eyeBounds, eyeHeightFromTopDown, null);
    }

    private static class_1011 returnOptimizedBlinkFace(class_1011 baseSkin, int[] eyeBounds, int eyeHeightFromTopDown, int[] secondLayerBounds) {
        class_1011 texture = new class_1011(64, 64, false);
        texture.method_4317(baseSkin);
        ETFPlayerTexture.copyToPixels(baseSkin, texture, eyeBounds, 8, 8 + (eyeHeightFromTopDown - 1));
        if (secondLayerBounds != null) {
            ETFPlayerTexture.copyToPixels(baseSkin, texture, secondLayerBounds, 40, 8 + (eyeHeightFromTopDown - 1));
        }
        return texture;
    }

    private static int countTransparentInBox(class_1011 img, int x1, int y1, int x2, int y2) {
        int counter = 0;
        for (int x = x1; x <= x2; ++x) {
            for (int y = y1; y <= y2; ++y) {
                int i = img.method_4311(x, y);
                if (i < 0) {
                    i += 256;
                }
                counter += i;
            }
        }
        return counter;
    }

    private static void setNotTransparentInBox(class_1011 img, int x1, int y1, int x2, int y2) {
        for (int x = x1; x <= x2; ++x) {
            for (int y = y1; y <= y2; ++y) {
                if (img.method_4311(x, y) == -1) continue;
                int col = img.method_4315(x, y);
                img.method_4305(x, y, class_5253.class_5254.method_27764((int)-1, (int)class_5253.class_5254.method_27765((int)col), (int)class_5253.class_5254.method_27766((int)col), (int)class_5253.class_5254.method_27767((int)col)));
            }
        }
    }

    private static void parseSkinTransparency(class_1011 skin, boolean forceSolidSkin) {
        if (forceSolidSkin || !ETFClientCommon.ETFConfigData.skinFeaturesEnableTransparency) {
            ETFPlayerTexture.forceSolidLowerSkin(skin);
            return;
        }
        if (!ETFClientCommon.ETFConfigData.skinFeaturesEnableFullTransparency) {
            boolean isSkinMoreThan40PercentOpaque;
            int countTransparent = 0;
            countTransparent += ETFPlayerTexture.countTransparentInBox(skin, 8, 0, 23, 15);
            countTransparent += ETFPlayerTexture.countTransparentInBox(skin, 0, 20, 55, 31);
            countTransparent += ETFPlayerTexture.countTransparentInBox(skin, 0, 8, 7, 15);
            countTransparent += ETFPlayerTexture.countTransparentInBox(skin, 24, 8, 31, 15);
            countTransparent += ETFPlayerTexture.countTransparentInBox(skin, 0, 16, 11, 19);
            countTransparent += ETFPlayerTexture.countTransparentInBox(skin, 20, 16, 35, 19);
            countTransparent += ETFPlayerTexture.countTransparentInBox(skin, 44, 16, 51, 19);
            countTransparent += ETFPlayerTexture.countTransparentInBox(skin, 20, 48, 27, 51);
            countTransparent += ETFPlayerTexture.countTransparentInBox(skin, 36, 48, 43, 51);
            int average = (countTransparent += ETFPlayerTexture.countTransparentInBox(skin, 16, 52, 47, 63)) / 1648;
            boolean bl = isSkinMoreThan40PercentOpaque = average >= 100;
            if (!isSkinMoreThan40PercentOpaque) {
                ETFPlayerTexture.forceSolidLowerSkin(skin);
            }
        }
    }

    private static void forceSolidLowerSkin(class_1011 skin) {
        try {
            ETFPlayerTexture.setNotTransparentInBox(skin, 8, 0, 23, 15);
            ETFPlayerTexture.setNotTransparentInBox(skin, 0, 20, 55, 31);
            ETFPlayerTexture.setNotTransparentInBox(skin, 0, 8, 7, 15);
            ETFPlayerTexture.setNotTransparentInBox(skin, 24, 8, 31, 15);
            ETFPlayerTexture.setNotTransparentInBox(skin, 0, 16, 11, 19);
            ETFPlayerTexture.setNotTransparentInBox(skin, 20, 16, 35, 19);
            ETFPlayerTexture.setNotTransparentInBox(skin, 44, 16, 51, 19);
            ETFPlayerTexture.setNotTransparentInBox(skin, 20, 48, 27, 51);
            ETFPlayerTexture.setNotTransparentInBox(skin, 36, 48, 43, 51);
            ETFPlayerTexture.setNotTransparentInBox(skin, 16, 52, 47, 63);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static class_1011 getCoatTexture(class_1011 skin, int lengthOfCoat, boolean ignoreTopTexture) {
        class_1011 coat = new class_1011(64, 64, false);
        coat.method_4326(0, 0, 64, 64, 0);
        if (!ignoreTopTexture) {
            ETFPlayerTexture.copyToPixels(skin, coat, 4, 32, 7, 35 + lengthOfCoat, 20, 32);
            ETFPlayerTexture.copyToPixels(skin, coat, 4, 48, 7, 51 + lengthOfCoat, 24, 32);
        }
        ETFPlayerTexture.copyToPixels(skin, coat, 0, 36, 7, 36 + lengthOfCoat, 16, 36);
        ETFPlayerTexture.copyToPixels(skin, coat, 12, 36, 15, 36 + lengthOfCoat, 36, 36);
        ETFPlayerTexture.copyToPixels(skin, coat, 4, 52, 15, 52 + lengthOfCoat, 24, 36);
        return coat;
    }

    private static void copyToPixels(class_1011 source, class_1011 dest, int[] bounds, int copyToX, int CopyToY) {
        ETFPlayerTexture.copyToPixels(source, dest, bounds[0], bounds[1], bounds[2], bounds[3], copyToX, CopyToY);
    }

    private static void copyToPixels(class_1011 source, class_1011 dest, int x1, int y1, int x2, int y2, int copyToX, int copyToY) {
        int copyToXRelative = copyToX - x1;
        int copyToYRelative = copyToY - y1;
        for (int x = x1; x <= x2; ++x) {
            for (int y = y1; y <= y2; ++y) {
                dest.method_4305(x + copyToXRelative, y + copyToYRelative, source.method_4315(x, y));
            }
        }
    }

    private static void deletePixels(class_1011 source, int x1, int y1, int x2, int y2) {
        for (int x = x1; x <= x2; ++x) {
            for (int y = y1; y <= y2; ++y) {
                source.method_4305(x, y, 0);
            }
        }
    }

    public static int getSkinPixelColourToNumber(int color) {
        return switch (color) {
            case -65281 -> 1;
            case -256 -> 2;
            case -16776961 -> 3;
            case -16711936 -> 4;
            case -16760705 -> 5;
            case -65536 -> 6;
            case -16744449 -> 7;
            case -14483457 -> 8;
            case -12362096 -> 666;
            default -> 0;
        };
    }

    public boolean isCorrectObjectForThisSkin(class_2960 check) {
        return check.equals((Object)this.normalVanillaSkinIdentifier);
    }

    public boolean hasCustomCape() {
        return this.etfCapeIdentifier != null;
    }

    @Nullable
    public class_2960 getBaseTextureIdentifierOrNullForVanilla(class_1657 player) {
        return this.getBaseTextureIdentifierOrNullForVanilla(new ETFPlayerEntityWrapper(player));
    }

    @Nullable
    public class_2960 getBaseTextureIdentifierOrNullForVanilla(ETFPlayerEntity player) {
        this.player = player;
        if (this.etfTextureOfFinalBaseSkin != null) {
            if (this.canUseFeaturesForThisPlayer()) {
                return this.etfTextureOfFinalBaseSkin.getTextureIdentifier(player);
            }
            if (ETFClientCommon.ETFConfigData.tryETFTransparencyForAllSkins) {
                return this.etfTextureOfFinalBaseSkin.getTextureIdentifier(player);
            }
        }
        return null;
    }

    @Nullable
    public class_2960 getBaseHeadTextureIdentifierOrNullForVanilla() {
        if (this.etfTextureOfFinalBaseSkin != null) {
            if (this.canUseFeaturesForThisPlayer()) {
                return this.etfTextureOfFinalBaseSkin.getTextureIdentifier(null);
            }
            if (ETFClientCommon.ETFConfigData.tryETFTransparencyForAllSkins) {
                return this.etfTextureOfFinalBaseSkin.getTextureIdentifier(null);
            }
        }
        return null;
    }

    @Nullable
    public class_2960 getBaseTextureEmissiveIdentifierOrNullForNone() {
        if (this.hasEmissives && this.canUseFeaturesForThisPlayer() && this.etfTextureOfFinalBaseSkin != null) {
            return this.etfTextureOfFinalBaseSkin.getEmissiveIdentifierOfCurrentState();
        }
        return null;
    }

    @Nullable
    public class_2960 getBaseTextureEnchantIdentifierOrNullForNone() {
        if (this.hasEnchant && this.canUseFeaturesForThisPlayer() && this.etfTextureOfFinalBaseSkin != null) {
            switch (this.etfTextureOfFinalBaseSkin.currentTextureState) {
                case NORMAL: 
                case NORMAL_PATCHED: {
                    return this.baseEnchantIdentifier;
                }
                case BLINK: 
                case BLINK_PATCHED: {
                    return this.baseEnchantBlinkIdentifier;
                }
                case BLINK2: 
                case BLINK2_PATCHED: {
                    return this.baseEnchantBlink2Identifier;
                }
            }
            return null;
        }
        return null;
    }

    public void renderFeatures(class_4587 matrixStack, class_4597 vertexConsumerProvider, int light, class_591<class_742> model) {
        if (this.canUseFeaturesForThisPlayer() && this.etfCapeIdentifier != null) {
            if (this.etfCapeEmissiveIdentifier != null) {
                class_4588 emissiveVert = vertexConsumerProvider.getBuffer(class_1921.method_23580((class_2960)this.etfCapeEmissiveIdentifier));
                model.method_2823(matrixStack, emissiveVert, 0xF000F2, class_4608.field_21444);
            }
            if (this.etfCapeEnchantedIdentifier != null) {
                class_4588 enchantVert = class_918.method_27952((class_4597)vertexConsumerProvider, (class_1921)class_1921.method_25448((class_2960)this.etfCapeEnchantedIdentifier), (boolean)false, (boolean)true);
                model.method_2823(matrixStack, enchantVert, light, class_4608.field_21444);
            }
        }
    }

    public boolean canUseFeaturesForThisPlayer() {
        return this.isTextureReady && this.hasFeatures && (ETFClientCommon.ETFConfigData.enableEnemyTeamPlayersSkinFeatures || this.player.isTeammate((class_1657)class_310.method_1551().field_1724) || this.player.getScoreboardTeam() == null);
    }

    public <M extends class_3879> void renderFeatures(class_4587 matrixStack, class_4597 vertexConsumerProvider, int light, M model0) {
        if (this.canUseFeaturesForThisPlayer() && model0 instanceof class_591) {
            class_591 model = (class_591)model0;
            if (this.hasVillagerNose) {
                this.customPlayerModel.villagerNose.method_17138(model.field_3398);
                if (this.noseType == ETFConfigScreenSkinTool.NoseType.VILLAGER_TEXTURED) {
                    villagerVert = vertexConsumerProvider.getBuffer(class_1921.method_23580((class_2960)this.etfTextureOfFinalBaseSkin.getTextureIdentifier(null)));
                    this.customPlayerModel.villagerNose.method_22699(matrixStack, villagerVert, light, class_4608.field_21444, 1.0f, 1.0f, 1.0f, 1.0f);
                    this.etfTextureOfFinalBaseSkin.renderEmissive(matrixStack, vertexConsumerProvider, this.customPlayerModel.villagerNose);
                } else {
                    villagerVert = vertexConsumerProvider.getBuffer(class_1921.method_23572((class_2960)villagerTexture));
                    this.customPlayerModel.villagerNose.method_22699(matrixStack, villagerVert, light, class_4608.field_21444, 1.0f, 1.0f, 1.0f, 1.0f);
                }
            } else if (this.texturedNoseIdentifier != null) {
                this.customPlayerModel.textureNose.method_17138(model.field_3398);
                class_4588 noseVertex = vertexConsumerProvider.getBuffer(class_1921.method_23689((class_2960)this.texturedNoseIdentifier));
                this.customPlayerModel.textureNose.method_22699(matrixStack, noseVertex, light, class_4608.field_21444, 1.0f, 1.0f, 1.0f, 1.0f);
                if (this.texturedNoseIdentifierEmissive != null) {
                    this.customPlayerModel.textureNose.method_17138(model.field_3398);
                    class_4588 noseVertex_e = ETFManager.getEmissiveMode() == ETFManager.EmissiveRenderModes.BRIGHT ? vertexConsumerProvider.getBuffer(class_1921.method_23592((class_2960)this.texturedNoseIdentifierEmissive, (boolean)true)) : vertexConsumerProvider.getBuffer(class_1921.method_23689((class_2960)this.texturedNoseIdentifierEmissive));
                    this.customPlayerModel.textureNose.method_22699(matrixStack, noseVertex_e, 0xF000F2, class_4608.field_21444, 1.0f, 1.0f, 1.0f, 1.0f);
                }
                if (this.texturedNoseIdentifierEnchanted != null) {
                    this.customPlayerModel.textureNose.method_17138(model.field_3398);
                    class_4588 noseVertex_ench = class_918.method_27952((class_4597)vertexConsumerProvider, (class_1921)class_1921.method_25448((class_2960)this.texturedNoseIdentifierEnchanted), (boolean)false, (boolean)true);
                    this.customPlayerModel.textureNose.method_22699(matrixStack, noseVertex_ench, light, class_4608.field_21444, 1.0f, 1.0f, 1.0f, 1.0f);
                }
            }
            class_1799 armour = this.player.getInventory().method_7372(1);
            if (!(this.coatIdentifier == null || !this.player.isPartVisible(class_1664.field_7564) || armour.method_31574(class_1802.field_8218) || armour.method_31574(class_1802.field_8570) || armour.method_31574(class_1802.field_8348) || armour.method_31574(class_1802.field_8416) || armour.method_31574(class_1802.field_8396) || armour.method_31574(class_1802.field_22029))) {
                if (this.hasFatCoat) {
                    this.customPlayerModel.fatJacket.method_17138(model.field_3483);
                } else {
                    this.customPlayerModel.jacket.method_17138(model.field_3483);
                }
                class_4588 coatVert = vertexConsumerProvider.getBuffer(class_1921.method_23580((class_2960)this.coatIdentifier));
                matrixStack.method_22903();
                if (this.hasFatCoat) {
                    this.customPlayerModel.fatJacket.method_22699(matrixStack, coatVert, light, class_4608.field_21444, 1.0f, 1.0f, 1.0f, 1.0f);
                } else {
                    this.customPlayerModel.jacket.method_22699(matrixStack, coatVert, light, class_4608.field_21444, 1.0f, 1.0f, 1.0f, 1.0f);
                }
                if (this.coatEnchantedIdentifier != null) {
                    class_4588 enchantVert = class_918.method_27952((class_4597)vertexConsumerProvider, (class_1921)class_1921.method_25448((class_2960)this.coatEnchantedIdentifier), (boolean)false, (boolean)true);
                    if (this.hasFatCoat) {
                        this.customPlayerModel.fatJacket.method_22699(matrixStack, enchantVert, light, class_4608.field_21444, 1.0f, 1.0f, 1.0f, 1.0f);
                    } else {
                        this.customPlayerModel.jacket.method_22699(matrixStack, enchantVert, light, class_4608.field_21444, 1.0f, 1.0f, 1.0f, 1.0f);
                    }
                }
                if (this.coatEmissiveIdentifier != null) {
                    class_4588 emissiveVert = ETFManager.getEmissiveMode() == ETFManager.EmissiveRenderModes.BRIGHT ? vertexConsumerProvider.getBuffer(class_1921.method_23592((class_2960)this.coatEmissiveIdentifier, (boolean)true)) : vertexConsumerProvider.getBuffer(class_1921.method_23580((class_2960)this.coatEmissiveIdentifier));
                    if (this.hasFatCoat) {
                        this.customPlayerModel.fatJacket.method_22699(matrixStack, emissiveVert, 0xF000F2, class_4608.field_21444, 1.0f, 1.0f, 1.0f, 1.0f);
                    } else {
                        this.customPlayerModel.jacket.method_22699(matrixStack, emissiveVert, 0xF000F2, class_4608.field_21444, 1.0f, 1.0f, 1.0f, 1.0f);
                    }
                }
                matrixStack.method_22909();
            }
            if (this.hasEmissives && this.etfTextureOfFinalBaseSkin != null) {
                this.etfTextureOfFinalBaseSkin.renderEmissive(matrixStack, vertexConsumerProvider, (class_3879)model);
            }
            if (this.hasEnchant && this.baseEnchantIdentifier != null && this.etfTextureOfFinalBaseSkin != null) {
                class_4588 enchantVert = class_918.method_27952((class_4597)vertexConsumerProvider, (class_1921)class_1921.method_25448((class_2960)(switch (this.etfTextureOfFinalBaseSkin.currentTextureState) {
                    case ETFTexture.TextureReturnState.BLINK, ETFTexture.TextureReturnState.BLINK_PATCHED, ETFTexture.TextureReturnState.APPLY_BLINK -> this.baseEnchantBlinkIdentifier;
                    case ETFTexture.TextureReturnState.BLINK2, ETFTexture.TextureReturnState.BLINK2_PATCHED, ETFTexture.TextureReturnState.APPLY_BLINK2 -> this.baseEnchantBlink2Identifier;
                    default -> this.baseEnchantIdentifier;
                })), (boolean)false, (boolean)true);
                model.method_2828(matrixStack, enchantVert, light, class_4608.field_21444, 1.0f, 1.0f, 1.0f, 1.0f);
            }
        } else if (model0 instanceof class_5598) {
            class_5598 skullModel = (class_5598)model0;
            if (this.hasEmissives && this.etfTextureOfFinalBaseSkin != null) {
                this.etfTextureOfFinalBaseSkin.renderEmissive(matrixStack, vertexConsumerProvider, (class_3879)skullModel, ETFManager.EmissiveRenderModes.DULL);
            }
            if (this.hasEnchant && this.baseEnchantIdentifier != null && this.etfTextureOfFinalBaseSkin != null) {
                class_4588 enchantVert = class_918.method_27952((class_4597)vertexConsumerProvider, (class_1921)class_1921.method_25448((class_2960)(switch (this.etfTextureOfFinalBaseSkin.currentTextureState) {
                    case ETFTexture.TextureReturnState.BLINK, ETFTexture.TextureReturnState.BLINK_PATCHED, ETFTexture.TextureReturnState.APPLY_BLINK -> this.baseEnchantBlinkIdentifier;
                    case ETFTexture.TextureReturnState.BLINK2, ETFTexture.TextureReturnState.BLINK2_PATCHED, ETFTexture.TextureReturnState.APPLY_BLINK2 -> this.baseEnchantBlink2Identifier;
                    default -> this.baseEnchantIdentifier;
                })), (boolean)false, (boolean)true);
                skullModel.method_2828(matrixStack, enchantVert, light, class_4608.field_21444, 1.0f, 1.0f, 1.0f, 1.0f);
            }
        }
    }

    private void initiateThirdPartyCapeDownload(String capeUrl) {
        CompletableFuture.runAsync(() -> {
            try {
                HttpURLConnection httpURLConnection = (HttpURLConnection)new URL(capeUrl).openConnection(class_310.method_1551().method_1487());
                httpURLConnection.setDoInput(true);
                httpURLConnection.setDoOutput(false);
                httpURLConnection.connect();
                if (httpURLConnection.getResponseCode() / 100 == 2) {
                    InputStream inputStream = httpURLConnection.getInputStream();
                    class_310.method_1551().execute(() -> {
                        try {
                            class_1011 one = class_1011.method_4309((InputStream)inputStream);
                            this.receiveThirdPartyCape(one);
                        }
                        catch (Exception e) {
                            ETFUtils2.logError("ThirdPartyCapeDownload failed for player:" + this.player.getName().getString() + "retrying again later " + e);
                            e.printStackTrace();
                        }
                    });
                }
            }
            catch (Exception var6) {
                ETFUtils2.logError("ThirdPartyCapeDownload2 failed for player:" + this.player.getName().getString() + "retrying again later" + var6);
            }
        }, class_156.method_18349());
    }

    public void receiveThirdPartyCape(@NotNull class_1011 capeImage) {
        class_2960 newCapeId = new class_2960(SKIN_NAMESPACE, this.player.getUuid().toString().replaceAll("/[^a-z]/g", "") + "_cape_third_party.png");
        if (capeImage.method_4307() % capeImage.method_4323() != 0) {
            int newWidth;
            for (newWidth = 64; newWidth < capeImage.method_4307(); newWidth += newWidth) {
            }
            int newHeight = newWidth / 2;
            try {
                class_1011 resizedImage = ETFUtils2.emptyNativeImage(newWidth, newHeight);
                for (int x = 0; x < capeImage.method_4307(); ++x) {
                    for (int y = 0; y < capeImage.method_4323(); ++y) {
                        resizedImage.method_4305(x, y, capeImage.method_4315(x, y));
                    }
                }
                this.checkThirdPartyCapeFeaturesAndFinalize(resizedImage, newCapeId);
            }
            catch (Exception e) {
                ETFUtils2.logError("optifine cape resize failed");
            }
        } else {
            this.checkThirdPartyCapeFeaturesAndFinalize(capeImage, newCapeId);
        }
    }

    private void checkThirdPartyCapeFeaturesAndFinalize(class_1011 capeImage, class_2960 newCapeId) {
        class_1011 checkCapeEmissive = ETFPlayerTexture.returnMatchPixels(this.originalSkin, this.emissiveCapeBounds, capeImage);
        if (checkCapeEmissive != null) {
            class_2960 newCapeEmissive = new class_2960(SKIN_NAMESPACE, this.player.getUuid() + "_cape_third_party_e.png");
            ETFUtils2.registerNativeImageToIdentifier(checkCapeEmissive, newCapeEmissive);
            this.etfCapeEmissiveIdentifier = newCapeEmissive;
        } else {
            this.etfCapeEmissiveIdentifier = null;
        }
        class_1011 checkCapeEnchant = ETFPlayerTexture.returnMatchPixels(this.originalSkin, this.enchantCapeBounds, capeImage);
        if (checkCapeEnchant != null) {
            class_2960 newCapeEnchanted = new class_2960(SKIN_NAMESPACE, this.player.getUuid() + "_cape_third_party_enchant.png");
            ETFUtils2.registerNativeImageToIdentifier(checkCapeEnchant, newCapeEnchanted);
            this.etfCapeEnchantedIdentifier = newCapeEnchanted;
        } else {
            this.etfCapeEnchantedIdentifier = null;
        }
        ETFUtils2.registerNativeImageToIdentifier(capeImage, newCapeId);
        this.etfCapeIdentifier = newCapeId;
    }

    private void skinFailed() {
        if (!(class_310.method_1551().field_1755 instanceof ETFConfigScreenSkinTool)) {
            ETFManager.getInstance().PLAYER_TEXTURE_MAP.put(this.player.getUuid(), new ETFPlayerTexture(this.normalVanillaSkinIdentifier));
        } else {
            ETFUtils2.logError("something went wrong applying skin in tool, or skin features are not added");
        }
    }

    public void checkTexture(boolean skipSkinLoad) {
        class_1011 modifiedCape;
        if (!skipSkinLoad) {
            try {
                class_1046 skin = (class_1046)((FileCacheAccessor)((PlayerSkinProviderAccessor)class_310.method_1551().method_1582()).getSkinCache()).getTextureManager().method_34590(this.normalVanillaSkinIdentifier, null);
                FileInputStream fileInputStream = new FileInputStream(((PlayerSkinTextureAccessor)skin).getCacheFile());
                class_1011 vanilla = class_1011.method_4309((InputStream)fileInputStream);
                fileInputStream.close();
                this.originalSkin = ETFUtils2.emptyNativeImage(64, 64);
                this.originalSkin.method_4317(vanilla);
                if (class_310.method_1551().field_1724 != null && this.player.getUuid().equals(class_310.method_1551().field_1724.method_5667())) {
                    clientPlayerOriginalSkinImageForTool = this.originalSkin;
                }
                vanilla.close();
                try {
                    class_2960 capeId = ((class_742)this.player).method_52814().comp_1627();
                    class_1046 cape = (class_1046)((FileCacheAccessor)((PlayerSkinProviderAccessor)class_310.method_1551().method_1582()).getCapeCache()).getTextureManager().method_34590(capeId, null);
                    if (cape != null) {
                        FileInputStream fileInputStreamCape = new FileInputStream(((PlayerSkinTextureAccessor)cape).getCacheFile());
                        class_1011 vanillaCape = class_1011.method_4309((InputStream)fileInputStreamCape);
                        fileInputStreamCape.close();
                        this.originalCape = ETFUtils2.emptyNativeImage(64, 32);
                        this.originalCape.method_4317(vanillaCape);
                        vanillaCape.close();
                    }
                }
                catch (Exception capeId) {}
            }
            catch (Exception e) {
                this.skinFailed();
                return;
            }
        }
        UUID id = this.player.getUuid();
        if (this.originalCape != null) {
            modifiedCape = ETFUtils2.emptyNativeImage(this.originalCape.method_4307(), this.originalCape.method_4323());
            modifiedCape.method_4317(this.originalCape);
        } else {
            modifiedCape = ETFUtils2.emptyNativeImage(64, 32);
        }
        class_1011 modifiedSkin = ETFUtils2.emptyNativeImage(this.originalSkin.method_4307(), this.originalSkin.method_4323());
        modifiedSkin.method_4317(this.originalSkin);
        if (this.originalSkin != null) {
            if (this.originalSkin.method_4315(1, 16) == -16776961 && this.originalSkin.method_4315(0, 16) == -16777089 && this.originalSkin.method_4315(0, 17) == -16776961 && this.originalSkin.method_4315(2, 16) == -16711936 && this.originalSkin.method_4315(3, 16) == -16744704 && this.originalSkin.method_4315(3, 17) == -16711936 && this.originalSkin.method_4315(0, 18) == -65536 && this.originalSkin.method_4315(0, 19) == -8454144 && this.originalSkin.method_4315(1, 19) == -65536 && this.originalSkin.method_4315(3, 18) == -1 && this.originalSkin.method_4315(2, 19) == -1 && this.originalSkin.method_4315(3, 18) == -1) {
                int[] boxChosenBounds;
                int capeChoice1;
                int blinkChoice;
                this.customPlayerModel = new ETFCustomPlayerFeatureModel();
                this.hasFeatures = true;
                ETFUtils2.logMessage("Found Player {" + this.player.getName().getString() + "} with texture features in skin.", false);
                int[] choiceBoxChoices = new int[]{ETFPlayerTexture.getSkinPixelColourToNumber(this.originalSkin.method_4315(52, 16)), ETFPlayerTexture.getSkinPixelColourToNumber(this.originalSkin.method_4315(52, 17)), ETFPlayerTexture.getSkinPixelColourToNumber(this.originalSkin.method_4315(52, 18)), ETFPlayerTexture.getSkinPixelColourToNumber(this.originalSkin.method_4315(52, 19)), ETFPlayerTexture.getSkinPixelColourToNumber(this.originalSkin.method_4315(53, 16)), ETFPlayerTexture.getSkinPixelColourToNumber(this.originalSkin.method_4315(53, 17)), ETFPlayerTexture.getSkinPixelColourToNumber(this.originalSkin.method_4315(53, 18))};
                boolean noseUpper = ETFPlayerTexture.getSkinPixelColourToNumber(this.originalSkin.method_4315(43, 13)) == 666 && ETFPlayerTexture.getSkinPixelColourToNumber(this.originalSkin.method_4315(44, 13)) == 666 && ETFPlayerTexture.getSkinPixelColourToNumber(this.originalSkin.method_4315(43, 14)) == 666 && ETFPlayerTexture.getSkinPixelColourToNumber(this.originalSkin.method_4315(44, 14)) == 666 && ETFPlayerTexture.getSkinPixelColourToNumber(this.originalSkin.method_4315(43, 15)) == 666 && ETFPlayerTexture.getSkinPixelColourToNumber(this.originalSkin.method_4315(44, 15)) == 666;
                boolean noseLower = ETFPlayerTexture.getSkinPixelColourToNumber(this.originalSkin.method_4315(11, 13)) == 666 && ETFPlayerTexture.getSkinPixelColourToNumber(this.originalSkin.method_4315(12, 13)) == 666 && ETFPlayerTexture.getSkinPixelColourToNumber(this.originalSkin.method_4315(11, 14)) == 666 && ETFPlayerTexture.getSkinPixelColourToNumber(this.originalSkin.method_4315(12, 14)) == 666 && ETFPlayerTexture.getSkinPixelColourToNumber(this.originalSkin.method_4315(11, 15)) == 666 && ETFPlayerTexture.getSkinPixelColourToNumber(this.originalSkin.method_4315(12, 15)) == 666;
                boolean bl = this.hasVillagerNose = noseLower || noseUpper;
                if (noseUpper) {
                    ETFPlayerTexture.deletePixels(modifiedSkin, 43, 13, 44, 15);
                }
                class_1011 noseTexture = null;
                int noseChoice = choiceBoxChoices[5];
                if (noseChoice >= 1 && noseChoice <= 7) {
                    if (noseChoice == 1 || noseChoice == 7) {
                        this.hasVillagerNose = true;
                        this.noseType = noseChoice == 1 ? ETFConfigScreenSkinTool.NoseType.VILLAGER : ETFConfigScreenSkinTool.NoseType.VILLAGER_TEXTURED;
                    } else {
                        int y;
                        int x;
                        noseTexture = ETFUtils2.emptyNativeImage(8, 8);
                        int[] bounds = switch (noseChoice) {
                            case 3 -> {
                                this.noseType = ETFConfigScreenSkinTool.NoseType.TEXTURED_2;
                                yield ETFPlayerTexture.getSkinPixelBounds("cape2");
                            }
                            case 4 -> {
                                this.noseType = ETFConfigScreenSkinTool.NoseType.TEXTURED_3;
                                yield ETFPlayerTexture.getSkinPixelBounds("cape3");
                            }
                            case 5 -> {
                                this.noseType = ETFConfigScreenSkinTool.NoseType.TEXTURED_4;
                                yield ETFPlayerTexture.getSkinPixelBounds("cape4");
                            }
                            case 6 -> {
                                this.noseType = ETFConfigScreenSkinTool.NoseType.TEXTURED_5;
                                yield ETFPlayerTexture.getSkinPixelBounds("cape5");
                            }
                            default -> {
                                this.noseType = ETFConfigScreenSkinTool.NoseType.TEXTURED_1;
                                yield ETFPlayerTexture.getSkinPixelBounds("cape1");
                            }
                        };
                        int noseY = 0;
                        for (x = bounds[0]; x <= bounds[2]; ++x) {
                            int noseX = 0;
                            for (int y2 = bounds[1]; y2 <= bounds[3]; ++y2) {
                                noseTexture.method_4305(noseX, noseY, this.originalSkin.method_4315(x, y2));
                                ++noseX;
                            }
                            ++noseY;
                        }
                        for (x = 4; x < 8; ++x) {
                            for (y = 0; y < 8; ++y) {
                                noseTexture.method_4305(x, y, noseTexture.method_4315(7 - x, y));
                            }
                        }
                        for (x = 0; x < 8; ++x) {
                            for (y = 0; y < 4; ++y) {
                                int lowerColour = noseTexture.method_4315(x, y + 4);
                                noseTexture.method_4305(x, y + 4, noseTexture.method_4315(x, y));
                                noseTexture.method_4305(x, y, lowerColour);
                            }
                        }
                        this.texturedNoseIdentifier = new class_2960(SKIN_NAMESPACE, id + "_nose.png");
                        ETFUtils2.registerNativeImageToIdentifier(noseTexture, this.texturedNoseIdentifier);
                    }
                }
                class_1011 coatSkin = null;
                int controllerCoat = choiceBoxChoices[1];
                if (controllerCoat >= 1 && controllerCoat <= 8) {
                    this.coatStyle = controllerCoat;
                    int lengthOfCoat = choiceBoxChoices[2] - 1;
                    this.coatLength = lengthOfCoat + 1;
                    this.coatIdentifier = new class_2960(SKIN_NAMESPACE, id + "_coat.png");
                    coatSkin = ETFPlayerTexture.getCoatTexture(this.originalSkin, lengthOfCoat, controllerCoat >= 5);
                    ETFUtils2.registerNativeImageToIdentifier(coatSkin, this.coatIdentifier);
                    if (controllerCoat == 2 || controllerCoat == 4 || controllerCoat == 6 || controllerCoat == 8) {
                        ETFPlayerTexture.deletePixels(modifiedSkin, 4, 32, 7, 35);
                        ETFPlayerTexture.deletePixels(modifiedSkin, 4, 48, 7, 51);
                        ETFPlayerTexture.deletePixels(modifiedSkin, 0, 36, 15, 36 + lengthOfCoat);
                        ETFPlayerTexture.deletePixels(modifiedSkin, 0, 52, 15, 52 + lengthOfCoat);
                    }
                    this.hasFatCoat = controllerCoat == 3 || controllerCoat == 4 || controllerCoat == 7 || controllerCoat == 8;
                } else {
                    this.coatIdentifier = null;
                }
                this.wasForcedSolid = choiceBoxChoices[6] == 1;
                class_1011 blinkSkinFile = null;
                class_1011 blinkSkinFile2 = null;
                class_2960 blinkIdentifier = new class_2960(SKIN_NAMESPACE, id + "_blink.png");
                class_2960 blink2Identifier = new class_2960(SKIN_NAMESPACE, id + "_blink2.png");
                this.blinkType = blinkChoice = choiceBoxChoices[0];
                if (blinkChoice >= 1 && blinkChoice <= 5) {
                    if (blinkChoice <= 2) {
                        blinkSkinFile = ETFPlayerTexture.returnOptimizedBlinkFace(modifiedSkin, ETFPlayerTexture.getSkinPixelBounds("face1"), 1, ETFPlayerTexture.getSkinPixelBounds("face3"));
                        ETFPlayerTexture.parseSkinTransparency(blinkSkinFile, this.wasForcedSolid);
                        ETFUtils2.registerNativeImageToIdentifier(blinkSkinFile, blinkIdentifier);
                        if (blinkChoice == 2) {
                            blinkSkinFile2 = ETFPlayerTexture.returnOptimizedBlinkFace(modifiedSkin, ETFPlayerTexture.getSkinPixelBounds("face2"), 1, ETFPlayerTexture.getSkinPixelBounds("face4"));
                            ETFPlayerTexture.parseSkinTransparency(blinkSkinFile2, this.wasForcedSolid);
                            ETFUtils2.registerNativeImageToIdentifier(blinkSkinFile2, blink2Identifier);
                        }
                    } else {
                        int eyeHeightTopDown;
                        this.blinkHeight = eyeHeightTopDown = choiceBoxChoices[3];
                        if (eyeHeightTopDown > 8 || eyeHeightTopDown < 1) {
                            eyeHeightTopDown = 1;
                        }
                        if (blinkChoice == 3) {
                            blinkSkinFile = ETFPlayerTexture.returnOptimizedBlinkFace(modifiedSkin, ETFPlayerTexture.getSkinPixelBounds("optimizedEyeSmall"), eyeHeightTopDown);
                            ETFPlayerTexture.parseSkinTransparency(blinkSkinFile, this.wasForcedSolid);
                            ETFUtils2.registerNativeImageToIdentifier(blinkSkinFile, blinkIdentifier);
                        } else if (blinkChoice == 4) {
                            blinkSkinFile = ETFPlayerTexture.returnOptimizedBlinkFace(modifiedSkin, ETFPlayerTexture.getSkinPixelBounds("optimizedEye2High"), eyeHeightTopDown);
                            blinkSkinFile2 = ETFPlayerTexture.returnOptimizedBlinkFace(modifiedSkin, ETFPlayerTexture.getSkinPixelBounds("optimizedEye2High_second"), eyeHeightTopDown);
                            ETFPlayerTexture.parseSkinTransparency(blinkSkinFile, this.wasForcedSolid);
                            ETFPlayerTexture.parseSkinTransparency(blinkSkinFile2, this.wasForcedSolid);
                            ETFUtils2.registerNativeImageToIdentifier(blinkSkinFile, blinkIdentifier);
                            ETFUtils2.registerNativeImageToIdentifier(blinkSkinFile2, blink2Identifier);
                        } else {
                            blinkSkinFile = ETFPlayerTexture.returnOptimizedBlinkFace(modifiedSkin, ETFPlayerTexture.getSkinPixelBounds("optimizedEye4High"), eyeHeightTopDown);
                            blinkSkinFile2 = ETFPlayerTexture.returnOptimizedBlinkFace(modifiedSkin, ETFPlayerTexture.getSkinPixelBounds("optimizedEye4High_second"), eyeHeightTopDown);
                            ETFPlayerTexture.parseSkinTransparency(blinkSkinFile, this.wasForcedSolid);
                            ETFPlayerTexture.parseSkinTransparency(blinkSkinFile2, this.wasForcedSolid);
                            ETFUtils2.registerNativeImageToIdentifier(blinkSkinFile, blinkIdentifier);
                            ETFUtils2.registerNativeImageToIdentifier(blinkSkinFile2, blink2Identifier);
                        }
                    }
                }
                if (blinkSkinFile == null) {
                    blinkIdentifier = null;
                }
                if (blinkSkinFile2 == null) {
                    blink2Identifier = null;
                }
                if ((capeChoice1 = choiceBoxChoices[4]) >= 1 && capeChoice1 <= 4) {
                    switch (capeChoice1) {
                        case 1: {
                            this.capeType = ETFConfigScreenSkinTool.CapeType.CUSTOM;
                            modifiedCape.method_4317(ETFPlayerTexture.returnCustomTexturedCape(this.originalSkin));
                            break;
                        }
                        case 2: {
                            this.capeType = ETFConfigScreenSkinTool.CapeType.MINECRAFT_CAPES_NET;
                            modifiedCape = null;
                            this.initiateThirdPartyCapeDownload("https://api.minecraftcapes.net/profile/" + this.player.getUuidAsString().replace("-", "") + "/cape/");
                            break;
                        }
                        case 3: {
                            this.capeType = ETFConfigScreenSkinTool.CapeType.OPTIFINE;
                            modifiedCape = null;
                            this.initiateThirdPartyCapeDownload("https://optifine.net/capes/" + this.player.getName().getString() + ".png");
                            break;
                        }
                        case 4: {
                            this.capeType = ETFConfigScreenSkinTool.CapeType.ETF;
                            class_1011 cape = ETFUtils2.getNativeImageElseNull(new class_2960("entity_texture_features", "textures/capes/etf.png"));
                            if (cape == null || ETFUtils2.isNativeImageEmpty(modifiedCape)) break;
                            modifiedCape.method_4317(cape);
                            break;
                        }
                    }
                }
                if (modifiedCape != null && !ETFUtils2.isNativeImageEmpty(modifiedCape)) {
                    this.etfCapeIdentifier = new class_2960(SKIN_NAMESPACE, id.toString().replaceAll("/[^a-z]/g", "") + "_cape.png");
                    ETFUtils2.registerNativeImageToIdentifier(modifiedCape, this.etfCapeIdentifier);
                }
                List<Integer> markerChoices = List.of(Integer.valueOf(ETFPlayerTexture.getSkinPixelColourToNumber(this.originalSkin.method_4315(1, 17))), Integer.valueOf(ETFPlayerTexture.getSkinPixelColourToNumber(this.originalSkin.method_4315(1, 18))), Integer.valueOf(ETFPlayerTexture.getSkinPixelColourToNumber(this.originalSkin.method_4315(2, 17))), Integer.valueOf(ETFPlayerTexture.getSkinPixelColourToNumber(this.originalSkin.method_4315(2, 18))));
                class_1011 emissiveImage = null;
                class_1011 emissiveBlinkImage = null;
                class_1011 emissiveBlink2Image = null;
                class_2960 emissiveIdentifier = null;
                class_2960 blinkEmissiveIdentifier = null;
                class_2960 blink2EmissiveIdentifier = null;
                this.hasEmissives = markerChoices.contains(1);
                if (this.hasEmissives) {
                    boxChosenBounds = ETFPlayerTexture.getSkinPixelBounds("marker" + (markerChoices.indexOf(1) + 1));
                    this.emissiveCapeBounds = boxChosenBounds;
                    emissiveImage = ETFPlayerTexture.returnMatchPixels(modifiedSkin, boxChosenBounds);
                    if (emissiveImage != null) {
                        class_1011 checkNose;
                        class_1011 checkCape;
                        class_1011 checkCoat;
                        emissiveIdentifier = new class_2960(SKIN_NAMESPACE, id + "_e.png");
                        ETFUtils2.registerNativeImageToIdentifier(emissiveImage, emissiveIdentifier);
                        if (blinkSkinFile != null && (emissiveBlinkImage = ETFPlayerTexture.returnMatchPixels(blinkSkinFile, boxChosenBounds)) != null) {
                            blinkEmissiveIdentifier = new class_2960(SKIN_NAMESPACE, id + "_blink_e.png");
                            ETFUtils2.registerNativeImageToIdentifier(emissiveBlinkImage, blinkEmissiveIdentifier);
                        }
                        if (blinkSkinFile2 != null && (emissiveBlink2Image = ETFPlayerTexture.returnMatchPixels(blinkSkinFile2, boxChosenBounds)) != null) {
                            blink2EmissiveIdentifier = new class_2960(SKIN_NAMESPACE, id + "_blink2_e.png");
                            ETFUtils2.registerNativeImageToIdentifier(emissiveBlink2Image, blink2EmissiveIdentifier);
                        }
                        if (coatSkin != null && (checkCoat = ETFPlayerTexture.returnMatchPixels(modifiedSkin, boxChosenBounds, coatSkin)) != null) {
                            this.coatEmissiveIdentifier = new class_2960(SKIN_NAMESPACE, id + "_coat_e.png");
                            ETFUtils2.registerNativeImageToIdentifier(checkCoat, this.coatEmissiveIdentifier);
                        }
                        if (modifiedCape != null && (checkCape = ETFPlayerTexture.returnMatchPixels(modifiedSkin, boxChosenBounds, modifiedCape)) != null) {
                            this.etfCapeEmissiveIdentifier = new class_2960(SKIN_NAMESPACE, id + "_cape_e.png");
                            ETFUtils2.registerNativeImageToIdentifier(checkCape, this.etfCapeEmissiveIdentifier);
                        }
                        if (noseTexture != null && (checkNose = ETFPlayerTexture.returnMatchPixels(modifiedSkin, boxChosenBounds, noseTexture)) != null) {
                            this.texturedNoseIdentifierEmissive = new class_2960(SKIN_NAMESPACE, id + "_nose_e.png");
                            ETFUtils2.registerNativeImageToIdentifier(checkNose, this.texturedNoseIdentifierEmissive);
                        }
                    } else {
                        this.hasEmissives = false;
                    }
                }
                if (this.capeType == ETFConfigScreenSkinTool.CapeType.ETF) {
                    this.etfCapeEmissiveIdentifier = new class_2960("entity_texture_features", "textures/capes/etf_e.png");
                }
                this.hasEnchant = markerChoices.contains(2);
                if (this.hasEnchant) {
                    boxChosenBounds = ETFPlayerTexture.getSkinPixelBounds("marker" + (markerChoices.indexOf(2) + 1));
                    this.enchantCapeBounds = boxChosenBounds;
                    class_1011 check = ETFPlayerTexture.returnMatchPixels(modifiedSkin, boxChosenBounds);
                    if (check != null) {
                        class_1011 checkNose;
                        class_1011 checkCape;
                        class_1011 checkCoat;
                        class_1011 checkBlink;
                        this.baseEnchantIdentifier = new class_2960(SKIN_NAMESPACE, id + "_enchant.png");
                        ETFUtils2.registerNativeImageToIdentifier(check, this.baseEnchantIdentifier);
                        if (blinkSkinFile != null && (checkBlink = ETFPlayerTexture.returnMatchPixels(blinkSkinFile, boxChosenBounds)) != null) {
                            this.baseEnchantBlinkIdentifier = new class_2960(SKIN_NAMESPACE, id + "_blink_enchant.png");
                            ETFUtils2.registerNativeImageToIdentifier(checkBlink, this.baseEnchantBlinkIdentifier);
                        }
                        if (blinkSkinFile2 != null && (checkBlink = ETFPlayerTexture.returnMatchPixels(blinkSkinFile2, boxChosenBounds)) != null) {
                            this.baseEnchantBlink2Identifier = new class_2960(SKIN_NAMESPACE, id + "_blink2_enchant.png");
                            ETFUtils2.registerNativeImageToIdentifier(checkBlink, this.baseEnchantBlink2Identifier);
                        }
                        if (coatSkin != null && (checkCoat = ETFPlayerTexture.returnMatchPixels(modifiedSkin, boxChosenBounds, coatSkin)) != null) {
                            this.coatEnchantedIdentifier = new class_2960(SKIN_NAMESPACE, id + "_coat_enchant.png");
                            ETFUtils2.registerNativeImageToIdentifier(checkCoat, this.coatEnchantedIdentifier);
                        }
                        if (modifiedCape != null && (checkCape = ETFPlayerTexture.returnMatchPixels(modifiedSkin, boxChosenBounds, modifiedCape)) != null) {
                            this.etfCapeEnchantedIdentifier = new class_2960(SKIN_NAMESPACE, id + "_cape_enchant.png");
                            ETFUtils2.registerNativeImageToIdentifier(checkCape, this.etfCapeEnchantedIdentifier);
                        }
                        if (noseTexture != null && (checkNose = ETFPlayerTexture.returnMatchPixels(modifiedSkin, boxChosenBounds, noseTexture)) != null) {
                            this.texturedNoseIdentifierEnchanted = new class_2960(SKIN_NAMESPACE, id + "_nose_enchant.png");
                            ETFUtils2.registerNativeImageToIdentifier(checkNose, this.texturedNoseIdentifierEnchanted);
                        }
                    } else {
                        this.hasEnchant = false;
                    }
                }
                ETFPlayerTexture.parseSkinTransparency(modifiedSkin, this.wasForcedSolid);
                class_2960 modifiedSkinBlinkPatchedIdentifier = null;
                class_2960 modifiedSkinPatchedIdentifier = null;
                class_2960 modifiedSkinBlink2PatchedIdentifier = null;
                if (ETFClientCommon.ETFConfigData.removePixelsUnderEmissivePlayers && emissiveImage != null) {
                    modifiedSkinPatchedIdentifier = new class_2960(SKIN_NAMESPACE, id + "_e_patched.png");
                    ETFTexture.patchTextureToRemoveZFightingWithOtherTexture(modifiedSkin, emissiveImage);
                    ETFUtils2.registerNativeImageToIdentifier(modifiedSkin, modifiedSkinPatchedIdentifier);
                    if (blinkSkinFile != null) {
                        modifiedSkinBlinkPatchedIdentifier = new class_2960(SKIN_NAMESPACE, id + "_blink_e_patched.png");
                        ETFTexture.patchTextureToRemoveZFightingWithOtherTexture(blinkSkinFile, emissiveBlinkImage);
                        ETFUtils2.registerNativeImageToIdentifier(blinkSkinFile, modifiedSkinBlinkPatchedIdentifier);
                    }
                    if (blinkSkinFile2 != null) {
                        modifiedSkinBlink2PatchedIdentifier = new class_2960(SKIN_NAMESPACE, id + "_blink2_e_patched.png");
                        ETFTexture.patchTextureToRemoveZFightingWithOtherTexture(blinkSkinFile2, emissiveBlink2Image);
                        ETFUtils2.registerNativeImageToIdentifier(blinkSkinFile2, modifiedSkinBlink2PatchedIdentifier);
                    }
                }
                class_2960 modifiedSkinIdentifier = new class_2960(SKIN_NAMESPACE, id + ".png");
                ETFUtils2.registerNativeImageToIdentifier(modifiedSkin, modifiedSkinIdentifier);
                this.etfTextureOfFinalBaseSkin = new ETFTexture(modifiedSkinIdentifier, blinkIdentifier, blink2Identifier, emissiveIdentifier, blinkEmissiveIdentifier, blink2EmissiveIdentifier, modifiedSkinPatchedIdentifier, modifiedSkinBlinkPatchedIdentifier, modifiedSkinBlink2PatchedIdentifier);
                if (this.capeType == ETFConfigScreenSkinTool.CapeType.NONE && this.etfCapeIdentifier != null && this.etfCapeEnchantedIdentifier == null && this.etfCapeEmissiveIdentifier == null) {
                    this.etfCapeIdentifier = null;
                }
                if (modifiedCape != null) {
                    modifiedCape.close();
                }
                modifiedSkin.close();
            } else if (ETFClientCommon.ETFConfigData.tryETFTransparencyForAllSkins) {
                class_2960 skinIdentifier = new class_2960(SKIN_NAMESPACE, id + ".png");
                ETFUtils2.registerNativeImageToIdentifier(this.originalSkin, skinIdentifier);
                this.etfTextureOfFinalBaseSkin = new ETFTexture(skinIdentifier, null, null, null, null, null, null, null, null);
            } else {
                this.skinFailed();
            }
        } else {
            this.skinFailed();
        }
        this.isTextureReady = true;
    }

    public void changeSkinToThisForTool(class_1011 image) {
        this.etfCapeEmissiveIdentifier = null;
        this.etfCapeIdentifier = null;
        this.baseEnchantBlinkIdentifier = null;
        this.etfCapeEnchantedIdentifier = null;
        this.baseEnchantIdentifier = null;
        this.coatEmissiveIdentifier = null;
        this.coatEnchantedIdentifier = null;
        this.baseEnchantBlink2Identifier = null;
        this.etfTextureOfFinalBaseSkin = null;
        this.coatIdentifier = null;
        this.hasEmissives = false;
        this.hasEnchant = false;
        this.hasFatCoat = false;
        this.hasFeatures = false;
        this.hasVillagerNose = false;
        this.isTextureReady = false;
        this.coatStyle = 0;
        this.coatLength = 1;
        this.blinkHeight = 1;
        this.blinkType = 0;
        this.capeType = ETFConfigScreenSkinTool.CapeType.NONE;
        this.texturedNoseIdentifier = null;
        this.texturedNoseIdentifierEmissive = null;
        this.texturedNoseIdentifierEnchanted = null;
        this.noseType = ETFConfigScreenSkinTool.NoseType.NONE;
        this.originalSkin = image;
        this.checkTexture(true);
    }
}

