/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.ui.component;

import java.awt.Color;
import java.util.Arrays;
import java.util.List;
import java.util.Stack;
import java.util.stream.Collectors;
import journeymap.client.Constants;
import journeymap.client.render.RenderWrapper;
import journeymap.client.render.draw.DrawUtil;
import journeymap.client.texture.Texture;
import journeymap.client.texture.TextureCache;
import journeymap.client.ui.UIManager;
import journeymap.client.ui.component.Button;
import journeymap.common.Journeymap;
import journeymap.common.accessors.ScreenAccess;
import journeymap.common.log.LogFormatter;
import net.minecraft.class_1921;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_4068;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_5481;
import org.apache.logging.log4j.Logger;

public abstract class JmUI
extends class_437
implements ScreenAccess {
    protected final String title;
    protected final int headerHeight = 35;
    protected final Logger logger = Journeymap.getLogger();
    protected int scaleFactor = 1;
    protected Texture logo = TextureCache.getTexture(TextureCache.Logo);
    protected static Stack<class_437> returnDisplayStack = new Stack();
    protected boolean renderBottomBar = false;

    public JmUI(String title) {
        this(title, null);
    }

    public JmUI(String title, class_437 returnDisplay) {
        super((class_2561)Constants.getStringTextComponent(title));
        this.title = title;
        returnDisplayStack.push(returnDisplay);
    }

    public class_310 getMinecraft() {
        this.field_22787 = class_310.method_1551();
        return this.field_22787;
    }

    public void method_25423(class_310 minecraft, int width, int height) {
        super.method_25423(minecraft, width, height);
        this.scaleFactor = (int)minecraft.method_22683().method_4495();
    }

    public boolean method_25421() {
        return true;
    }

    public class_327 getFontRenderer() {
        return this.field_22793;
    }

    public void sizeDisplay(class_4587 poseStack, boolean scaled) {
        int glwidth = scaled ? this.field_22789 : this.field_22787.method_22683().method_4480();
        int glheight = scaled ? this.field_22790 : this.field_22787.method_22683().method_4507();
        DrawUtil.sizeDisplay(poseStack, glwidth, glheight);
    }

    protected boolean isMouseOverButton(double mouseX, double mouseY) {
        for (int k = 0; k < this.getRenderables().size(); ++k) {
            Button button;
            class_4185 guibutton = (class_4185)this.getRenderables().get(k);
            if (!(guibutton instanceof Button) || !(button = (Button)guibutton).mouseOver(mouseX, mouseY)) continue;
            return true;
        }
        return false;
    }

    public boolean method_25406(double mouseX, double mouseY, int mouseEvent) {
        return super.method_25406(mouseX, mouseY, mouseEvent);
    }

    protected void drawLogo(class_4587 poseStack) {
        if (!this.logo.hasImage()) {
            this.logo = TextureCache.getTexture(TextureCache.Logo);
        }
        DrawUtil.sizeDisplay(poseStack, this.field_22787.method_22683().method_4480(), this.field_22787.method_22683().method_4507());
        DrawUtil.drawImage(poseStack, this.logo, 8.0, 8.0, false, 0.5f, 0.0);
        DrawUtil.sizeDisplay(poseStack, this.field_22789, this.field_22790);
    }

    protected void renderBottomBar(class_4587 stack) {
        if (this.renderBottomBar) {
            DrawUtil.drawRectangle(stack, 0.0, this.field_22790 - 30, this.field_22789, this.field_22790, 0, 0.6f);
        }
    }

    protected void drawTitle(class_332 graphics) {
        DrawUtil.drawRectangle(graphics.method_51448(), 0.0, 0.0, this.field_22789, 35.0, 0, 0.9f);
        DrawUtil.drawLabel(graphics, this.title, this.field_22789 / 2, 17.0, DrawUtil.HAlign.Center, DrawUtil.VAlign.Middle, 0, 0.0f, Color.CYAN.getRGB(), 1.0f, 1.0, true, 0.0);
        String apiVersion = "API v1.9-SNAPSHOT";
        DrawUtil.drawLabel(graphics, apiVersion, this.field_22789 - 10, 17.0, DrawUtil.HAlign.Left, DrawUtil.VAlign.Middle, 0, 0.0f, 0xCCCCCC, 1.0f, 0.5, true, 0.0);
    }

    public void method_25426() {
        this.getRenderables().clear();
    }

    public void method_25420(class_332 guiGraphics, int i, int j, float f) {
        if (class_310.method_1551().field_1687 == null) {
            this.drawGradientRect(guiGraphics, 0, 0, this.field_22789, this.field_22790, -1072689136, -804253680, 0);
        } else {
            super.method_25420(guiGraphics, i, j, f);
        }
    }

    protected abstract void layoutButtons(class_332 var1);

    public List getButtonList() {
        return this.getRenderables();
    }

    public void method_25394(class_332 guiGraphics, int x, int y, float partialTicks) {
        try {
            class_4587 poseStack = guiGraphics.method_51448();
            this.method_25420(guiGraphics, x, y, partialTicks);
            this.renderBottomBar(poseStack);
            this.layoutButtons(guiGraphics);
            this.drawTitle(guiGraphics);
            this.drawLogo(poseStack);
            List<class_5481> tooltip = null;
            for (int k = 0; k < this.getRenderables().size(); ++k) {
                Button button;
                class_4185 guibutton = (class_4185)this.getRenderables().get(k);
                guibutton.method_25394(guiGraphics, x, y, 0.0f);
                if (tooltip != null || !(guibutton instanceof Button) || !(button = (Button)guibutton).mouseOver(x, y)) continue;
                tooltip = button.getFormattedTooltip();
            }
            if (tooltip != null && !tooltip.isEmpty()) {
                this.renderWrappedToolTip(guiGraphics, tooltip, x, y, this.getFontRenderer());
            }
        }
        catch (Throwable t) {
            Journeymap.getLogger().error("Error in UI: " + LogFormatter.toString(t));
            this.closeAndReturn();
        }
    }

    public void drawGradientRect(class_332 guiGraphics, int pX1, int pY1, int pX2, int pY2, int pColorFrom, int pColorTo, int pBlitOffset) {
        guiGraphics.method_51740(class_1921.method_51785(), pX1, pY1, pX2, pY2, pColorFrom, pColorTo, pBlitOffset);
    }

    public void close() {
    }

    protected void closeAndReturn() {
        if (returnDisplayStack == null || returnDisplayStack.peek() == null) {
            if (this.field_22787.field_1687 != null) {
                UIManager.INSTANCE.openFullscreenMap();
            } else {
                UIManager.INSTANCE.closeAll();
            }
        } else {
            UIManager.INSTANCE.open(returnDisplayStack.pop());
        }
    }

    public boolean method_25400(char c, int i) {
        return super.method_25400(c, i);
    }

    public void setRenderBottomBar(boolean renderBottomBar) {
        this.renderBottomBar = renderBottomBar;
    }

    public boolean method_25404(int key, int value, int modifier) {
        switch (key) {
            case 256: {
                this.closeAndReturn();
                return true;
            }
        }
        return super.method_25404(key, value, modifier);
    }

    public void renderTooltip(class_332 graphics, String[] tooltip, int mouseX, int mouseY) {
        List tooltips = Arrays.stream(tooltip).map(e -> class_5481.method_30747((String)e, (class_2583)class_2583.field_24360)).collect(Collectors.toList());
        this.renderWrappedToolTip(graphics, tooltips, mouseX, mouseY, this.getFontRenderer());
    }

    public class_437 getReturnDisplay() {
        return returnDisplayStack.peek();
    }

    public void renderWrappedToolTip(class_332 graphics, List tooltip, int mouseX, int mouseY, class_327 fontRenderer) {
        if (!tooltip.isEmpty() && tooltip.get(0) instanceof class_5481 && class_310.method_1551().field_1755 == this) {
            RenderWrapper.disableDepthTest();
            int maxLineWidth = 0;
            for (class_5481 line : tooltip) {
                int lineWidth = fontRenderer.method_30880(line);
                if (fontRenderer.method_1726()) {
                    lineWidth = (int)Math.ceil((double)lineWidth * 1.25);
                }
                if (lineWidth <= maxLineWidth) continue;
                maxLineWidth = lineWidth;
            }
            int drawX = mouseX + 12;
            int drawY = mouseY - 12;
            int boxHeight = 8;
            if (tooltip.size() > 1) {
                boxHeight += 2 + (tooltip.size() - 1) * 10;
            }
            if (drawX + maxLineWidth > this.field_22789) {
                drawX -= 28 + maxLineWidth;
            }
            if (drawY + boxHeight + 6 > this.field_22790) {
                drawY = this.field_22790 - boxHeight - 6;
            }
            int j1 = -267386864;
            this.drawGradientRect(graphics, drawX - 3, drawY - 4, drawX + maxLineWidth + 3, drawY - 3, j1, j1, 300);
            this.drawGradientRect(graphics, drawX - 3, drawY + boxHeight + 3, drawX + maxLineWidth + 3, drawY + boxHeight + 4, j1, j1, 300);
            this.drawGradientRect(graphics, drawX - 3, drawY - 3, drawX + maxLineWidth + 3, drawY + boxHeight + 3, j1, j1, 300);
            this.drawGradientRect(graphics, drawX - 4, drawY - 3, drawX - 3, drawY + boxHeight + 3, j1, j1, 300);
            this.drawGradientRect(graphics, drawX + maxLineWidth + 3, drawY - 3, drawX + maxLineWidth + 4, drawY + boxHeight + 3, j1, j1, 300);
            int k1 = 0x505000FF;
            int l1 = (k1 & 0xFEFEFE) >> 1 | k1 & 0xFF000000;
            this.drawGradientRect(graphics, drawX - 3, drawY - 3 + 1, drawX - 3 + 1, drawY + boxHeight + 3 - 1, k1, l1, 300);
            this.drawGradientRect(graphics, drawX + maxLineWidth + 2, drawY - 3 + 1, drawX + maxLineWidth + 3, drawY + boxHeight + 3 - 1, k1, l1, 300);
            this.drawGradientRect(graphics, drawX - 3, drawY - 3, drawX + maxLineWidth + 3, drawY - 3 + 1, k1, k1, 300);
            this.drawGradientRect(graphics, drawX - 3, drawY + boxHeight + 2, drawX + maxLineWidth + 3, drawY + boxHeight + 3, l1, l1, 300);
            for (int i2 = 0; i2 < tooltip.size(); ++i2) {
                class_5481 line = (class_5481)tooltip.get(i2);
                if (fontRenderer.method_1726()) {
                    int lineWidth = (int)Math.ceil((double)fontRenderer.method_30880(line) * 1.1);
                    fontRenderer.method_22942(line, (float)(drawX + maxLineWidth - lineWidth), (float)drawY, -1, true, graphics.method_51448().method_23760().method_23761(), (class_4597)graphics.method_51450(), class_327.class_6415.field_33994, 0, 0xF000F0);
                } else {
                    fontRenderer.method_22942(line, (float)drawX, (float)drawY, -1, true, graphics.method_51448().method_23760().method_23761(), (class_4597)graphics.method_51450(), class_327.class_6415.field_33994, 0, 0xF000F0);
                }
                if (i2 == 0) {
                    drawY += 2;
                }
                drawY += 10;
            }
            RenderWrapper.enableDepthTest();
        }
    }

    @Override
    public List<class_4068> getRenderables() {
        return this.field_33816;
    }
}

