/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.impl.registry.sync;

import com.google.common.base.Joiner;
import com.google.common.collect.Sets;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.objects.Object2IntLinkedOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.function.Consumer;
import net.fabricmc.fabric.api.event.registry.RegistryAttribute;
import net.fabricmc.fabric.api.event.registry.RegistryAttributeHolder;
import net.fabricmc.fabric.api.networking.v1.ServerConfigurationNetworking;
import net.fabricmc.fabric.impl.registry.sync.RemapException;
import net.fabricmc.fabric.impl.registry.sync.RemappableRegistry;
import net.fabricmc.fabric.impl.registry.sync.packet.DirectRegistryPacketHandler;
import net.fabricmc.fabric.impl.registry.sync.packet.RegistryPacketHandler;
import net.minecraft.class_124;
import net.minecraft.class_1255;
import net.minecraft.class_2378;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2596;
import net.minecraft.class_2960;
import net.minecraft.class_5250;
import net.minecraft.class_5321;
import net.minecraft.class_7923;
import net.minecraft.class_8605;
import net.minecraft.class_8610;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RegistrySyncManager {
    public static final boolean DEBUG = Boolean.getBoolean("fabric.registry.debug");
    public static final RegistryPacketHandler DIRECT_PACKET_HANDLER = new DirectRegistryPacketHandler();
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"FabricRegistrySync");
    private static final boolean DEBUG_WRITE_REGISTRY_DATA = Boolean.getBoolean("fabric.registry.debug.writeContentsAsCsv");
    public static boolean postBootstrap = false;

    private RegistrySyncManager() {
    }

    public static void configureClient(class_8610 handler, MinecraftServer server) {
        if (!DEBUG && server.method_19466(handler.method_52404())) {
            return;
        }
        if (!ServerConfigurationNetworking.canSend((class_8610)handler, (class_2960)DIRECT_PACKET_HANDLER.getPacketId())) {
            return;
        }
        Map<class_2960, Object2IntMap<class_2960>> map = RegistrySyncManager.createAndPopulateRegistryMap();
        if (map == null) {
            return;
        }
        handler.addTask((class_8605)new SyncConfigurationTask(handler, map));
    }

    public static CompletableFuture<Boolean> receivePacket(class_1255<?> executor, RegistryPacketHandler handler, class_2540 buf, boolean accept) {
        handler.receivePacket(buf);
        if (!handler.isPacketFinished()) {
            return CompletableFuture.completedFuture(false);
        }
        if (DEBUG) {
            String handlerName = handler.getClass().getSimpleName();
            LOGGER.info("{} total packet: {}", (Object)handlerName, (Object)handler.getTotalPacketReceived());
            LOGGER.info("{} raw size: {}", (Object)handlerName, (Object)handler.getRawBufSize());
            LOGGER.info("{} deflated size: {}", (Object)handlerName, (Object)handler.getDeflatedBufSize());
        }
        Map<class_2960, Object2IntMap<class_2960>> map = handler.getSyncedRegistryMap();
        if (!accept) {
            return CompletableFuture.completedFuture(true);
        }
        return executor.method_5385(() -> {
            if (map == null) {
                throw new CompletionException(new RemapException("Received null map in sync packet!"));
            }
            try {
                RegistrySyncManager.apply(map, RemappableRegistry.RemapMode.REMOTE);
                return true;
            }
            catch (RemapException e) {
                throw new CompletionException(e);
            }
        });
    }

    @Nullable
    public static Map<class_2960, Object2IntMap<class_2960>> createAndPopulateRegistryMap() {
        LinkedHashMap<class_2960, Object2IntMap<class_2960>> map = new LinkedHashMap<class_2960, Object2IntMap<class_2960>>();
        for (class_2960 registryId : class_7923.field_41167.method_10235()) {
            RegistryAttributeHolder attributeHolder;
            class_2378 registry = (class_2378)class_7923.field_41167.method_10223(registryId);
            if (DEBUG_WRITE_REGISTRY_DATA) {
                File location = new File(".fabric" + File.separatorChar + "debug" + File.separatorChar + "registry");
                boolean c = true;
                if (!location.exists() && !location.mkdirs()) {
                    LOGGER.warn("[fabric-registry-sync debug] Could not create " + location.getAbsolutePath() + " directory!");
                    c = false;
                }
                if (c && registry != null) {
                    File file = new File(location, registryId.toString().replace(':', '.').replace('/', '.') + ".csv");
                    try (FileOutputStream stream = new FileOutputStream(file);){
                        StringBuilder builder = new StringBuilder("Raw ID,String ID,Class Type\n");
                        for (Object o : registry) {
                            String classType = o == null ? "null" : o.getClass().getName();
                            class_2960 id = registry.method_10221(o);
                            if (id == null) continue;
                            int rawId = registry.method_10206(o);
                            String stringId = id.toString();
                            builder.append("\"").append(rawId).append("\",\"").append(stringId).append("\",\"").append(classType).append("\"\n");
                        }
                        stream.write(builder.toString().getBytes(StandardCharsets.UTF_8));
                    }
                    catch (IOException e) {
                        LOGGER.warn("[fabric-registry-sync debug] Could not write to " + file.getAbsolutePath() + "!", (Throwable)e);
                    }
                }
            }
            if (!(attributeHolder = RegistryAttributeHolder.get(registry.method_30517())).hasAttribute(RegistryAttribute.SYNCED)) {
                LOGGER.debug("Not syncing registry: {}", (Object)registryId);
                continue;
            }
            if (!attributeHolder.hasAttribute(RegistryAttribute.MODDED)) {
                LOGGER.debug("Skipping un-modded registry: " + String.valueOf(registryId));
                continue;
            }
            LOGGER.debug("Syncing registry: " + String.valueOf(registryId));
            if (!(registry instanceof RemappableRegistry)) continue;
            Object2IntLinkedOpenHashMap idMap = new Object2IntLinkedOpenHashMap();
            IntOpenHashSet rawIdsFound = DEBUG ? new IntOpenHashSet() : null;
            for (Object o : registry) {
                class_2960 id = registry.method_10221(o);
                if (id == null) continue;
                int rawId = registry.method_10206(o);
                if (DEBUG) {
                    if (registry.method_10223(id) != o) {
                        LOGGER.error("[fabric-registry-sync] Inconsistency detected in " + String.valueOf(registryId) + ": object " + String.valueOf(o) + " -> string ID " + String.valueOf(id) + " -> object " + String.valueOf(registry.method_10223(id)) + "!");
                    }
                    if (registry.method_10200(rawId) != o) {
                        LOGGER.error("[fabric-registry-sync] Inconsistency detected in " + String.valueOf(registryId) + ": object " + String.valueOf(o) + " -> integer ID " + rawId + " -> object " + String.valueOf(registry.method_10200(rawId)) + "!");
                    }
                    if (!rawIdsFound.add(rawId)) {
                        LOGGER.error("[fabric-registry-sync] Inconsistency detected in " + String.valueOf(registryId) + ": multiple objects hold the raw ID " + rawId + " (this one is " + String.valueOf(id) + ")");
                    }
                }
                idMap.put((Object)id, rawId);
            }
            map.put(registryId, (Object2IntMap<class_2960>)idMap);
        }
        if (map.isEmpty()) {
            return null;
        }
        return map;
    }

    public static void apply(Map<class_2960, Object2IntMap<class_2960>> map, RemappableRegistry.RemapMode mode) throws RemapException {
        if (mode == RemappableRegistry.RemapMode.REMOTE) {
            RegistrySyncManager.checkRemoteRemap(map);
        }
        HashSet containedRegistries = Sets.newHashSet(map.keySet());
        for (class_2960 registryId : class_7923.field_41167.method_10235()) {
            if (!containedRegistries.remove(registryId)) continue;
            Object2IntMap<class_2960> registryMap = map.get(registryId);
            class_2378 registry = (class_2378)class_7923.field_41167.method_10223(registryId);
            RegistryAttributeHolder attributeHolder = RegistryAttributeHolder.get(registry.method_30517());
            if (!attributeHolder.hasAttribute(RegistryAttribute.MODDED)) {
                LOGGER.debug("Not applying registry data to vanilla registry {}", (Object)registryId.toString());
                continue;
            }
            if (!(registry instanceof RemappableRegistry)) continue;
            Object2IntOpenHashMap idMap = new Object2IntOpenHashMap();
            for (class_2960 key : registryMap.keySet()) {
                idMap.put((Object)key, registryMap.getInt((Object)key));
            }
            ((RemappableRegistry)registry).remap(registryId.toString(), (Object2IntMap<class_2960>)idMap, mode);
        }
        if (!containedRegistries.isEmpty()) {
            LOGGER.warn("[fabric-registry-sync] Could not find the following registries: " + Joiner.on((String)", ").join((Iterable)containedRegistries));
        }
    }

    @VisibleForTesting
    public static void checkRemoteRemap(Map<class_2960, Object2IntMap<class_2960>> map) throws RemapException {
        HashMap<class_2960, List> missingEntries = new HashMap<class_2960, List>();
        for (Map.Entry entry : class_7923.field_41167.method_29722()) {
            class_2378 registry = (class_2378)entry.getValue();
            class_2960 registryId = ((class_5321)entry.getKey()).method_29177();
            Object2IntMap<class_2960> remoteRegistry = map.get(registryId);
            if (remoteRegistry == null) continue;
            for (class_2960 remoteId : remoteRegistry.keySet()) {
                if (registry.method_10250(remoteId)) continue;
                missingEntries.computeIfAbsent(registryId, i -> new ArrayList()).add(remoteId);
            }
        }
        if (missingEntries.isEmpty()) {
            return;
        }
        LOGGER.error("Received unknown remote registry entries from server");
        for (Map.Entry entry : missingEntries.entrySet()) {
            for (class_2960 identifier : (List)entry.getValue()) {
                LOGGER.error("Registry entry ({}) is missing from local registry ({})", (Object)identifier, entry.getKey());
            }
        }
        class_5250 text = class_2561.method_43470((String)"");
        int n = missingEntries.values().stream().mapToInt(List::size).sum();
        text = n == 1 ? text.method_10852((class_2561)class_2561.method_43471((String)"fabric-registry-sync-v0.unknown-remote.title.singular")) : text.method_10852((class_2561)class_2561.method_43469((String)"fabric-registry-sync-v0.unknown-remote.title.plural", (Object[])new Object[]{n}));
        text = text.method_10852((class_2561)class_2561.method_43471((String)"fabric-registry-sync-v0.unknown-remote.subtitle.1").method_27692(class_124.field_1060));
        text = text.method_10852((class_2561)class_2561.method_43471((String)"fabric-registry-sync-v0.unknown-remote.subtitle.2"));
        int toDisplay = 4;
        List<String> namespaces = missingEntries.values().stream().flatMap(Collection::stream).map(class_2960::method_12836).distinct().sorted().toList();
        for (int i2 = 0; i2 < Math.min(namespaces.size(), 4); ++i2) {
            text = text.method_10852((class_2561)class_2561.method_43470((String)namespaces.get(i2)).method_27692(class_124.field_1054));
            text = text.method_27693("\n");
        }
        if (namespaces.size() > 4) {
            text = text.method_10852((class_2561)class_2561.method_43469((String)"fabric-registry-sync-v0.unknown-remote.footer", (Object[])new Object[]{namespaces.size() - 4}));
        }
        throw new RemapException((class_2561)text);
    }

    public static void unmap() throws RemapException {
        for (class_2960 registryId : class_7923.field_41167.method_10235()) {
            class_2378 registry = (class_2378)class_7923.field_41167.method_10223(registryId);
            if (!(registry instanceof RemappableRegistry)) continue;
            ((RemappableRegistry)registry).unmap(registryId.toString());
        }
    }

    public static void bootstrapRegistries() {
        postBootstrap = true;
    }

    public record SyncConfigurationTask(class_8610 handler, Map<class_2960, Object2IntMap<class_2960>> map) implements class_8605
    {
        public static final class_8605.class_8606 KEY = new class_8605.class_8606("fabric:registry/sync");

        public void method_52376(Consumer<class_2596<?>> sender) {
            DIRECT_PACKET_HANDLER.sendPacket(arg_0 -> ((class_8610)this.handler).method_14364(arg_0), this.map);
        }

        public class_8605.class_8606 method_52375() {
            return KEY;
        }
    }
}

